/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.kotlin.idea.run.KotlinRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.run.MultiplatformGradleProjectTaskRunnerKt;
import org.jetbrains.plugins.gradle.execution.build.GradleProjectTaskRunner;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/run/MultiplatformGradleProjectTaskRunner;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner;", "()V", "canRun", "", "projectTask", "Lcom/intellij/task/ProjectTask;", "run", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/task/ProjectTaskContext;", "callback", "Lcom/intellij/task/ProjectTaskNotification;", "tasks", "", "replaceModule", "origin", "Lcom/intellij/openapi/module/Module;", "replacement", "idea-gradle"})
public final class MultiplatformGradleProjectTaskRunner
extends GradleProjectTaskRunner {
    public boolean canRun(@NotNull ProjectTask projectTask) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)projectTask, (String)"projectTask");
        ProjectTask projectTask2 = projectTask;
        if (projectTask2 instanceof ModuleBuildTask) {
            Module module = ((ModuleBuildTask)projectTask).getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"projectTask.module");
            bl = MultiplatformGradleProjectTaskRunnerKt.access$isMultiplatformModule(module);
        } else if (projectTask2 instanceof ExecuteRunConfigurationTask) {
            RunProfile runProfile = ((ExecuteRunConfigurationTask)projectTask).getRunProfile();
            if (runProfile instanceof ModuleBasedConfiguration) {
                RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)runProfile).getConfigurationModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"runProfile.configurationModule");
                Module module = runConfigurationModule.getModule();
                bl = module != null && MultiplatformGradleProjectTaskRunnerKt.access$isMultiplatformModule(module);
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull Project project, @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback2, @NotNull Collection<? extends ProjectTask> tasks) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(tasks, (String)"tasks");
        RunConfiguration configuration2 = context.getRunConfiguration();
        if (configuration2 instanceof ModuleBasedConfiguration && (((ModuleBasedConfiguration)configuration2).getConfigurationModule() instanceof JavaRunConfigurationModule || configuration2 instanceof KotlinRunConfiguration)) {
            Module implModule;
            Module module;
            RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)configuration2).getConfigurationModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"configuration.configurationModule");
            Module module2 = module = runConfigurationModule.getModule();
            if (Intrinsics.areEqual(module2 != null ? PlatformKt.getTargetPlatform(module2) : null, (Object)TargetPlatformKind.Common.INSTANCE) && (implModule = KotlinRunConfigurationProducerKt.findJvmImplementationModule(module)) != null) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)tasks;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    ProjectTask projectTask = (ProjectTask)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    ProjectTask projectTask2 = this.replaceModule((ProjectTask)it, module, implModule);
                    collection.add(projectTask2);
                }
                List replacedTasks = (List)destination$iv$iv;
                super.run(project, context, callback2, (Collection)replacedTasks);
                return;
            }
        }
        super.run(project, context, callback2, tasks);
    }

    private final ProjectTask replaceModule(@NotNull ProjectTask $receiver, Module origin, Module replacement2) {
        ProjectTask projectTask = $receiver;
        return projectTask instanceof ModuleFilesBuildTask ? $receiver : (projectTask instanceof ModuleBuildTask ? (ProjectTask)(Intrinsics.areEqual((Object)((ModuleBuildTask)$receiver).getModule(), (Object)origin) ? (ModuleBuildTask)new ModuleBuildTaskImpl(replacement2, ((ModuleBuildTask)$receiver).isIncrementalBuild(), ((ModuleBuildTask)$receiver).isIncludeDependentModules(), ((ModuleBuildTask)$receiver).isIncludeRuntimeDependencies()) : (ModuleBuildTask)$receiver) : $receiver);
    }
}

