/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.KotlinBinaryExtension;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n\u001a\n\u0010\u0014\u001a\u00020\u0011*\u00020\u0015\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiElement;", "getModule", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/module/Module;", "rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFileSystemItem;", "getSourceRoot", "(Lcom/intellij/psi/PsiFileSystemItem;)Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isInSourceContentWithoutInjected", "", "Lcom/intellij/openapi/roots/FileIndex;", "file", "isKotlinBinary", "Lcom/intellij/openapi/fileTypes/FileType;", "idea-core"})
public final class ProjectRootsUtilKt {
    public static final boolean isKotlinBinary(@NotNull FileType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KotlinBinaryExtension.Companion.getKotlinBinaries().contains($receiver);
    }

    public static final boolean isInSourceContentWithoutInjected(@NotNull FileIndex $receiver, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return !(file2 instanceof VirtualFileWindow) && $receiver.isInSourceContent(file2);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull VirtualFile $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        return projectRootManager.getFileIndex().getSourceRootForFile($receiver);
    }

    @Nullable
    public static final VirtualFile getSourceRoot(@NotNull PsiFileSystemItem $receiver) {
        VirtualFile virtualFile2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        VirtualFile virtualFile3 = $receiver.getVirtualFile();
        if (virtualFile3 != null) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            virtualFile2 = ProjectRootsUtilKt.getSourceRoot(virtualFile3, project);
        } else {
            virtualFile2 = null;
        }
        return virtualFile2;
    }

    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
        return moduleRootManager;
    }

    @Nullable
    public static final Module getModule(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)$receiver);
    }
}

