/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;

class JsPrecedenceVisitor
extends JsVisitor {
    static final int PRECEDENCE_NEW = 15;
    private int answer = -1;

    private JsPrecedenceVisitor() {
    }

    public static int exec(JsExpression expression2) {
        JsPrecedenceVisitor visitor2 = new JsPrecedenceVisitor();
        visitor2.accept(expression2);
        if (visitor2.answer < 0) {
            throw new RuntimeException("Precedence must be >= 0!");
        }
        return visitor2.answer;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        this.answer = 16;
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitBoolean(@NotNull JsBooleanLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        this.answer = 3;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        this.answer = 17;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        this.answer = 16;
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        this.answer = nameRef.isLeaf() ? 17 : 16;
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        this.answer = 15;
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitInt(@NotNull JsIntLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitDouble(@NotNull JsDoubleLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        this.answer = x.getOperator().getPrecedence();
    }

    @Override
    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x) {
        this.answer = 17;
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        this.answer = 17;
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        this.answer = 17;
    }

    @Override
    public void visitThis(@NotNull JsThisRef x) {
        this.answer = 17;
    }

    @Override
    protected void visitElement(@NotNull JsNode node) {
        throw new RuntimeException("Only expressions have precedence.");
    }
}

