/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.resolve.calls.KotlinCallResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.components.KotlinCallCompleter;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.NewOverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.GivenCandidate;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactoryProviderForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.KnownResultProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.PrioritizedCompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerResolver;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J>\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ>\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00142\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/calls/KotlinCallResolver;", "", "towerResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;", "kotlinCallCompleter", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "overloadingConflictResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/NewOverloadingConflictResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;Lorg/jetbrains/kotlin/resolve/calls/components/NewOverloadingConflictResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "choseMostSpecific", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidateFactory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "resolveCall", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "factoryProviderForInvoke", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;", "collectAllCandidates", "", "resolveGivenCandidates", "givenCandidates", "Lorg/jetbrains/kotlin/resolve/calls/model/GivenCandidate;", "resolution"})
public final class KotlinCallResolver {
    private final TowerResolver towerResolver;
    private final KotlinCallCompleter kotlinCallCompleter;
    private final NewOverloadingConflictResolver overloadingConflictResolver;
    private final KotlinCallComponents callComponents;

    @NotNull
    public final CallResolutionResult resolveCall(@NotNull ImplicitScopeTower scopeTower, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull KotlinCall kotlinCall, @Nullable UnwrappedType expectedType2, @NotNull CandidateFactoryProviderForInvoke<KotlinResolutionCandidate> factoryProviderForInvoke, boolean collectAllCandidates) {
        PrioritizedCompositeScopeTowerProcessor prioritizedCompositeScopeTowerProcessor;
        Intrinsics.checkParameterIsNotNull((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        Intrinsics.checkParameterIsNotNull(factoryProviderForInvoke, (String)"factoryProviderForInvoke");
        KotlinCallKt.checkCallInvariants(kotlinCall);
        SimpleCandidateFactory candidateFactory = new SimpleCandidateFactory(this.callComponents, scopeTower, kotlinCall);
        switch (KotlinCallResolver$WhenMappings.$EnumSwitchMapping$0[kotlinCall.getCallKind().ordinal()]) {
            case 1: {
                ReceiverKotlinCallArgument receiverKotlinCallArgument = kotlinCall.getExplicitReceiver();
                prioritizedCompositeScopeTowerProcessor = ScopeTowerProcessorsKt.createVariableAndObjectProcessor$default(scopeTower, kotlinCall.getName(), candidateFactory, receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null, false, 16, null);
                break;
            }
            case 2: {
                ReceiverKotlinCallArgument receiverKotlinCallArgument = kotlinCall.getExplicitReceiver();
                prioritizedCompositeScopeTowerProcessor = ScopeTowerProcessorsKt.createFunctionProcessor(scopeTower, kotlinCall.getName(), candidateFactory, factoryProviderForInvoke, receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null);
                break;
            }
            case 3: {
                throw (Throwable)new UnsupportedOperationException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PrioritizedCompositeScopeTowerProcessor processor2 = prioritizedCompositeScopeTowerProcessor;
        if (collectAllCandidates) {
            Collection<KotlinResolutionCandidate> allCandidates = this.towerResolver.collectAllCandidates(scopeTower, processor2, kotlinCall.getName());
            return this.kotlinCallCompleter.createAllCandidatesResult(allCandidates, expectedType2, resolutionCallbacks);
        }
        Collection<KotlinResolutionCandidate> candidates2 = this.towerResolver.runResolve(scopeTower, processor2, kotlinCall.getCallKind() != KotlinCallKind.UNSUPPORTED, kotlinCall.getName());
        return this.choseMostSpecific(candidateFactory, resolutionCallbacks, expectedType2, candidates2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallResolutionResult resolveGivenCandidates(@NotNull ImplicitScopeTower scopeTower, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull KotlinCall kotlinCall, @Nullable UnwrappedType expectedType2, @NotNull Collection<GivenCandidate> givenCandidates, boolean collectAllCandidates) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkParameterIsNotNull((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCall, (String)"kotlinCall");
        Intrinsics.checkParameterIsNotNull(givenCandidates, (String)"givenCandidates");
        KotlinCallKt.checkCallInvariants(kotlinCall);
        SimpleCandidateFactory candidateFactory = new SimpleCandidateFactory(this.callComponents, scopeTower, kotlinCall);
        Iterable iterable = $receiver$iv = (Iterable)givenCandidates;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GivenCandidate givenCandidate = (GivenCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            KotlinResolutionCandidate kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)candidateFactory.createCandidate((GivenCandidate)it));
            collection.add(kotlinResolutionCandidate);
        }
        List resolutionCandidates = (List)destination$iv$iv;
        if (collectAllCandidates) {
            Collection<KotlinResolutionCandidate> allCandidates = this.towerResolver.runWithEmptyTowerData(new KnownResultProcessor(resolutionCandidates), new TowerResolver.AllCandidatesCollector(), false);
            return this.kotlinCallCompleter.createAllCandidatesResult(allCandidates, expectedType2, resolutionCallbacks);
        }
        Collection<KotlinResolutionCandidate> candidates2 = this.towerResolver.runWithEmptyTowerData(new KnownResultProcessor(resolutionCandidates), new TowerResolver.SuccessfulResultCollector(), true);
        return this.choseMostSpecific(candidateFactory, resolutionCallbacks, expectedType2, candidates2);
    }

    /*
     * WARNING - void declaration
     */
    private final CallResolutionResult choseMostSpecific(SimpleCandidateFactory candidateFactory, KotlinResolutionCallbacks resolutionCallbacks, UnwrappedType expectedType2, Collection<KotlinResolutionCandidate> candidates2) {
        boolean isDebuggerContext = candidateFactory.getScopeTower().isDebuggerContext();
        Collection refinedCandidates = candidates2;
        if (!this.callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.RefinedSamAdaptersPriority)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)candidates2;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KotlinResolutionCandidate it = (KotlinResolutionCandidate)element$iv$iv;
                if (!(!TowerUtilsKt.isSynthesized(it.getResolvedCall().getCandidateDescriptor()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonSynthesized = (List)destination$iv$iv;
            if (!nonSynthesized.isEmpty()) {
                refinedCandidates = nonSynthesized;
            }
        }
        Set<KotlinResolutionCandidate> maximallySpecificCandidates = this.overloadingConflictResolver.chooseMaximallySpecificCandidates(refinedCandidates, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, true, isDebuggerContext);
        return this.kotlinCallCompleter.runCompletion(candidateFactory, (Collection<KotlinResolutionCandidate>)maximallySpecificCandidates, expectedType2, resolutionCallbacks);
    }

    public KotlinCallResolver(@NotNull TowerResolver towerResolver, @NotNull KotlinCallCompleter kotlinCallCompleter, @NotNull NewOverloadingConflictResolver overloadingConflictResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkParameterIsNotNull((Object)towerResolver, (String)"towerResolver");
        Intrinsics.checkParameterIsNotNull((Object)kotlinCallCompleter, (String)"kotlinCallCompleter");
        Intrinsics.checkParameterIsNotNull((Object)overloadingConflictResolver, (String)"overloadingConflictResolver");
        Intrinsics.checkParameterIsNotNull((Object)callComponents, (String)"callComponents");
        this.towerResolver = towerResolver;
        this.kotlinCallCompleter = kotlinCallCompleter;
        this.overloadingConflictResolver = overloadingConflictResolver;
        this.callComponents = callComponents;
    }
}

