/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class ApkData
implements ApkInfo,
VariantOutput {
    private String versionName;
    private int versionCode;
    private AtomicBoolean enabled = new AtomicBoolean(true);
    private String outputFileName;

    @Override
    public Collection<FilterData> getFilters() {
        return ImmutableList.of();
    }

    public Collection<String> getFilterTypes() {
        return this.getFilters().stream().map(FilterData::getFilterType).collect(Collectors.toList());
    }

    public String getFilter(VariantOutput.FilterType filterType) {
        return ApkData.getFilter(this.getFilters(), filterType);
    }

    public String getFilter(String filterType) {
        return ApkData.getFilter(this.getFilters(), VariantOutput.FilterType.valueOf((String)filterType));
    }

    public boolean requiresAapt() {
        return true;
    }

    public abstract String getFilterName();

    public abstract String getBaseName();

    public abstract String getFullName();

    @Override
    public abstract VariantOutput.OutputType getType();

    public abstract String getDirName();

    public void setVersionCode(int versionCode) {
        this.versionCode = versionCode;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Override
    public int getVersionCode() {
        return this.versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("fullName", (Object)this.getFullName()).add("filters", this.getFilters()).toString();
    }

    public OutputFile getMainOutputFile() {
        throw new UnsupportedOperationException("getMainOutputFile is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public Collection<? extends OutputFile> getOutputs() {
        throw new UnsupportedOperationException("getOutputs is no longer supported.  Use getOutputFileName if you need to determine the file name of the output.");
    }

    public String getOutputType() {
        return this.getType().name();
    }

    public static String getFilter(Collection<FilterData> filters, VariantOutput.FilterType filterType) {
        for (FilterData filter2 : filters) {
            if (VariantOutput.FilterType.valueOf((String)filter2.getFilterType()) != filterType) continue;
            return filter2.getIdentifier();
        }
        return null;
    }

    public void disable() {
        this.enabled.set(false);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApkData that = (ApkData)o;
        return this.versionCode == that.versionCode && Objects.equals(this.outputFileName, that.outputFileName) && Objects.equals(this.versionName, that.versionName) && Objects.equals(this.enabled.get(), that.enabled.get());
    }

    public int hashCode() {
        return Objects.hash(this.versionCode, this.enabled.get(), this.versionName, this.outputFileName);
    }
}

