/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.JavaInlayHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "defaultBlackList", "", "", "ignoreOneCharOneDigitHints", "Lcom/intellij/codeInsight/hints/Option;", "getIgnoreOneCharOneDigitHints", "()Lcom/intellij/codeInsight/hints/Option;", "isDoNotShowForBuilderLikeMethods", "isDoNotShowIfMethodNameContainsParameterName", "isShowForParamsWithSameType", "canShowHintsWhenDisabled", "", "getDefaultBlackList", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getMethodInfo", "method", "Lcom/intellij/psi/PsiMethod;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "getSupportedOptions", "Companion", "intellij.java.impl"})
public final class JavaInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    private final Set<String> defaultBlackList = SetsKt.setOf((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "*Exception", "*.set*(*)", "*.add(*)", "*.set(*,*)", "*.get(*)", "*.create(*)", "*.getProperty(*)", "*.setProperty(*,*)", "*.print(*)", "*.println(*)", "*.append(*)", "*.charAt(*)", "*.indexOf(*)", "*.contains(*)", "*.startsWith(*)", "*.endsWith(*)", "*.equals(*)", "*.equal(*)", "*.compareTo(*)", "*.compare(*,*)", "java.lang.Math.*", "org.slf4j.Logger.*", "*.singleton(*)", "*.singletonList(*)", "*.Set.of", "*.ImmutableList.of", "*.ImmutableMultiset.of", "*.ImmutableSortedMultiset.of", "*.ImmutableSortedSet.of", "*.Arrays.asList"});
    @NotNull
    private final Option isDoNotShowIfMethodNameContainsParameterName = new Option("java.method.name.contains.parameter.name", "Do not show if method name contains parameter name", true);
    @NotNull
    private final Option isShowForParamsWithSameType = new Option("java.multiple.params.same.type", "Show for non-literals in case of multiple params with the same type", false);
    @NotNull
    private final Option isDoNotShowForBuilderLikeMethods = new Option("java.build.like.method", "Do not show for builder-like methods", true);
    @NotNull
    private final Option ignoreOneCharOneDigitHints = new Option("java.simple.sequentially.numbered", "Do not show for methods with same-named numbered parameters", true);
    public static final Companion Companion = new Companion(null);

    @Nullable
    public HintInfo.MethodInfo getHintInfo(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCallExpression) {
            PsiElement resolvedElement;
            PsiElement psiElement;
            PsiMethod psiMethod = CompletionMemory.getChosenMethod((PsiCall)element);
            if (psiMethod != null) {
                psiElement = (PsiElement)psiMethod;
            } else {
                JavaResolveResult javaResolveResult = ((PsiCallExpression)element).resolveMethodGenerics();
                Intrinsics.checkExpressionValueIsNotNull((Object)javaResolveResult, (String)"element.resolveMethodGenerics ()");
                psiElement = resolvedElement = javaResolveResult.getElement();
            }
            if (resolvedElement instanceof PsiMethod) {
                return this.getMethodInfo((PsiMethod)resolvedElement);
            }
        }
        return null;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (element instanceof PsiCallExpression) {
            return CollectionsKt.toList((Iterable)JavaInlayHintsProvider.INSTANCE.hints((PsiCallExpression)element));
        }
        return CollectionsKt.emptyList();
    }

    public boolean canShowHintsWhenDisabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final HintInfo.MethodInfo getMethodInfo(@NotNull PsiMethod method) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        PsiClass containingClass;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = containingClass = psiClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass2, (String)"containingClass");
        String fullMethodName = StringUtil.getQualifiedName((String)psiClass2.getQualifiedName(), (String)method.getName());
        PsiParameterList psiParameterList = method.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterArray, (String)"method.parameterList.parameters");
        Object[] objectArray = $receiver$iv = (Object[])psiParameterArray;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (void item$iv$iv : $receiver$iv$iv) {
            void it;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            String string = v4.getName();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            collection.add(string2);
        }
        List paramNames = (List)destination$iv$iv;
        String string = fullMethodName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fullMethodName");
        return new HintInfo.MethodInfo(string, paramNames);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return this.defaultBlackList;
    }

    @NotNull
    public final Option isDoNotShowIfMethodNameContainsParameterName() {
        return this.isDoNotShowIfMethodNameContainsParameterName;
    }

    @NotNull
    public final Option isShowForParamsWithSameType() {
        return this.isShowForParamsWithSameType;
    }

    @NotNull
    public final Option isDoNotShowForBuilderLikeMethods() {
        return this.isDoNotShowForBuilderLikeMethods;
    }

    @NotNull
    public final Option getIgnoreOneCharOneDigitHints() {
        return this.ignoreOneCharOneDigitHints;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        return CollectionsKt.listOf((Object[])new Option[]{this.isDoNotShowIfMethodNameContainsParameterName, this.isShowForParamsWithSameType, this.isDoNotShowForBuilderLikeMethods, this.ignoreOneCharOneDigitHints});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider$Companion;", "", "()V", "getInstance", "Lcom/intellij/codeInsight/hints/JavaInlayParameterHintsProvider;", "intellij.java.impl"})
    public static final class Companion {
        @NotNull
        public final JavaInlayParameterHintsProvider getInstance() {
            Object object = InlayParameterHintsExtension.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.hints.JavaInlayParameterHintsProvider");
            }
            return (JavaInlayParameterHintsProvider)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

