/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.AddNullableNotNullAnnotationFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AnnotateIntentionAction
extends BaseIntentionAction
implements LowPriorityAction {
    private static final AnnotationProvider[] PROVIDERS = new AnnotationProvider[]{new DeprecationAnnotationProvider(), new NullableAnnotationProvider(), new NotNullAnnotationProvider()};
    private AnnotationProvider myAnnotationProvider;
    private boolean mySingleMode;

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static StreamEx<AnnotationProvider> availableAnnotations(PsiModifierListOwner owner, Project project) {
        return (StreamEx)((StreamEx)StreamEx.of((Object[])PROVIDERS).filter(p -> p.isAvailable(owner))).filter(p -> !AnnotateIntentionAction.alreadyAnnotated(owner, p, project));
    }

    public boolean selectSingle(Editor editor, PsiFile file, String annotationShortName) {
        if (this.mySingleMode) {
            throw new IllegalStateException();
        }
        this.mySingleMode = true;
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        if (owner == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        Optional provider = (Optional)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, file.getProject()).filter(p -> StringUtil.getShortName((String)p.getName(file.getProject())).equals(annotationShortName))).collect(MoreCollectors.onlyOne());
        this.myAnnotationProvider = provider.orElse(null);
        return provider.isPresent();
    }

    private static boolean alreadyAnnotated(PsiModifierListOwner owner, AnnotationProvider p, Project project) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])((String[])ArrayUtil.prepend((Object)p.getName(owner.getProject()), (Object[])p.getAnnotationsToRemove(project))));
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner owner;
        if (project == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(1);
        }
        if ((owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset())) == null || owner.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        if (this.mySingleMode) {
            return this.myAnnotationProvider != null && AnnotateIntentionAction.availableAnnotations(owner, project).has((Object)this.myAnnotationProvider);
        }
        List annotations2 = (List)((StreamEx)AnnotateIntentionAction.availableAnnotations(owner, project).limit(2L)).collect(Collectors.toList());
        if (annotations2.isEmpty()) {
            return false;
        }
        if (annotations2.size() == 1) {
            this.myAnnotationProvider = (AnnotationProvider)annotations2.get(0);
            this.setText(AddAnnotationPsiFix.calcText(owner, this.myAnnotationProvider.getName(project)));
        } else {
            this.myAnnotationProvider = null;
            this.setText(AddAnnotationPsiFix.calcText(owner, null));
        }
        return true;
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AnnotateIntentionAction.$$$reportNull$$$0(2);
        }
        final PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file, editor.getCaretModel().getOffset());
        assert (owner != null);
        if (this.myAnnotationProvider != null) {
            if (AnnotateIntentionAction.alreadyAnnotated(owner, this.myAnnotationProvider, project)) {
                return;
            }
            AddAnnotationFix fix = new AddAnnotationFix(this.myAnnotationProvider.getName(project), owner, this.myAnnotationProvider.getAnnotationsToRemove(project));
            fix.invoke(project, editor, file);
        } else {
            List annotations2 = (List)AnnotateIntentionAction.availableAnnotations(owner, project).collect(Collectors.toList());
            if (annotations2.isEmpty()) {
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AnnotationProvider>(CodeInsightBundle.message((String)"annotate.intention.chooser.title", (Object[])new Object[0]), annotations2){

                public PopupStep onChosen(AnnotationProvider selectedValue, boolean finalChoice) {
                    AddAnnotationFix fix = new AddAnnotationFix(selectedValue.getName(project), owner, selectedValue.getAnnotationsToRemove(project));
                    fix.invoke(project, editor, file);
                    return PopupStep.FINAL_CHOICE;
                }

                @NotNull
                public String getTextFor(AnnotationProvider value2) {
                    String string = value2.getName(project);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$1", "getTextFor"));
                }
            }).showInBestPositionFor(editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NotNullAnnotationProvider
    implements AnnotationProvider {
        NotNullAnnotationProvider() {
        }

        @Override
        @NotNull
        public String getName(Project project) {
            String string = NullableNotNullManager.getInstance((Project)project).getDefaultNotNull();
            if (string == null) {
                NotNullAnnotationProvider.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isAvailable(PsiModifierListOwner owner) {
            return AddNullableNotNullAnnotationFix.canAnnotate(owner);
        }

        @Override
        @NotNull
        public String[] getAnnotationsToRemove(Project project) {
            String[] stringArray = NullableNotNullManager.getInstance((Project)project).getNullables().toArray(ArrayUtil.EMPTY_STRING_ARRAY);
            if (stringArray == null) {
                NotNullAnnotationProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$NotNullAnnotationProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationsToRemove";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class NullableAnnotationProvider
    implements AnnotationProvider {
        NullableAnnotationProvider() {
        }

        @Override
        @NotNull
        public String getName(Project project) {
            String string = NullableNotNullManager.getInstance((Project)project).getDefaultNullable();
            if (string == null) {
                NullableAnnotationProvider.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isAvailable(PsiModifierListOwner owner) {
            return AddNullableNotNullAnnotationFix.canAnnotate(owner);
        }

        @Override
        @NotNull
        public String[] getAnnotationsToRemove(Project project) {
            String[] stringArray = NullableNotNullManager.getInstance((Project)project).getNotNulls().toArray(ArrayUtil.EMPTY_STRING_ARRAY);
            if (stringArray == null) {
                NullableAnnotationProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$NullableAnnotationProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationsToRemove";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class DeprecationAnnotationProvider
    implements AnnotationProvider {
        DeprecationAnnotationProvider() {
        }

        @Override
        @NotNull
        public String getName(Project project) {
            if ("java.lang.Deprecated" == null) {
                DeprecationAnnotationProvider.$$$reportNull$$$0(0);
            }
            return "java.lang.Deprecated";
        }

        @Override
        public boolean isAvailable(PsiModifierListOwner owner) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$DeprecationAnnotationProvider", "getName"));
        }
    }

    static interface AnnotationProvider {
        @NotNull
        public String getName(Project var1);

        public boolean isAvailable(PsiModifierListOwner var1);

        @NotNull
        default public String[] getAnnotationsToRemove(Project project) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                AnnotationProvider.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AnnotateIntentionAction$AnnotationProvider", "getAnnotationsToRemove"));
        }
    }
}

