/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    private ColorUtil() {
    }

    public static String generatePreviewHtml(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        return "<tr><td valign='top' class='section'><p>Preview:</td><td><p>" + String.format("<div style=\"padding: 1px; width: 52px; height: 32px; background-color: #555555;\"><div style=\"width: 50px; height: 30px; background-color: #%s;\">&nbsp;</div></div>", com.intellij.ui.ColorUtil.toHex((Color)color)) + "</td>";
    }

    public static void appendColorPreview(PsiVariable variable, StringBuilder buffer) {
        PsiType type2;
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (type2 = initializer.getType()) != null && "java.awt.Color".equals(type2.getCanonicalText())) {
            Color c;
            PsiField psiField;
            PsiClass psiClass;
            PsiElement psiElement;
            PsiReference reference;
            if (initializer instanceof PsiNewExpression) {
                PsiExpressionList argumentList = ((PsiNewExpression)initializer).getArgumentList();
                if (argumentList != null) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    int[] values = ArrayUtil.newIntArray((int)expressions2.length);
                    float[] values2 = new float[expressions2.length];
                    int i = 0;
                    int j = 0;
                    PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)initializer.getProject()).getConstantEvaluationHelper();
                    for (PsiExpression each : expressions2) {
                        Object o = helper.computeConstantExpression((PsiElement)each);
                        if (o instanceof Integer) {
                            values[i] = (Integer)o;
                            values[i] = values[i] > 255 && expressions2.length > 1 ? 255 : (values[i] < 0 ? 0 : values[i]);
                            ++i;
                            continue;
                        }
                        if (!(o instanceof Float)) continue;
                        values2[j] = ((Float)o).floatValue();
                        values2[j] = values2[j] > 1.0f ? 1.0f : (values2[j] < 0.0f ? 0.0f : values2[j]);
                        ++j;
                    }
                    Color c2 = null;
                    if (i == expressions2.length) {
                        switch (values.length) {
                            case 1: {
                                c2 = new Color(values[0]);
                                break;
                            }
                            case 3: {
                                c2 = new Color(values[0], values[1], values[2]);
                                break;
                            }
                            case 4: {
                                c2 = new Color(values[0], values[1], values[2], values[3]);
                                break;
                            }
                        }
                    } else if (j == expressions2.length) {
                        switch (values2.length) {
                            case 3: {
                                c2 = new Color(values2[0], values2[1], values2[2]);
                                break;
                            }
                            case 4: {
                                c2 = new Color(values2[0], values2[1], values2[2], values2[3]);
                                break;
                            }
                        }
                    }
                    if (c2 != null) {
                        buffer.append(ColorUtil.generatePreviewHtml(c2));
                    }
                }
            } else if (initializer instanceof PsiReferenceExpression && (reference = initializer.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiField && (psiClass = (psiField = (PsiField)psiElement).getContainingClass()) != null && "java.awt.Color".equals(psiClass.getQualifiedName()) && (c = (Color)ReflectionUtil.getStaticFieldValue(Color.class, Color.class, (String)psiField.getName())) != null) {
                buffer.append(ColorUtil.generatePreviewHtml(c));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/javadoc/ColorUtil", "generatePreviewHtml"));
    }
}

