/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates.editable;

import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface JavaPostfixTemplateExpressionCondition
extends Condition<PsiExpression> {
    public String getId();

    public String getPresentableName();

    public boolean equals(Object var1);

    public int hashCode();

    public static class JavaPostfixTemplateArrayExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "array";

        public boolean value(PsiExpression element) {
            return JavaPostfixTemplatesUtils.isArray(element.getType());
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return ID;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNotPrimitiveTypeExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "notPrimitive";

        public boolean value(PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNotPrimitiveTypeExpression(element);
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return "not primitive type";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNumberExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "number";

        public boolean value(PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNumber(element.getType());
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return ID;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateBooleanExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "boolean";

        public boolean value(PsiExpression element) {
            return JavaPostfixTemplatesUtils.isBoolean(element.getType());
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return ID;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateNonVoidExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "non void";

        public boolean value(PsiExpression element) {
            return JavaPostfixTemplatesUtils.isNonVoid(element.getType());
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return ID;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateVoidExpressionCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "void";

        public boolean value(PsiExpression element) {
            PsiType type2 = element.getType();
            return type2 != null && PsiType.VOID.equals((Object)type2);
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return ID;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class JavaPostfixTemplateExpressionFqnCondition
    implements JavaPostfixTemplateExpressionCondition {
        public static final String ID = "fqn";
        private final String myFqn;

        public JavaPostfixTemplateExpressionFqnCondition(@NotNull String fqn) {
            if (fqn == null) {
                JavaPostfixTemplateExpressionFqnCondition.$$$reportNull$$$0(0);
            }
            this.myFqn = fqn;
        }

        public String getFqn() {
            return this.myFqn;
        }

        public boolean value(PsiExpression element) {
            PsiType type2 = element.getType();
            return type2 != null && InheritanceUtil.isInheritor((PsiType)type2, (String)this.myFqn);
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getPresentableName() {
            return this.myFqn;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaPostfixTemplateExpressionFqnCondition condition2 = (JavaPostfixTemplateExpressionFqnCondition)o;
            return Objects.equals(this.myFqn, condition2.myFqn);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.myFqn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ID, "com/intellij/codeInsight/template/postfix/templates/editable/JavaPostfixTemplateExpressionCondition$JavaPostfixTemplateExpressionFqnCondition", "<init>"));
        }
    }
}

