/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSuppressionUtil {
    private static final String GENERATED_ANNOTATION_NAME = "javax.annotation.Generated";
    public static final String SUPPRESS_INSPECTIONS_ANNOTATION_NAME = "java.lang.SuppressWarnings";

    public static boolean alreadyHas14Suppressions(@NotNull PsiJavaDocumentedElement commentOwner) {
        PsiDocComment docComment;
        if (commentOwner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(0);
        }
        return (docComment = commentOwner.getDocComment()) != null && docComment.findTagByName("noinspection") != null;
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(PsiElement element) {
        Object val;
        PsiElement psiElement;
        if (element instanceof PsiLiteralExpression) {
            Object value2 = ((PsiLiteralExpression)element).getValue();
            if (value2 instanceof String) {
                return (String)value2;
            }
        } else if (element instanceof PsiReferenceExpression && (psiElement = ((PsiReferenceExpression)element).resolve()) instanceof PsiVariableEx && (val = ((PsiVariableEx)psiElement).computeConstantValue((Set<PsiVariable>)new THashSet())) instanceof String) {
            return (String)val;
        }
        return null;
    }

    @NotNull
    public static Collection<String> getInspectionIdsSuppressedInAnnotation(@Nullable PsiModifierList modifierList) {
        if (modifierList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiElement parent = modifierList.getParent();
        if (!(parent instanceof PsiModifierListOwner)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)parent;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME});
        if (annotation == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)annotation, () -> CachedValueProvider.Result.create(JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(annotation), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (collection == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(PsiAnnotation annotation) {
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiAnnotationMemberValue attributeValue = attributes[0].getValue();
        ArrayList<String> result = new ArrayList<String>();
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue annotationMemberValue : initializers = ((PsiArrayInitializerMemberValue)attributeValue).getInitializers()) {
                String id = JavaSuppressionUtil.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)annotationMemberValue);
                if (id == null) continue;
                result.add(id);
            }
        } else {
            String id = JavaSuppressionUtil.getInspectionIdSuppressedInAnnotationAttribute((PsiElement)attributeValue);
            if (id != null) {
                result.add(id);
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static PsiElement getElementMemberSuppressedIn(@NotNull PsiJavaDocumentedElement owner, @NotNull String inspectionToolID) {
        PsiPackage aPackage;
        PsiDirectory directory;
        PsiElement element;
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(7);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(8);
        }
        if ((element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(owner, inspectionToolID)) != null) {
            return element;
        }
        if (owner instanceof PsiModifierListOwner && (element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)owner, inspectionToolID)) != null) {
            return element;
        }
        PsiJavaDocumentedElement container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiJavaDocumentedElement.class);
        while (container != null) {
            element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(container, inspectionToolID);
            if (element != null) {
                return element;
            }
            if (container instanceof PsiModifierListOwner && (element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)container, inspectionToolID)) != null) {
                return element;
            }
            container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class);
        }
        PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)owner, PsiJavaFile.class);
        if (file != null && (directory = file.getContainingDirectory()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, (String[])new String[]{GENERATED_ANNOTATION_NAME});
        }
        return null;
    }

    static PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, @NotNull String inspectionToolID) {
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(10);
        }
        PsiModifierList modifierList = owner.getModifierList();
        Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
        for (String ids : suppressedIds) {
            if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)inspectionToolID)) continue;
            return modifierList != null ? AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME}) : null;
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{GENERATED_ANNOTATION_NAME});
    }

    static PsiElement getDocCommentToolSuppressedIn(@NotNull PsiJavaDocumentedElement owner, @NotNull String inspectionToolID) {
        PsiDocTag inspectionTag;
        PsiElement el;
        PsiDocComment docComment;
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(11);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(12);
        }
        if ((docComment = owner.getDocComment()) == null && owner.getParent() instanceof PsiDeclarationStatement && (el = PsiTreeUtil.skipWhitespacesBackward((PsiElement)owner.getParent())) instanceof PsiDocComment) {
            docComment = (PsiDocComment)el;
        }
        if (docComment != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            PsiElement[] dataElements;
            for (PsiElement dataElement : dataElements = inspectionTag.getDataElements()) {
                String valueText = dataElement.getText();
                if (!SuppressionUtil.isInspectionToolIdMentioned((String)valueText, (String)inspectionToolID)) continue;
                return docComment;
            }
        }
        return null;
    }

    public static Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(13);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)owner)) {
            return Collections.emptyList();
        }
        PsiModifierList modifierList = owner.getModifierList();
        return JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
    }

    public static String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        PsiDocTag inspectionTag;
        PsiDocComment docComment;
        String text2;
        Matcher matcher;
        if (element == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text2 = element.getText())).matches()) {
            return matcher.group(1).trim();
        }
        if (element instanceof PsiJavaDocumentedElement && (docComment = ((PsiJavaDocumentedElement)element).getDocComment()) != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            String valueText = "";
            for (PsiElement dataElement : inspectionTag.getDataElements()) {
                valueText = valueText + dataElement.getText();
            }
            return valueText;
        }
        if (element instanceof PsiModifierListOwner) {
            Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierListOwner)element);
            return suppressedIds.isEmpty() ? null : StringUtil.join(suppressedIds, (String)",");
        }
        return null;
    }

    static PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(15);
        }
        if (toolId == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(16);
        }
        if (place instanceof PsiFile) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement element;
            PsiElement element2;
            PsiJavaDocumentedElement container;
            PsiVariable local;
            PsiElement annotation;
            PsiElement statement;
            if (place == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(22);
            }
            if (toolId == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(23);
            }
            if ((statement = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)place, (String)toolId, PsiStatement.class)) != null) {
                return statement;
            }
            PsiElement up = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiVariable.class, PsiJavaDocumentedElement.class});
            if (up instanceof PsiModifierListOwner && ((PsiModifierListOwner)up).getModifierList() == null) {
                up = PsiTreeUtil.getParentOfType((PsiElement)up, (Class[])new Class[]{PsiVariable.class, PsiJavaDocumentedElement.class});
            }
            if (up instanceof PsiVariable && (annotation = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)(local = (PsiVariable)up), toolId)) != null) {
                return annotation;
            }
            PsiJavaDocumentedElement psiJavaDocumentedElement = container = up == null || up instanceof PsiJavaDocumentedElement ? (PsiJavaDocumentedElement)up : (PsiJavaDocumentedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)up, (Class[])new Class[]{PsiJavaDocumentedElement.class});
            while (container instanceof PsiTypeParameter) {
                container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class);
            }
            if (container != null && (element2 = JavaSuppressionUtil.getElementMemberSuppressedIn(container, toolId)) != null) {
                return element2;
            }
            PsiJavaDocumentedElement classContainer = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class, (boolean)true);
            if (classContainer != null && (element = JavaSuppressionUtil.getElementMemberSuppressedIn(classContainer, toolId)) != null) {
                return element;
            }
            return null;
        });
    }

    public static void addSuppressAnnotation(@NotNull Project project, PsiElement container, PsiModifierListOwner modifierOwner, @NotNull String id) throws IncorrectOperationException {
        PsiAnnotation annotation;
        PsiAnnotation newAnnotation;
        if (project == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(17);
        }
        if (id == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(18);
        }
        if ((newAnnotation = JavaSuppressionUtil.createNewAnnotation(project, container, annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME}), id)) != null) {
            if (annotation != null && annotation.isPhysical()) {
                WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> annotation.replace((PsiElement)newAnnotation), (PsiFile[])new PsiFile[]{annotation.getContainingFile()});
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                new AddAnnotationPsiFix(SUPPRESS_INSPECTIONS_ANNOTATION_NAME, modifierOwner, attributes, new String[0]).applyFix();
            }
        }
    }

    private static PsiAnnotation createNewAnnotation(@NotNull Project project, PsiElement container, PsiAnnotation annotation, @NotNull String id) throws IncorrectOperationException {
        if (project == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(19);
        }
        if (id == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(20);
        }
        if (annotation == null) {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings(\"" + id + "\")", container);
        }
        String currentSuppressedId = "\"" + id + "\"";
        if (!annotation.getText().contains("{")) {
            PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
            if (attributes.length == 1) {
                String suppressedWarnings = attributes[0].getText();
                if (suppressedWarnings.contains(currentSuppressedId)) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText("@java.lang.SuppressWarnings({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
            }
        } else {
            int curlyBraceIndex = annotation.getText().lastIndexOf("}");
            if (curlyBraceIndex > 0) {
                String oldSuppressWarning = annotation.getText().substring(0, curlyBraceIndex);
                if (oldSuppressWarning.contains(currentSuppressedId)) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
            }
            throw new IncorrectOperationException(annotation.getText());
        }
        return null;
    }

    public static boolean canHave15Suppressions(@NotNull PsiElement file) {
        Module module;
        if (file == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(21);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return false;
        }
        Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (jdk == null) {
            return false;
        }
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        if (version == null) {
            return false;
        }
        boolean is_1_5 = version.isAtLeast(JavaSdkVersion.JDK_1_5);
        return DaemonCodeAnalyzerSettings.getInstance().isSuppressWarnings() && is_1_5 && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Nullable
    public static PsiElement getElementToAnnotate(PsiElement element, PsiElement container) {
        block8: {
            PsiResourceList resourceList;
            block7: {
                PsiElement[] declaredElements;
                if (!(container instanceof PsiDeclarationStatement)) break block7;
                if (!JavaSuppressionUtil.canHave15Suppressions(element)) break block8;
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)container;
                for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                    PsiModifierList modifierList;
                    if (!(declaredElement instanceof PsiLocalVariable) || (modifierList = ((PsiLocalVariable)declaredElement).getModifierList()) == null) continue;
                    return declaredElement;
                }
                break block8;
            }
            if (container instanceof PsiForeachStatement) {
                if (JavaSuppressionUtil.canHave15Suppressions(element)) {
                    PsiModifierList modifierList;
                    PsiParameter parameter2 = ((PsiForeachStatement)container).getIterationParameter();
                    PsiModifierList psiModifierList = modifierList = element.getParent() == parameter2 ? parameter2.getModifierList() : null;
                    if (modifierList != null) {
                        return parameter2;
                    }
                }
            } else if (container instanceof PsiTryStatement && (resourceList = ((PsiTryStatement)container).getResourceList()) != null) {
                for (PsiResourceListElement listElement : resourceList) {
                    PsiModifierList modifierList;
                    if (!(listElement instanceof PsiResourceVariable) || listElement != element.getParent() || (modifierList = ((PsiResourceVariable)listElement).getModifierList()) == null) continue;
                    return listElement;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/JavaSuppressionUtil";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolID";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/JavaSuppressionUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionIdsSuppressedInAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "alreadyHas14Suppressions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementMemberSuppressedIn";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMemberSuppressedIn";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentToolSuppressedIn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionIdsSuppressedInAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInspectionIdsIn";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementToolSuppressedIn";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressAnnotation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createNewAnnotation";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "canHave15Suppressions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementToolSuppressedIn$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

