/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteSideEffectsAwareFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.AddAssertStatementFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.RemoveAssignmentFix;
import com.intellij.codeInspection.ReplaceWithTernaryOperatorFix;
import com.intellij.codeInspection.ReplaceWithTrivialLambdaFix;
import com.intellij.codeInspection.StreamFilterNotNullFix;
import com.intellij.codeInspection.SurroundWithIfFix;
import com.intellij.codeInspection.dataFlow.DataFlowInspectionBase;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.fix.SurroundWithRequireNonNullFix;
import com.intellij.codeInspection.nullable.NullableStuffInspection;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataFlowInspection
extends DataFlowInspectionBase {
    @Override
    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression assignment, boolean onTheFly) {
        boolean toRemove2;
        IElementType op = assignment.getOperationTokenType();
        boolean bl = toRemove2 = op == JavaTokenType.ANDEQ && !evaluatesToTrue || op == JavaTokenType.OREQ && evaluatesToTrue;
        if (toRemove2 && !onTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{toRemove2 ? new RemoveAssignmentFix() : DataFlowInspection.createSimplifyToAssignmentFix()};
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value2) {
        return new ReplaceWithTrivialLambdaFix(value2);
    }

    @Override
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression2) {
        return new IntroduceVariableFix(true);
    }

    @Override
    protected LocalQuickFixOnPsiElement createSimplifyBooleanFix(PsiElement element, boolean value2) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType((PsiElement)element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression2, value2);
        if (!fix.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix;
    }

    private static boolean isVolatileFieldReference(PsiExpression qualifier) {
        PsiElement target = qualifier instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifier).resolve() : null;
        return target instanceof PsiField && ((PsiField)target).hasModifierProperty("volatile");
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        ContainerUtil.addIfNotNull(fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)methodRef));
        fixes.add(new ReplaceWithTernaryOperatorFix.ReplaceMethodRefWithTernaryOperatorFix());
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            DataFlowInspection.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        if (assignment == null || assignment.getRExpression() == null || !(assignment.getParent() instanceof PsiExpressionStatement)) {
            return null;
        }
        return new DeleteSideEffectsAwareFix((PsiStatement)assignment.getParent(), assignment.getRExpression());
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression2, boolean onTheFly) {
        qualifier = PsiUtil.deparenthesizeExpression((PsiExpression)qualifier);
        SmartList fixes = new SmartList();
        if (qualifier == null || expression2 == null) {
            SmartList smartList = fixes;
            if (smartList == null) {
                DataFlowInspection.$$$reportNull$$$0(1);
            }
            return smartList;
        }
        try {
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)StreamFilterNotNullFix.makeFix((PsiElement)qualifier));
            if (DataFlowInspection.isVolatileFieldReference(qualifier)) {
                ContainerUtil.addIfNotNull((Collection)fixes, (Object)this.createIntroduceVariableFix(qualifier));
            } else if (!ExpressionUtils.isNullLiteral(qualifier) && !SideEffectChecker.mayHaveSideEffects(qualifier)) {
                if (PsiUtil.getLanguageLevel((PsiElement)qualifier).isAtLeast(LanguageLevel.JDK_1_4)) {
                    Project project = qualifier.getProject();
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiBinaryExpression binary = (PsiBinaryExpression)elementFactory.createExpressionFromText("a != null", null);
                    binary.getLOperand().replace((PsiElement)qualifier);
                    if (RefactoringUtil.getParentStatement((PsiElement)expression2, false) != null) {
                        fixes.add(new AddAssertStatementFix((PsiExpression)binary));
                    }
                }
                if (onTheFly && SurroundWithIfFix.isAvailable(qualifier)) {
                    fixes.add(new SurroundWithIfFix(qualifier));
                }
                if (ReplaceWithTernaryOperatorFix.isAvailable(qualifier, expression2)) {
                    fixes.add(new ReplaceWithTernaryOperatorFix(qualifier));
                }
            }
            if (!ExpressionUtils.isNullLiteral(qualifier) && PsiUtil.isLanguageLevel7OrHigher((PsiElement)qualifier)) {
                fixes.add(new SurroundWithRequireNonNullFix(qualifier));
            }
            ContainerUtil.addIfNotNull((Collection)fixes, (Object)DfaOptionalSupport.registerReplaceOptionalOfWithOfNullableFix(qualifier));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            DataFlowInspection.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return new NullableStuffInspection.NavigateToNullLiteralArguments(parameter2);
    }

    private static JCheckBox createCheckBoxWithHTML(String text2, boolean selected, Consumer<JCheckBox> consumer) {
        JCheckBox box = new JCheckBox(XmlStringUtil.wrapInHtml((CharSequence)text2));
        box.setVerticalTextPosition(1);
        box.setSelected(selected);
        box.getModel().addItemListener(event -> consumer.accept(box));
        return box;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodReferenceNPEFixes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OptionsPanel
    extends JPanel {
        private static final int BUTTON_OFFSET = 20;
        private final JButton myConfigureAnnotations;
        private final JCheckBox myIgnoreAssertions;
        private final JCheckBox myReportConstantReferences;
        private final JCheckBox mySuggestNullables;
        private final JCheckBox myDontReportTrueAsserts;
        private final JCheckBox myTreatUnknownMembersAsNullable;
        private final JCheckBox myReportNullArguments;
        private final JCheckBox myReportNullableMethodsReturningNotNull;
        private final JCheckBox myReportUncheckedOptionals;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.mySuggestNullables = DataFlowInspection.createCheckBoxWithHTML(InspectionsBundle.message((String)"inspection.data.flow.nullable.quickfix.option", (Object[])new Object[0]), DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS, box -> {
                DataFlowInspection.this.SUGGEST_NULLABLE_ANNOTATIONS = box.isSelected();
            });
            this.myDontReportTrueAsserts = DataFlowInspection.createCheckBoxWithHTML(InspectionsBundle.message((String)"inspection.data.flow.true.asserts.option", (Object[])new Object[0]), DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS, box -> {
                DataFlowInspection.this.DONT_REPORT_TRUE_ASSERT_STATEMENTS = box.isSelected();
            });
            this.myIgnoreAssertions = DataFlowInspection.createCheckBoxWithHTML("Ignore assert statements", DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS, box -> {
                DataFlowInspection.this.IGNORE_ASSERT_STATEMENTS = box.isSelected();
            });
            this.myReportConstantReferences = DataFlowInspection.createCheckBoxWithHTML("Warn when reading a value guaranteed to be constant", DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES, box -> {
                DataFlowInspection.this.REPORT_CONSTANT_REFERENCE_VALUES = box.isSelected();
            });
            this.myTreatUnknownMembersAsNullable = DataFlowInspection.createCheckBoxWithHTML("Treat non-annotated members and parameters as @Nullable", DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, box -> {
                DataFlowInspection.this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE = box.isSelected();
            });
            this.myReportNullArguments = DataFlowInspection.createCheckBoxWithHTML("Report not-null required parameter with null-literal argument usages", DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER, box -> {
                DataFlowInspection.this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = box.isSelected();
            });
            this.myReportNullableMethodsReturningNotNull = DataFlowInspection.createCheckBoxWithHTML("Report nullable methods that always return a non-null value", DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL, box -> {
                DataFlowInspection.this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = box.isSelected();
            });
            this.myReportUncheckedOptionals = DataFlowInspection.createCheckBoxWithHTML("Report Optional.get() calls without previous isPresent check", DataFlowInspection.this.REPORT_UNCHECKED_OPTIONALS, box -> {
                DataFlowInspection.this.REPORT_UNCHECKED_OPTIONALS = box.isSelected();
            });
            gc.insets = JBUI.emptyInsets();
            gc.gridy = 0;
            this.add((Component)this.mySuggestNullables, gc);
            this.myConfigureAnnotations = NullableNotNullDialog.createConfigureAnnotationsButton((Component)this);
            ++gc.gridy;
            gc.fill = 0;
            gc.insets.left = 20;
            gc.insets.bottom = 15;
            this.add((Component)this.myConfigureAnnotations, gc);
            gc.fill = 2;
            gc.weighty = 1.0;
            gc.insets.left = 0;
            ++gc.gridy;
            this.add((Component)this.myDontReportTrueAsserts, gc);
            ++gc.gridy;
            this.add((Component)this.myIgnoreAssertions, gc);
            ++gc.gridy;
            this.add((Component)this.myReportConstantReferences, gc);
            ++gc.gridy;
            this.add((Component)this.myTreatUnknownMembersAsNullable, gc);
            ++gc.gridy;
            this.add((Component)this.myReportNullArguments, gc);
            ++gc.gridy;
            this.add((Component)this.myReportNullableMethodsReturningNotNull, gc);
            ++gc.gridy;
            this.add((Component)this.myReportUncheckedOptionals, gc);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferred = super.getPreferredSize();
            if (!this.isPreferredSizeSet()) {
                Dimension size = this.myConfigureAnnotations.getPreferredSize();
                preferred.width = size.width + 20;
            }
            return preferred;
        }
    }
}

