/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PurityInference {
    public static boolean inferPurity(@NotNull PsiMethodImpl method) {
        if (method == null) {
            PurityInference.$$$reportNull$$$0(0);
        }
        if (!InferenceFromSourceUtil.shouldInferFromSource(method) || PsiType.VOID.equals((Object)method.getReturnType()) || method.isConstructor()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodData data;
            if (method == null) {
                PurityInference.$$$reportNull$$$0(1);
            }
            PurityInferenceResult result = (data = ContractInferenceIndexKt.getIndexedData(method)) == null ? null : data.getPurity();
            Boolean pure = (Boolean)RecursionManager.doPreventingRecursion((Object)((Object)method), (boolean)true, () -> {
                if (method == null) {
                    PurityInference.$$$reportNull$$$0(2);
                }
                return result != null && result.isPure(method, data.methodBody(method));
            });
            return CachedValueProvider.Result.create((Object)(pure == Boolean.TRUE ? 1 : 0), (Object[])new Object[]{method});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/PurityInference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "inferPurity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$inferPurity$1";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PurityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private final List<LighterASTNode> mutatedRefs = new ArrayList<LighterASTNode>();
        private boolean hasReturns;
        private boolean hasVolatileReads;
        private final List<LighterASTNode> calls = new ArrayList<LighterASTNode>();

        PurityInferenceVisitor(LighterAST tree, LighterASTNode body2) {
            this.tree = tree;
            this.body = body2;
        }

        void visitNode(LighterASTNode element) {
            LighterASTNode modifierList;
            LighterASTNode target;
            LighterASTNode qualifier;
            IElementType type2 = element.getTokenType();
            if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
                this.mutatedRefs.add((LighterASTNode)this.tree.getChildren(element).get(0));
            } else if (type2 == JavaElementType.RETURN_STATEMENT && JavaLightTreeUtil.findExpressionChild(this.tree, element) != null) {
                this.hasReturns = true;
            } else if ((type2 == JavaElementType.PREFIX_EXPRESSION || type2 == JavaElementType.POSTFIX_EXPRESSION) && this.isMutatingOperation(element)) {
                ContainerUtil.addIfNotNull(this.mutatedRefs, (Object)JavaLightTreeUtil.findExpressionChild(this.tree, element));
            } else if (this.isCall(element, type2)) {
                this.calls.add(element);
            } else if (type2 == JavaElementType.REFERENCE_EXPRESSION && ((qualifier = JavaLightTreeUtil.findExpressionChild(this.tree, element)) == null || qualifier.getTokenType() == JavaElementType.THIS_EXPRESSION) && (target = new FileLocalResolver(this.tree).resolveLocally(element).getTarget()) != null && target.getTokenType() == JavaElementType.FIELD && (modifierList = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)target, (IElementType)JavaElementType.MODIFIER_LIST)) != null) {
                for (LighterASTNode modifier : this.tree.getChildren(modifierList)) {
                    if (modifier.getTokenType() != JavaTokenType.VOLATILE_KEYWORD) continue;
                    this.hasVolatileReads = true;
                    break;
                }
            }
        }

        private boolean isCall(@NotNull LighterASTNode element, IElementType type2) {
            if (element == null) {
                PurityInferenceVisitor.$$$reportNull$$$0(0);
            }
            return type2 == JavaElementType.NEW_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaElementType.EXPRESSION_LIST) != null || type2 == JavaElementType.METHOD_CALL_EXPRESSION;
        }

        private boolean isMutatingOperation(@NotNull LighterASTNode element) {
            if (element == null) {
                PurityInferenceVisitor.$$$reportNull$$$0(1);
            }
            return LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.PLUSPLUS) != null || LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.MINUSMINUS) != null;
        }

        @Nullable
        PurityInferenceResult getResult() {
            if (this.calls.size() > 1 || !this.hasReturns || this.hasVolatileReads) {
                return null;
            }
            int bodyStart = this.body.getStartOffset();
            return new PurityInferenceResult(ContainerUtil.map(this.mutatedRefs, node -> ExpressionRange.create(node, bodyStart)), this.calls.isEmpty() ? null : ExpressionRange.create(this.calls.get(0), bodyStart));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/PurityInference$PurityInferenceVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCall";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMutatingOperation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

