/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.AddJavadocIntention;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocLocalInspection
extends JavaDocLocalInspectionBase {
    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Override
    protected LocalQuickFix createAddJavadocFix(@NotNull PsiElement nameIdentifier, boolean isOnTheFly) {
        if (nameIdentifier == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(0);
        }
        return isOnTheFly ? new AddJavadocFix(nameIdentifier) : null;
    }

    @Override
    protected LocalQuickFix createAddMissingTagFix(@NotNull String tag, @NotNull String value2, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(2);
        }
        return new AddMissingTagFix(tag, value2);
    }

    @Override
    protected LocalQuickFix createAddMissingParamTagFix(@NotNull String name, boolean isOnTheFly) {
        if (name == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(3);
        }
        return new AddMissingParamTagFix(name);
    }

    @Override
    protected LocalQuickFix createRegisterTagFix(@NotNull String tag, boolean isOnTheFly) {
        if (tag == null) {
            JavaDocLocalInspection.$$$reportNull$$$0(4);
        }
        return new AddUnknownTagToCustoms(this, tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAddJavadocFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAddMissingTagFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAddMissingParamTagFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRegisterTagFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddUnknownTagToCustoms
    implements LocalQuickFix {
        private final JavaDocLocalInspectionBase myInspection;
        private final String myTag;

        public AddUnknownTagToCustoms(@NotNull JavaDocLocalInspectionBase inspection, @NotNull String tag) {
            if (inspection == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(1);
            }
            this.myInspection = inspection;
            this.myTag = tag;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(3);
            }
            this.myInspection.registerAdditionalTag(this.myTag);
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("add.docTag.to.custom.tags", this.myTag);
            if (string == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.javadoc.family", new Object[0]);
            if (string == null) {
                AddUnknownTagToCustoms.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddUnknownTagToCustoms";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddMissingParamTagFix
    extends AddMissingTagFix {
        private final String myName;

        public AddMissingParamTagFix(String name) {
            super("param", name);
            this.myName = name;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag.family", (Object[])new Object[0]);
            if (string == null) {
                AddMissingParamTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element == null ? null : element.getParent();
            if (!(parent instanceof PsiDocComment)) {
                return null;
            }
            PsiDocComment docComment = (PsiDocComment)parent;
            PsiJavaDocumentedElement owner = docComment.getOwner();
            if (!(owner instanceof PsiMethod)) {
                return null;
            }
            Object[] parameters2 = ((PsiMethod)owner).getParameterList().getParameters();
            PsiParameter myParam = (PsiParameter)ContainerUtil.find((Object[])parameters2, psiParameter -> this.myName.equals(psiParameter.getName()));
            if (myParam == null) {
                return null;
            }
            PsiDocTag[] tags = docComment.findTagsByName("param");
            if (tags.length == 0) {
                tags = docComment.getTags();
                if (tags.length == 0) {
                    return null;
                }
                return tags[0];
            }
            PsiParameter nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (nextParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(nextParam, tag)) continue;
                    return tag;
                }
                nextParam = (PsiParameter)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextParam, PsiParameter.class);
            }
            PsiParameter prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)myParam, PsiParameter.class);
            while (prevParam != null) {
                for (PsiDocTag tag : tags) {
                    if (!AddMissingParamTagFix.matches(prevParam, tag)) continue;
                    return PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, PsiDocTag.class);
                }
                prevParam = (PsiParameter)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevParam, PsiParameter.class);
            }
            return null;
        }

        private static boolean matches(PsiParameter param, PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            String name = param.getName();
            return valueElement != null && name != null && valueElement.getText().trim().startsWith(name);
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.param.tag", (Object[])new Object[]{this.myName});
            if (string == null) {
                AddMissingParamTagFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingParamTagFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class AddMissingTagFix
    implements LocalQuickFix {
        private final String myTag;
        private final String myValue;

        public AddMissingTagFix(@NotNull String tag, @NotNull String value2) {
            if (tag == null) {
                AddMissingTagFix.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                AddMissingTagFix.$$$reportNull$$$0(1);
            }
            this.myTag = tag;
            this.myValue = value2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDocComment docComment;
            if (project == null) {
                AddMissingTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddMissingTagFix.$$$reportNull$$$0(3);
            }
            if ((docComment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiDocComment.class)) != null) {
                PsiDocTag tag = JavaPsiFacade.getInstance((Project)project).getElementFactory().createDocTagFromText("@" + this.myTag + " " + this.myValue);
                PsiElement anchor = this.getAnchor(descriptor);
                PsiElement addedTag = anchor != null ? docComment.addBefore((PsiElement)tag, anchor) : docComment.add((PsiElement)tag);
                AddMissingTagFix.moveCaretAfter(addedTag);
            }
        }

        @Nullable
        protected PsiElement getAnchor(ProblemDescriptor descriptor) {
            return null;
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling != null) {
                ((Navigatable)sibling).navigate(true);
            }
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag", (Object[])new Object[]{this.myTag, this.myValue});
            if (string == null) {
                AddMissingTagFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.javadoc.problem.add.tag.family", (Object[])new Object[0]);
            if (string == null) {
                AddMissingTagFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddMissingTagFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AddJavadocFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final AddJavadocIntention myIntention = new AddJavadocIntention();

        public AddJavadocFix(PsiElement nameIdentifier) {
            super(nameIdentifier);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddJavadocFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                AddJavadocFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AddJavadocFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                AddJavadocFix.$$$reportNull$$$0(3);
            }
            this.myIntention.invoke(project, editor, startElement);
        }

        @NotNull
        public String getText() {
            String string = this.myIntention.getText();
            if (string == null) {
                AddJavadocFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.myIntention.getFamilyName();
            if (string == null) {
                AddJavadocFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocLocalInspection$AddJavadocFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsPanel
    extends JPanel {
        public OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0);
            String title = InspectionsBundle.message((String)"inspection.javadoc.dialog.title", (Object[])new Object[0]);
            FieldPanel additionalTagsPanel = new FieldPanel(InspectionsBundle.message((String)"inspection.javadoc.label.text", (Object[])new Object[0]), title, null, null);
            additionalTagsPanel.setPreferredSize(new Dimension(150, additionalTagsPanel.getPreferredSize().height));
            additionalTagsPanel.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    Document document = e.getDocument();
                    try {
                        String text2 = document.getText(0, document.getLength());
                        if (text2 != null) {
                            JavaDocLocalInspection.this.myAdditionalJavadocTags = text2.trim();
                        }
                    }
                    catch (BadLocationException ex) {
                        Logger.getInstance(JavaDocLocalInspection.class).error((Throwable)ex);
                    }
                }
            });
            additionalTagsPanel.setText(JavaDocLocalInspection.this.myAdditionalJavadocTags);
            this.add((Component)additionalTagsPanel, gc);
            JBTabbedPane tabs = new JBTabbedPane(3);
            String[] tags = new String[]{"@author", "@version", "@since"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.package", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public"}, tags, JavaDocLocalInspection.this.PACKAGE_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.module", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public"}, tags, JavaDocLocalInspection.this.MODULE_OPTIONS));
            tags = new String[]{"@author", "@version", "@since", "@param"};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "package"}, tags, JavaDocLocalInspection.this.TOP_LEVEL_CLASS_OPTIONS));
            tags = new String[]{"@return", "@param", InspectionsBundle.message((String)"inspection.javadoc.throws.or.exception.option", (Object[])new Object[0])};
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.method", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, tags, JavaDocLocalInspection.this.METHOD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.field", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.FIELD_OPTIONS));
            tabs.add(InspectionsBundle.message((String)"inspection.javadoc.option.tab.title.inner.class", (Object[])new Object[0]), this.createOptionsPanel(new String[]{"none", "public", "protected", "package", "private"}, null, JavaDocLocalInspection.this.INNER_CLASS_OPTIONS));
            this.add((Component)tabs, gc);
            JCheckBox checkBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.deprecated", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_DEPRECATED);
            checkBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_DEPRECATED = checkBox.isSelected();
            });
            gc.gridwidth = 1;
            this.add((Component)checkBox, gc);
            JCheckBox periodCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.period", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD);
            periodCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_JAVADOC_PERIOD = periodCheckBox.isSelected();
            });
            this.add((Component)periodCheckBox, gc);
            JCheckBox ignoreDuplicateThrowsCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.throws", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreDuplicatedThrows());
            ignoreDuplicateThrowsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreDuplicatedThrows(ignoreDuplicateThrowsCheckBox.isSelected()));
            this.add((Component)ignoreDuplicateThrowsCheckBox, gc);
            JCheckBox ignorePointToItselfCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.self.ref", (Object[])new Object[0]), JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF);
            ignorePointToItselfCheckBox.addActionListener(e -> {
                JavaDocLocalInspection.this.IGNORE_POINT_TO_ITSELF = ignorePointToItselfCheckBox.isSelected();
            });
            this.add((Component)ignorePointToItselfCheckBox, gc);
            JCheckBox ignoreSimpleAccessorsCheckBox = new JCheckBox(InspectionsBundle.message((String)"inspection.javadoc.option.ignore.simple", (Object[])new Object[0]), JavaDocLocalInspection.this.isIgnoreSimpleAccessors());
            ignoreSimpleAccessorsCheckBox.addActionListener(e -> JavaDocLocalInspection.this.setIgnoreSimpleAccessors(ignoreSimpleAccessorsCheckBox.isSelected()));
            this.add((Component)ignoreSimpleAccessorsCheckBox, gc);
        }

        private JPanel createOptionsPanel(String[] modifiers, String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel pane = new JPanel(new GridLayout(1, tags == null ? 1 : 2));
            pane.add(this.createScopePanel(modifiers, options));
            if (tags != null) {
                pane.add(this.createTagsPanel(tags, options));
            }
            pane.validate();
            return pane;
        }

        private JPanel createScopePanel(String[] modifiers, JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.scope.for.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i = 0; i < modifiers.length; ++i) {
                sliderLabels.put(i + 1, new JLabel(modifiers[i]));
            }
            JSlider slider = new JSlider(1, 1, modifiers.length, 1);
            slider.setLabelTable(sliderLabels);
            slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
            slider.setPreferredSize((Dimension)JBUI.size((int)80, (int)50));
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value2 = slider.getValue();
                options.ACCESS_JAVADOC_REQUIRED_FOR = modifiers[value2 - 1];
                for (Integer key2 : sliderLabels.keySet()) {
                    ((JComponent)sliderLabels.get(key2)).setForeground((Color)(key2 <= value2 ? JBColor.BLACK : Gray._100));
                }
            });
            JBColor fore = JBColor.BLACK;
            for (int i = 0; i < modifiers.length; ++i) {
                ((JComponent)sliderLabels.get(i + 1)).setForeground((Color)fore);
                if (!modifiers[i].equals(options.ACCESS_JAVADOC_REQUIRED_FOR)) continue;
                slider.setValue(i + 1);
                fore = Gray._100;
            }
            panel.add((Component)slider, "West");
            return panel;
        }

        private JPanel createTagsPanel(String[] tags, JavaDocLocalInspectionBase.Options options) {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder((Border)IdeBorderFactory.createTitledBorder((String)InspectionsBundle.message((String)"inspection.javadoc.required.tags.option.title", (Object[])new Object[0]), (boolean)true), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            for (int i = 0; i < tags.length; ++i) {
                JCheckBox box = new JCheckBox(tags[i]);
                gc.gridy = i;
                if (i == tags.length - 1) {
                    gc.weighty = 1.0;
                }
                panel.add((Component)box, gc);
                box.setSelected(JavaDocLocalInspectionBase.isTagRequired(options, tags[i]));
                box.addChangeListener(new MyChangeListener(box, options, tags[i]));
            }
            return panel;
        }

        private class MyChangeListener
        implements ChangeListener {
            private final JCheckBox myCheckBox;
            private final JavaDocLocalInspectionBase.Options myOptions;
            private final String myTagName;

            public MyChangeListener(JCheckBox checkBox, JavaDocLocalInspectionBase.Options options, String tagName) {
                this.myCheckBox = checkBox;
                this.myOptions = options;
                this.myTagName = tagName;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.myCheckBox.isSelected()) {
                    if (!JavaDocLocalInspectionBase.isTagRequired(this.myOptions, this.myTagName)) {
                        this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS + this.myTagName;
                    }
                } else {
                    this.myOptions.REQUIRED_TAGS = this.myOptions.REQUIRED_TAGS.replaceAll(this.myTagName, "");
                }
            }
        }
    }
}

