/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiShortNamesCacheImpl
extends PsiShortNamesCache {
    private final PsiManagerEx myManager;

    public PsiShortNamesCacheImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(0);
        }
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.myManager.getProject(), (String)name, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
        if (psiFileArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        String[] stringArray = FilenameIndex.getAllFilenames((Project)this.myManager.getProject());
        if (stringArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2;
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(4);
        }
        if ((classes2 = JavaShortClassNameIndex.getInstance().get(name, this.myManager.getProject(), scope)).isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiShortNamesCacheImpl.$$$reportNull$$$0(5);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(classes2.size());
        THashMap uniqueQName2Classes = new THashMap(classes2.size());
        Set hiddenClassesToRemove = null;
        block0: for (PsiClass aClass : classes2) {
            VirtualFile vFile = aClass.getContainingFile().getVirtualFile();
            if (!scope.contains(vFile)) continue;
            String qName = aClass.getQualifiedName();
            if (qName != null) {
                List previousQNamedClasses = (List)uniqueQName2Classes.get(qName);
                SmartList qNamedClasses = new SmartList();
                if (previousQNamedClasses != null) {
                    for (PsiClass previousClass : previousQNamedClasses) {
                        VirtualFile previousClassVFile = previousClass.getContainingFile().getVirtualFile();
                        int res = scope.compare(previousClassVFile, vFile);
                        if (res > 0) continue block0;
                        if (res < 0) {
                            if (hiddenClassesToRemove == null) {
                                hiddenClassesToRemove = new THashSet();
                            }
                            hiddenClassesToRemove.add(previousClass);
                            qNamedClasses.add(aClass);
                            continue;
                        }
                        qNamedClasses.add(aClass);
                    }
                } else {
                    qNamedClasses.add(aClass);
                }
                uniqueQName2Classes.put(qName, qNamedClasses);
            }
            result.add(aClass);
        }
        if (hiddenClassesToRemove != null) {
            result.removeAll(hiddenClassesToRemove);
        }
        PsiClass[] psiClassArray = result.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaShortClassNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    public boolean processAllClassNames(Processor<String> processor) {
        return JavaShortClassNameIndex.getInstance().processAllKeys(this.myManager.getProject(), processor);
    }

    public boolean processAllClassNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.CLASS_SHORT_NAMES, processor, scope, filter);
    }

    public boolean processAllMethodNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.METHODS, processor, scope, filter);
    }

    public boolean processAllFieldNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.FIELDS, processor, scope, filter);
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(9);
        }
        Collection methods = StubIndex.getElements(JavaStubIndexKeys.METHODS, (Object)name, (Project)this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), PsiMethod.class);
        PsiMethod[] psiMethodArray = (PsiMethod[])this.filterMembers(methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(12);
        }
        SmartList methods = new SmartList();
        CommonProcessors.CollectProcessor<PsiMethod> processor = new CommonProcessors.CollectProcessor<PsiMethod>((Collection)methods, (List)methods, maxCount){
            final /* synthetic */ List val$methods;
            final /* synthetic */ int val$maxCount;
            {
                this.val$methods = list;
                this.val$maxCount = n;
                super(arg0);
            }

            public boolean process(PsiMethod method) {
                return this.val$methods.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), scope, PsiMethod.class, (Processor)processor);
        PsiMethod[] psiMethodArray = (PsiMethod[])this.filterMembers((Collection)methods, scope, (PsiMember[])PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(13);
        }
        return psiMethodArray;
    }

    public boolean processMethodsWithName(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(16);
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), scope, PsiMethod.class, processor);
    }

    @NotNull
    public String[] getAllMethodNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaMethodNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(19);
        }
        SmartList fields = new SmartList();
        CommonProcessors.CollectProcessor<PsiField> processor = new CommonProcessors.CollectProcessor<PsiField>((Collection)fields, (List)fields, maxCount){
            final /* synthetic */ List val$fields;
            final /* synthetic */ int val$maxCount;
            {
                this.val$fields = list;
                this.val$maxCount = n;
                super(arg0);
            }

            public boolean process(PsiField method) {
                return this.val$fields.size() != this.val$maxCount && super.process((Object)method);
            }
        };
        StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myManager.getProject(), scope, PsiField.class, (Processor)processor);
        PsiField[] psiFieldArray = (PsiField[])this.filterMembers((Collection)fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(20);
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(22);
        }
        Collection<PsiField> fields = JavaFieldNameIndex.getInstance().get(name, this.myManager.getProject(), scope);
        PsiField[] psiFieldArray = (PsiField[])this.filterMembers(fields, scope, (PsiMember[])PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(23);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaFieldNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(27);
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiField.class, processor);
    }

    public boolean processMethodsWithName(@NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(29);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(30);
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiMethod.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            PsiShortNamesCacheImpl.$$$reportNull$$$0(33);
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiClass.class, processor);
    }

    private <T extends PsiMember> T[] filterMembers(Collection<T> members, GlobalSearchScope scope, T[] emptyArray) {
        if (members.isEmpty()) {
            return emptyArray;
        }
        THashSet set = new THashSet(members.size(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMember>(){

            public int computeHashCode(PsiMember member) {
                int code = 0;
                PsiClass clazz = member.getContainingClass();
                if (clazz != null) {
                    String name = clazz.getName();
                    code = name != null ? (code += name.hashCode()) : (code += clazz.hashCode());
                }
                if (member instanceof PsiMethod) {
                    code += 37 * ((PsiMethod)member).getParameterList().getParametersCount();
                }
                return code;
            }

            public boolean equals(PsiMember object, PsiMember object1) {
                return PsiShortNamesCacheImpl.this.myManager.areElementsEquivalent((PsiElement)object, (PsiElement)object1);
            }
        });
        ArrayList<PsiMember> result = new ArrayList<PsiMember>(members.size());
        for (PsiMember member : members) {
            ProgressIndicatorProvider.checkCanceled();
            if (!scope.contains(member.getContainingFile().getVirtualFile()) || !set.add(member)) continue;
            result.add(member);
        }
        return (PsiMember[])result.toArray(emptyArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiShortNamesCacheImpl";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 22: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiShortNamesCacheImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

