/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl");
    private final PsiManager myManager;

    public PsiResolveHelperImpl(PsiManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result;
        if (argumentList == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(0);
        }
        JavaResolveResult javaResolveResult = (result = this.multiResolveConstructor(classType, argumentList, place)).length == 1 ? result[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(1);
        }
        return javaResolveResult;
    }

    @NotNull
    public JavaResolveResult[] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        MethodResolverProcessor processor;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass aClass;
        if (type2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(2);
        }
        if (argumentList == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(4);
        }
        if ((aClass = (classResolveResult = type2.resolveGenerics()).getElement()) == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(5);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor = new MethodResolverProcessor((PsiClass)anonymous, argumentList, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiResolveHelperImpl.$$$reportNull$$$0(6);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor = new MethodResolverProcessor(aClass, argumentList, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor.execute((PsiElement)constructor, state)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(7);
        }
        return javaResolveResultArray;
    }

    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(8);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            PsiFile containingFile = ref.getContainingFile();
            LOG.assertTrue(containingFile.isValid(), (Object)referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(9);
        }
        return this.resolveVar(referenceText, context, null);
    }

    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(10);
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context, boolean[] problemWithAccess) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(11);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(12);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(13);
        }
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        PsiClass containingClass;
        boolean accessible;
        if (member == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(15);
        }
        if ((accessible = JavaResolveUtil.isAccessible(member, containingClass = member.getContainingClass(), modifierList, place, accessObjectClass, currentFileResolveScope)) && member instanceof PsiClass) {
            accessible = PsiResolveHelperImpl.isAccessible(moduleSystem -> {
                if (member == null) {
                    PsiResolveHelperImpl.$$$reportNull$$$0(60);
                }
                if (place == null) {
                    PsiResolveHelperImpl.$$$reportNull$$$0(61);
                }
                return moduleSystem.isAccessible((PsiClass)member, place);
            });
        }
        return accessible;
    }

    public boolean isAccessible(@NotNull PsiPackage pkg, @NotNull PsiElement place) {
        if (pkg == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(17);
        }
        return PsiResolveHelperImpl.isAccessible(moduleSystem -> {
            if (pkg == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(58);
            }
            if (place == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(59);
            }
            return moduleSystem.isAccessible(pkg.getQualifiedName(), null, place);
        });
    }

    private static boolean isAccessible(Predicate<JavaModuleSystem> predicate) {
        return Stream.of(JavaModuleSystem.EP_NAME.getExtensions()).allMatch(predicate);
    }

    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(18);
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor((PsiElement)expr, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(19);
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor.getCandidates();
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(20);
        }
        return candidateInfoArray;
    }

    @NotNull
    public CandidateInfo[] getReferencedMethodCandidates(@NotNull PsiCallExpression call, boolean dummyImplicitConstructor) {
        if (call == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(21);
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(22);
        }
        return candidateInfoArray;
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(23);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(24);
        }
        if (arguments == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(25);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(26);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(27);
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel((PsiElement)(parent != null ? parent : typeParameter))).inferTypeForMethodTypeParameter(typeParameter, parameters2, arguments, partialSubstitutor, parent, policy);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameters == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(28);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(29);
        }
        if (arguments == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(30);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(31);
        }
        if (parent == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(32);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(33);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel((PsiElement)parent)).inferTypeArguments(typeParameters, parameters2, arguments, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel((PsiElement)parent));
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(34);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(35);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(36);
        }
        if (arguments == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(37);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(38);
        }
        if (parent == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(39);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(40);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(41);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, parameters2, arguments, partialSubstitutor, parent, policy, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(42);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(43);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(44);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(45);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(46);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(47);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(48);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(49);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(50);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(51);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(52);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, leftTypes, rightTypes, partialSubstitutor, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(53);
        }
        return psiSubstitutor;
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(54);
        }
        return languageLevel;
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(55);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiGraphInferenceHelper psiGraphInferenceHelper = new PsiGraphInferenceHelper(this.myManager);
            if (psiGraphInferenceHelper == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(56);
            }
            return psiGraphInferenceHelper;
        }
        PsiOldInferenceHelper psiOldInferenceHelper = new PsiOldInferenceHelper(this.myManager);
        if (psiOldInferenceHelper == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(57);
        }
        return psiOldInferenceHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 47: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 47: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 47: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 17: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 12: 
            case 14: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 16: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 24: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 25: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 26: 
            case 31: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 27: 
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 28: 
            case 35: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 41: 
            case 46: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypes";
                break;
            }
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveConstructor";
                break;
            }
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedMethodCandidates";
                break;
            }
            case 34: 
            case 42: 
            case 47: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLanguageLevel";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferenceHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 47: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveConstructor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAccessibleReferencedVariable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveVar";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedMethodCandidates";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameter";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceHelper";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAccessible$1";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAccessible$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 42: 
            case 47: 
            case 53: 
            case 54: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

