/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiParameterizedCachedValue;
import com.intellij.psi.impl.source.tree.injected.InjectionRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.InjectionResult;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaConcatenationInjectorManager
extends SimpleModificationTracker {
    public static final ExtensionPointName<ConcatenationAwareInjector> CONCATENATION_INJECTOR_EP_NAME = ExtensionPointName.create((String)"com.intellij.concatenationAwareInjector");
    private static final Key<ParameterizedCachedValue<InjectionResult, PsiElement>> INJECTED_PSI_IN_CONCATENATION = Key.create((String)"INJECTED_PSI_IN_CONCATENATION");
    private static final Key<Integer> NO_CONCAT_INJECTION_TIMESTAMP = Key.create((String)"NO_CONCAT_INJECTION_TIMESTAMP");
    private final List<ConcatenationAwareInjector> myConcatenationInjectors = ContainerUtil.createLockFreeCopyOnWriteList();

    public JavaConcatenationInjectorManager(Project project, PsiManagerEx psiManagerEx) {
        ExtensionPoint concatPoint = Extensions.getArea((AreaInstance)project).getExtensionPoint(CONCATENATION_INJECTOR_EP_NAME);
        concatPoint.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConcatenationAwareInjector>(){

            public void extensionAdded(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaConcatenationInjectorManager.this.registerConcatenationInjector(injector);
            }

            public void extensionRemoved(@NotNull ConcatenationAwareInjector injector, @Nullable PluginDescriptor pluginDescriptor) {
                if (injector == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavaConcatenationInjectorManager.this.unregisterConcatenationInjector(injector);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "injector";
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        psiManagerEx.registerRunnableToRunOnAnyChange(() -> ((JavaConcatenationInjectorManager)this).incModificationCount());
    }

    public static JavaConcatenationInjectorManager getInstance(Project project) {
        return (JavaConcatenationInjectorManager)((Object)ServiceManager.getService((Project)project, JavaConcatenationInjectorManager.class));
    }

    private static InjectionResult doCompute(@NotNull PsiFile containingFile, @NotNull Project project, @NotNull PsiElement anchor, @NotNull PsiElement[] operands2) {
        if (containingFile == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(2);
        }
        if (operands2 == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(3);
        }
        InjectionRegistrarImpl registrar = new InjectionRegistrarImpl(project, containingFile, anchor);
        InjectionResult result = null;
        JavaConcatenationInjectorManager concatenationInjectorManager = JavaConcatenationInjectorManager.getInstance(project);
        for (ConcatenationAwareInjector concatenationInjector : concatenationInjectorManager.myConcatenationInjectors) {
            concatenationInjector.getLanguagesToInject((MultiHostRegistrar)registrar, operands2);
            result = registrar.getInjectedResult();
            if (result == null) continue;
            break;
        }
        return result;
    }

    public void registerConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(4);
        }
        this.myConcatenationInjectors.add(injector);
        this.concatenationInjectorsChanged();
    }

    public boolean unregisterConcatenationInjector(@NotNull ConcatenationAwareInjector injector) {
        if (injector == null) {
            JavaConcatenationInjectorManager.$$$reportNull$$$0(5);
        }
        boolean removed = this.myConcatenationInjectors.remove(injector);
        this.concatenationInjectorsChanged();
        return removed;
    }

    private void concatenationInjectorsChanged() {
        this.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCompute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConcatenationInjector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterConcatenationInjector";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Concatenation2InjectorAdapter
    extends BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private static final List<Class<PsiLiteralExpression>> LITERALS = Collections.singletonList(PsiLiteralExpression.class);

        public Concatenation2InjectorAdapter(JavaConcatenationInjectorManager manager) {
            super(manager);
        }

        @Override
        public Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement context) {
            PsiElement anchor;
            PsiExpression[] operands2;
            if (context == null) {
                Concatenation2InjectorAdapter.$$$reportNull$$$0(0);
            }
            PsiElement element = context;
            PsiElement parent = context.getParent();
            while (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.PLUS || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType() == JavaTokenType.PLUSEQ || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != element || parent instanceof PsiTypeCastExpression || parent instanceof PsiParenthesizedExpression) {
                element = parent;
                parent = parent.getParent();
            }
            if (element instanceof PsiPolyadicExpression) {
                operands2 = ((PsiPolyadicExpression)element).getOperands();
                anchor = element;
            } else if (element instanceof PsiAssignmentExpression) {
                PsiExpression rExpression = ((PsiAssignmentExpression)element).getRExpression();
                operands2 = new PsiElement[]{rExpression == null ? element : rExpression};
                anchor = element;
            } else {
                operands2 = new PsiElement[]{context};
                anchor = context;
            }
            return Pair.create((Object)anchor, (Object)operands2);
        }

        @NotNull
        public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
            List<Class<PsiLiteralExpression>> list = LITERALS;
            if (list == null) {
                Concatenation2InjectorAdapter.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$Concatenation2InjectorAdapter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elementsToInjectIn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAnchorAndOperands";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseConcatenation2InjectorAdapter
    implements MultiHostInjector {
        private final JavaConcatenationInjectorManager myManager;

        public BaseConcatenation2InjectorAdapter(JavaConcatenationInjectorManager manager) {
            this.myManager = manager;
        }

        public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
            InjectionResult result;
            if (registrar == null) {
                BaseConcatenation2InjectorAdapter.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BaseConcatenation2InjectorAdapter.$$$reportNull$$$0(1);
            }
            if (this.myManager.myConcatenationInjectors.isEmpty()) {
                return;
            }
            PsiFile containingFile = ((InjectionRegistrarImpl)registrar).getHostPsiFile();
            Project project = containingFile.getProject();
            long modificationCount = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
            Pair<PsiElement, PsiElement[]> pair = this.computeAnchorAndOperands(context);
            PsiElement anchor = (PsiElement)pair.first;
            PsiElement[] operands2 = (PsiElement[])pair.second;
            Integer noInjectionTimestamp = (Integer)anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP);
            ParameterizedCachedValue data = null;
            if (operands2.length == 0 || noInjectionTimestamp != null && (long)noInjectionTimestamp.intValue() == modificationCount) {
                result = null;
            } else {
                data = (ParameterizedCachedValue)anchor.getUserData(INJECTED_PSI_IN_CONCATENATION);
                InjectionResult injectionResult = result = data == null ? null : (InjectionResult)data.getValue((Object)context);
                if (result == null || !result.isValid()) {
                    result = JavaConcatenationInjectorManager.doCompute(containingFile, project, anchor, operands2);
                }
            }
            if (result != null) {
                ((InjectionRegistrarImpl)registrar).addToResults(result);
                if (data == null) {
                    CachedValueProvider.Result cachedResult = CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myManager});
                    data = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(context1 -> {
                        PsiFile containingFile1 = context1.getContainingFile();
                        Project project1 = containingFile1.getProject();
                        Pair<PsiElement, PsiElement[]> pair1 = this.computeAnchorAndOperands((PsiElement)context1);
                        InjectionResult result1 = ((PsiElement[])pair1.second).length == 0 ? null : JavaConcatenationInjectorManager.doCompute(containingFile1, project1, (PsiElement)pair1.first, (PsiElement[])pair1.second);
                        return result1 == null ? null : CachedValueProvider.Result.create((Object)result1, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myManager});
                    }, false);
                    ((PsiParameterizedCachedValue)data).setValue(cachedResult);
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, (Object)data);
                    if (anchor.getUserData(NO_CONCAT_INJECTION_TIMESTAMP) != null) {
                        anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, null);
                    }
                }
            } else {
                if (anchor.getUserData(INJECTED_PSI_IN_CONCATENATION) != null) {
                    anchor.putUserData(INJECTED_PSI_IN_CONCATENATION, null);
                }
                anchor.putUserData(NO_CONCAT_INJECTION_TIMESTAMP, (Object)((int)modificationCount));
            }
        }

        protected abstract Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/tree/injected/JavaConcatenationInjectorManager$BaseConcatenation2InjectorAdapter";
            objectArray[2] = "getLanguagesToInject";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

