/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFileElement
extends FileElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.JavaFileElement");

    public JavaFileElement(CharSequence text2) {
        super((IElementType)JavaStubElementTypes.JAVA_FILE, text2);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiJavaFile file;
        if (child == null) {
            JavaFileElement.$$$reportNull$$$0(0);
        }
        if (child.getElementType() == JavaElementType.CLASS && (file = (PsiJavaFile)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)this)).getClasses().length == 1) {
            file.delete();
            return;
        }
        super.deleteChildInternal(child);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 1: {
                return this.findChildByType(JavaElementType.PACKAGE_STATEMENT);
            }
            case 2: 
        }
        return this.findChildByType(JavaElementType.IMPORT_LIST);
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.PACKAGE_STATEMENT) {
            return 1;
        }
        if (i == JavaElementType.IMPORT_LIST) {
            return 2;
        }
        if (i == JavaElementType.CLASS) {
            return 3;
        }
        return 0;
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            JavaFileElement.$$$reportNull$$$0(1);
        }
        if (newElement == null) {
            JavaFileElement.$$$reportNull$$$0(2);
        }
        if (newElement.getElementType() == JavaElementType.IMPORT_LIST) {
            ASTNode next;
            LOG.assertTrue(child.getElementType() == JavaElementType.IMPORT_LIST);
            if (newElement.getFirstChildNode() == null && (next = child.getTreeNext()) != null && next.getElementType() == TokenType.WHITE_SPACE) {
                this.removeChild(next);
            }
        }
        super.replaceChildInternal(child, newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/JavaFileElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceChildInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

