/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubsHierarchy.ClassHierarchy;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.AnchorRepository;
import com.intellij.psi.stubsHierarchy.impl.StubClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleClassHierarchy
extends ClassHierarchy {
    private final BitSet myCoveredFiles;
    private final BitSet myAmbiguousSupers;
    private final BitSet myAnonymous;
    private final AnchorRepository myClassAnchors;
    private final int[] myClassAnchorsByFileIds;
    private int[] mySubtypes;
    private int[] mySubtypeStarts;

    public SingleClassHierarchy(Symbol.ClassSymbol[] classSymbols, AnchorRepository classAnchors) {
        classAnchors.trimToSize();
        this.myClassAnchors = classAnchors;
        this.myCoveredFiles = this.calcCoveredFiles(classSymbols);
        this.myClassAnchorsByFileIds = this.mkByFileId();
        this.excludeUncoveredFiles(classSymbols);
        this.connectSubTypes(classSymbols);
        this.myAmbiguousSupers = SingleClassHierarchy.calcAmbiguousSupers(classSymbols);
        this.myAnonymous = SingleClassHierarchy.calcAnonymous(classSymbols);
    }

    @NotNull
    private static BitSet calcAmbiguousSupers(Symbol.ClassSymbol[] classSymbols) {
        BitSet ambiguousSupers = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (symbol.isHierarchyIncomplete() || !symbol.hasAmbiguousSupers()) continue;
            ambiguousSupers.set(symbol.myAnchorId);
        }
        BitSet bitSet = ambiguousSupers;
        if (bitSet == null) {
            SingleClassHierarchy.$$$reportNull$$$0(0);
        }
        return bitSet;
    }

    @NotNull
    private static BitSet calcAnonymous(Symbol.ClassSymbol[] classSymbols) {
        BitSet answer = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (symbol.isHierarchyIncomplete() || symbol.myShortName != 0) continue;
            answer.set(symbol.myAnchorId);
        }
        BitSet bitSet = answer;
        if (bitSet == null) {
            SingleClassHierarchy.$$$reportNull$$$0(1);
        }
        return bitSet;
    }

    @NotNull
    private BitSet calcCoveredFiles(Symbol.ClassSymbol[] classSymbols) {
        BitSet problematicFiles = new BitSet();
        BitSet coveredFiles = new BitSet();
        for (Symbol.ClassSymbol symbol : classSymbols) {
            int fileId = this.myClassAnchors.getFileId(symbol.myAnchorId);
            coveredFiles.set(fileId);
            if (!symbol.isHierarchyIncomplete()) continue;
            problematicFiles.set(fileId);
        }
        coveredFiles.andNot(problematicFiles);
        BitSet bitSet = coveredFiles;
        if (bitSet == null) {
            SingleClassHierarchy.$$$reportNull$$$0(2);
        }
        return bitSet;
    }

    private boolean isCovered(@NotNull StubClassAnchor anchor) {
        if (anchor == null) {
            SingleClassHierarchy.$$$reportNull$$$0(3);
        }
        return this.myCoveredFiles.get(anchor.myFileId);
    }

    @NotNull
    public List<StubClassAnchor> getCoveredClasses() {
        List list = ContainerUtil.filter(this.getAllClasses(), this::isCovered);
        if (list == null) {
            SingleClassHierarchy.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<StubClassAnchor> getAllClasses() {
        List<StubClassAnchor> list = IntStream.range(0, this.myClassAnchors.size()).boxed().map(this.myClassAnchors::getAnchor).collect(Collectors.toList());
        if (list == null) {
            SingleClassHierarchy.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public SmartClassAnchor[] getDirectSubtypeCandidates(@NotNull PsiClass psiClass) {
        SmartClassAnchor anchor;
        if (psiClass == null) {
            SingleClassHierarchy.$$$reportNull$$$0(6);
        }
        SmartClassAnchor[] smartClassAnchorArray = (anchor = this.findAnchor(psiClass)) == null ? StubClassAnchor.EMPTY_ARRAY : this.getDirectSubtypeCandidates(anchor);
        if (smartClassAnchorArray == null) {
            SingleClassHierarchy.$$$reportNull$$$0(7);
        }
        return smartClassAnchorArray;
    }

    @Override
    @Nullable
    public SmartClassAnchor findAnchor(@NotNull PsiClass psiClass) {
        VirtualFile vFile;
        if (psiClass == null) {
            SingleClassHierarchy.$$$reportNull$$$0(8);
        }
        return (vFile = psiClass.getContainingFile().getVirtualFile()) instanceof VirtualFileWithId ? this.forPsiClass(((VirtualFileWithId)vFile).getId(), psiClass) : null;
    }

    @Override
    @NotNull
    public SmartClassAnchor[] getDirectSubtypeCandidates(@NotNull SmartClassAnchor anchor) {
        if (anchor == null) {
            SingleClassHierarchy.$$$reportNull$$$0(9);
        }
        int symbolId = ((StubClassAnchor)anchor).myId;
        int start = this.subtypeStart(symbolId);
        int end = this.subtypeEnd(symbolId);
        int length = end - start;
        if (length == 0) {
            if (StubClassAnchor.EMPTY_ARRAY == null) {
                SingleClassHierarchy.$$$reportNull$$$0(10);
            }
            return StubClassAnchor.EMPTY_ARRAY;
        }
        SmartClassAnchor[] result = new StubClassAnchor[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.myClassAnchors.getAnchor(this.mySubtypes[start + i]);
        }
        if (result == null) {
            SingleClassHierarchy.$$$reportNull$$$0(11);
        }
        return result;
    }

    @Override
    public boolean hasAmbiguousSupers(@NotNull SmartClassAnchor anchor) {
        if (anchor == null) {
            SingleClassHierarchy.$$$reportNull$$$0(12);
        }
        return this.myAmbiguousSupers.get(((StubClassAnchor)anchor).myId);
    }

    @Override
    public boolean isAnonymous(@NotNull SmartClassAnchor anchor) {
        if (anchor == null) {
            SingleClassHierarchy.$$$reportNull$$$0(13);
        }
        return this.myAnonymous.get(((StubClassAnchor)anchor).myId);
    }

    @Override
    @NotNull
    public GlobalSearchScope restrictToUncovered(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SingleClassHierarchy.$$$reportNull$$$0(14);
        }
        if (this.myCoveredFiles.isEmpty()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                SingleClassHierarchy.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(scope, new Object[]{this}){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file instanceof VirtualFileWithId && SingleClassHierarchy.this.myCoveredFiles.get(((VirtualFileWithId)file).getId())) {
                    return false;
                }
                return super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubsHierarchy/impl/SingleClassHierarchy$1", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            SingleClassHierarchy.$$$reportNull$$$0(16);
        }
        return delegatingGlobalSearchScope;
    }

    @NotNull
    private Integer[] getAnchorsFromDistinctFiles() {
        if (this.myClassAnchors.size() == 0) {
            Integer[] integerArray = new Integer[]{};
            if (integerArray == null) {
                SingleClassHierarchy.$$$reportNull$$$0(17);
            }
            return integerArray;
        }
        Integer[] result = new Integer[this.myClassAnchors.size()];
        result[0] = 0;
        int i = 1;
        for (int classAnchor = 1; classAnchor < result.length; ++classAnchor) {
            if (this.myClassAnchors.getFileId(classAnchor - 1) == this.myClassAnchors.getFileId(classAnchor)) continue;
            result[i++] = classAnchor;
        }
        Integer[] integerArray = Arrays.copyOf(result, i);
        if (integerArray == null) {
            SingleClassHierarchy.$$$reportNull$$$0(18);
        }
        return integerArray;
    }

    private int[] mkByFileId() {
        Integer[] ids = this.getAnchorsFromDistinctFiles();
        Arrays.sort(ids, (a1, a2) -> Integer.compare(this.myClassAnchors.getFileId((int)a1), this.myClassAnchors.getFileId((int)a2)));
        return ArrayUtils.toPrimitive((Integer[])ids);
    }

    private void connectSubTypes(Symbol.ClassSymbol[] classSymbols) {
        int[] sizes = SingleClassHierarchy.calculateSizes(classSymbols);
        int[] starts = new int[classSymbols.length];
        int count = 0;
        for (int i = 0; i < sizes.length; ++i) {
            starts[i] = count;
            count += sizes[i];
        }
        int[] subtypes = new int[count];
        int[] filled = new int[sizes.length];
        for (int subTypeId = 0; subTypeId < classSymbols.length; ++subTypeId) {
            Symbol.ClassSymbol subType = classSymbols[subTypeId];
            for (Symbol.ClassSymbol superType : subType.rawSuperClasses()) {
                int superTypeId = superType.myAnchorId;
                subtypes[starts[superTypeId] + filled[superTypeId]] = subTypeId;
                int n = superTypeId;
                filled[n] = filled[n] + 1;
            }
        }
        this.mySubtypes = subtypes;
        this.mySubtypeStarts = starts;
    }

    private void excludeUncoveredFiles(Symbol.ClassSymbol[] classSymbols) {
        for (Symbol.ClassSymbol symbol : classSymbols) {
            if (this.myCoveredFiles.get(this.myClassAnchors.getFileId(symbol.myAnchorId))) continue;
            symbol.markHierarchyIncomplete();
        }
    }

    private static int[] calculateSizes(Symbol.ClassSymbol[] classSymbols) {
        int[] sizes = new int[classSymbols.length];
        for (Symbol.ClassSymbol subType : classSymbols) {
            for (Symbol.ClassSymbol superType : subType.rawSuperClasses()) {
                int n = superType.myAnchorId;
                sizes[n] = sizes[n] + 1;
            }
        }
        return sizes;
    }

    private int subtypeStart(int nameId) {
        return this.mySubtypeStarts[nameId];
    }

    private int subtypeEnd(int nameId) {
        return nameId + 1 >= this.mySubtypeStarts.length ? this.mySubtypes.length : this.mySubtypeStarts[nameId + 1];
    }

    private StubClassAnchor forPsiClass(int fileId, PsiClass psiClass) {
        int id = this.getFirst(fileId);
        if (id == -1) {
            return null;
        }
        while (id < this.myClassAnchors.size() && this.myClassAnchors.getFileId(id) == fileId) {
            if (psiClass.isEquivalentTo((PsiElement)this.myClassAnchors.retrieveClass(psiClass.getProject(), id))) {
                return this.myClassAnchors.getAnchor(id);
            }
            ++id;
        }
        return null;
    }

    private int getFirst(int fileId) {
        int lo = 0;
        int hi = this.myClassAnchorsByFileIds.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int midFileId = this.myClassAnchors.getFileId(this.myClassAnchorsByFileIds[mid]);
            if (fileId < midFileId) {
                hi = mid - 1;
                continue;
            }
            if (fileId > midFileId) {
                lo = mid + 1;
                continue;
            }
            return this.myClassAnchorsByFileIds[mid];
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubsHierarchy/impl/SingleClassHierarchy";
                break;
            }
            case 3: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAmbiguousSupers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAnonymous";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCoveredFiles";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubsHierarchy/impl/SingleClassHierarchy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectSubtypeCandidates";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictToUncovered";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorsFromDistinctFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCovered";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDirectSubtypeCandidates";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbiguousSupers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymous";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restrictToUncovered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

