/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeListener;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewDiffPanel
extends BorderLayoutPanel
implements Disposable,
PreviewTreeListener {
    private final Project myProject;
    private final ExtractMethodSnapshot mySnapshot;
    private final SmartPsiElementPointer<PsiElement> myPatternStart;
    private final SmartPsiElementPointer<PsiElement> myPatternEnd;
    private final SmartPsiElementPointer<PsiElement> myAnchor;
    private final DiffRequestPanel myDiffPanel;
    private RefactoringResult myRefactoringResult;

    public PreviewDiffPanel(@NotNull ExtractMethodProcessor processor) {
        if (processor == null) {
            PreviewDiffPanel.$$$reportNull$$$0(0);
        }
        this.myProject = processor.getProject();
        this.mySnapshot = new ExtractMethodSnapshot(processor);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        PsiElement[] elements = processor.getElements();
        this.myPatternStart = smartPointerManager.createSmartPsiElementPointer(elements[0]);
        this.myPatternEnd = smartPointerManager.createSmartPsiElementPointer(elements[elements.length - 1]);
        this.myAnchor = smartPointerManager.createSmartPsiElementPointer(processor.getAnchor());
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, null);
        this.myDiffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)"ExtractMethod");
        this.myDiffPanel.putContextHints(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        this.myDiffPanel.putContextHints(DiffUserDataKeysEx.FORCE_DIFF_TOOL, (Object)UnifiedDiffTool.INSTANCE);
        this.addToCenter(this.myDiffPanel.getComponent());
    }

    public void dispose() {
    }

    public void doExtract(List<DuplicateNode> enabledNodes) {
        PsiElement[] pattern = this.getPattern();
        if (pattern.length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)"Failed to extract method", (String)ExtractMethodHandler.REFACTORING_NAME, (String)"refactoring.extractMethod");
            return;
        }
        JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(pattern, ExtractMethodHandler.REFACTORING_NAME);
        processor.applyFromSnapshot(this.mySnapshot);
        if (!processor.prepare(true)) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)ExtractMethodHandler.REFACTORING_NAME, null, () -> PreviewDiffPanel.doExtractImpl(processor, enabledNodes), (PsiFile[])new PsiFile[]{pattern[0].getContainingFile()});
    }

    public void initLater(final @NotNull List<DuplicateNode> allNodes, final @NotNull Runnable whenDone) {
        if (allNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(1);
        }
        if (whenDone == null) {
            PreviewDiffPanel.$$$reportNull$$$0(2);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Preparing Diff"){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PreviewDiffPanel.this.initLaterImpl(allNodes, whenDone, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$1", "run"));
            }
        });
    }

    private void initLaterImpl(@NotNull List<DuplicateNode> allNodes, @NotNull Runnable whenDone, @NotNull ProgressIndicator indicator) {
        if (allNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(3);
        }
        if (whenDone == null) {
            PreviewDiffPanel.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            PreviewDiffPanel.$$$reportNull$$$0(5);
        }
        indicator.setIndeterminate(false);
        int total = allNodes.size() + 9;
        int count = 0;
        PsiElement[] patternCopy = (PsiElement[])ReadAction.compute(() -> {
            PsiElement[] pattern = this.getPattern();
            PsiFile patternFile = pattern[0].getContainingFile();
            return IntroduceParameterHandler.getElementsInCopy(this.myProject, patternFile, pattern, false);
        });
        indicator.setFraction((double)(++count) / (double)total);
        JavaDuplicatesExtractMethodProcessor copyProcessor = (JavaDuplicatesExtractMethodProcessor)ReadAction.compute(() -> {
            JavaDuplicatesExtractMethodProcessor processor = new JavaDuplicatesExtractMethodProcessor(patternCopy, ExtractMethodHandler.REFACTORING_NAME);
            processor.applyFromSnapshot(this.mySnapshot);
            return processor.prepare(false) ? processor : null;
        });
        indicator.setFraction((double)(++count) / (double)total);
        List simpleDuplicates = (List)ReadAction.compute(() -> {
            copyProcessor.previewRefactoring();
            return copyProcessor.getDuplicates();
        });
        indicator.setFraction((double)(++count) / (double)total);
        List copyDuplicates = simpleDuplicates != null ? simpleDuplicates : (List)ReadAction.compute(() -> copyProcessor.initParametrizedDuplicates(false) ? copyProcessor.getDuplicates() : null);
        indicator.setFraction((double)(++count) / (double)total);
        Map allDuplicates = (Map)ReadAction.compute(() -> {
            if (allNodes == null) {
                PreviewDiffPanel.$$$reportNull$$$0(14);
            }
            return PreviewDiffPanel.filterSelectedDuplicates(allNodes, copyDuplicates);
        });
        indicator.setFraction((double)(++count) / (double)total);
        ElementsRange originalReplacement = (ElementsRange)ReadAction.compute(() -> {
            Bounds patternBounds = new Bounds(patternCopy[0], patternCopy[patternCopy.length - 1]);
            copyProcessor.doExtract();
            return patternBounds.getElementsRange();
        });
        indicator.setFraction((double)(++count) / (double)total);
        TreeMap duplicateReplacements = new TreeMap();
        for (Map.Entry entry : allDuplicates.entrySet()) {
            DuplicateNode duplicateNode = (DuplicateNode)entry.getKey();
            Match duplicate = (Match)entry.getValue();
            ReadAction.run(() -> {
                Bounds bounds = new Bounds(duplicate.getMatchStart(), duplicate.getMatchEnd());
                copyProcessor.processMatch(duplicate);
                ElementsRange replacement = bounds.getElementsRange();
                duplicateReplacements.put(duplicateNode, replacement);
            });
            indicator.setFraction((double)(++count) / (double)total);
        }
        PsiMethod method = (PsiMethod)ReadAction.compute(() -> {
            PsiMethod extractedMethod = copyProcessor.getExtractedMethod();
            return (PsiMethod)CodeStyleManager.getInstance((Project)copyProcessor.getProject()).reformat((PsiElement)extractedMethod);
        });
        indicator.setFraction((double)(++count) / (double)total);
        Document refactoredDocument = (Document)ReadAction.compute(() -> {
            PsiFile refactoredFile = method.getContainingFile();
            if (refactoredFile != null) {
                VirtualFile vFile = refactoredFile.getViewProvider().getVirtualFile();
                vFile.putUserData(DiffUtil.TEMP_FILE_KEY, (Object)Boolean.TRUE);
                Document document = FileDocumentManager.getInstance().getDocument(vFile);
                if (document != null) {
                    PsiDocumentManager.getInstance((Project)copyProcessor.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    return document;
                }
            }
            return null;
        });
        indicator.setFraction((double)(++count) / (double)total);
        if (refactoredDocument != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (whenDone == null) {
                    PreviewDiffPanel.$$$reportNull$$$0(13);
                }
                this.myRefactoringResult = new RefactoringResult(method, originalReplacement, duplicateReplacements, refactoredDocument);
                whenDone.run();
            });
        }
    }

    private static void doExtractImpl(@NotNull JavaDuplicatesExtractMethodProcessor processor, List<DuplicateNode> selectedNodes) {
        if (processor == null) {
            PreviewDiffPanel.$$$reportNull$$$0(6);
        }
        processor.previewRefactoring();
        List<Match> duplicates = processor.getDuplicates();
        if (duplicates == null && processor.initParametrizedDuplicates(false)) {
            duplicates = processor.getDuplicates();
        }
        Map<DuplicateNode, Match> selectedDuplicates = PreviewDiffPanel.filterSelectedDuplicates(selectedNodes, duplicates);
        processor.doExtract();
        for (Match duplicate : selectedDuplicates.values()) {
            processor.processMatch(duplicate);
        }
    }

    @Override
    public void onFragmentSelected(FragmentNode node, List<DuplicateNode> enabledDuplicates) {
        DiffRequest request;
        if (this.myRefactoringResult == null) {
            this.showDiff(null);
            return;
        }
        PsiElement[] pattern = this.getPattern();
        PsiFile patternFile = pattern[0].getContainingFile();
        assert (patternFile != null) : "patternFile";
        Document patternDocument = FileDocumentManager.getInstance().getDocument(patternFile.getViewProvider().getVirtualFile());
        if (patternDocument == null) {
            return;
        }
        if (node instanceof MethodNode) {
            request = this.getMethodDiffRequest(patternDocument, this.myRefactoringResult.myDocument, this.myRefactoringResult.myMethod.getTextRange());
        } else if (node instanceof DuplicateNode) {
            DuplicateNode duplicateNode = (DuplicateNode)node;
            ElementsRange selectedReplacement = this.myRefactoringResult.myDuplicateReplacements.get(duplicateNode);
            assert (selectedReplacement != null) : "selectedReplacement";
            TextRange patternRange = duplicateNode.getTextRange();
            TextRange refactoredRange = selectedReplacement.getTextRange();
            request = this.getFragmentDiffRequest(patternDocument, patternRange, this.myRefactoringResult.myDocument, refactoredRange);
        } else {
            TextRange patternRange = DuplicateNode.getTextRange(this.myPatternStart.getElement(), this.myPatternEnd.getElement());
            TextRange refactoredRange = this.myRefactoringResult.myOriginalReplacement.getTextRange();
            request = this.getFragmentDiffRequest(patternDocument, patternRange, this.myRefactoringResult.myDocument, refactoredRange);
        }
        this.showDiff(request);
    }

    @NotNull
    private static Map<DuplicateNode, Match> filterSelectedDuplicates(@NotNull Collection<? extends FragmentNode> selectedNodes, @Nullable List<Match> allDuplicates) {
        if (selectedNodes == null) {
            PreviewDiffPanel.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.isEmpty(allDuplicates)) {
            Map<DuplicateNode, Match> map = Collections.emptyMap();
            if (map == null) {
                PreviewDiffPanel.$$$reportNull$$$0(8);
            }
            return map;
        }
        THashMap selectedDuplicates = new THashMap();
        block0: for (FragmentNode fragmentNode : selectedNodes) {
            if (!(fragmentNode instanceof DuplicateNode)) continue;
            DuplicateNode duplicateNode = (DuplicateNode)fragmentNode;
            PsiElement selectedStart = duplicateNode.getStart();
            PsiElement selectedEnd = duplicateNode.getEnd();
            if (selectedStart == null || selectedEnd == null) continue;
            TextRange selectedRange = new TextRange(selectedStart.getTextRange().getStartOffset(), selectedEnd.getTextRange().getEndOffset());
            for (Match duplicate : allDuplicates) {
                PsiElement start = duplicate.getMatchStart();
                PsiElement end = duplicate.getMatchEnd();
                if (start == null || end == null || start.getTextRange().getStartOffset() != selectedRange.getStartOffset() || end.getTextRange().getEndOffset() != selectedRange.getEndOffset()) continue;
                selectedDuplicates.put(duplicateNode, duplicate);
                continue block0;
            }
        }
        THashMap tHashMap = selectedDuplicates;
        if (tHashMap == null) {
            PreviewDiffPanel.$$$reportNull$$$0(9);
        }
        return tHashMap;
    }

    private void showDiff(@Nullable DiffRequest request) {
        this.myDiffPanel.setRequest(request);
    }

    @Nullable
    private DiffRequest getFragmentDiffRequest(Document patternDocument, TextRange patternRange, Document refactoredDocument, TextRange refactoredRange) {
        if (patternRange != null && refactoredRange != null) {
            patternRange = PreviewDiffPanel.extendRangeToStartOfLine(patternDocument, patternRange);
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            DocumentContent oldContent = contentFactory.createFragment(this.myProject, patternDocument, patternRange);
            refactoredRange = PreviewDiffPanel.extendRangeToStartOfLine(refactoredDocument, refactoredRange);
            DocumentContent newContent = contentFactory.createFragment(this.myProject, refactoredDocument, refactoredRange);
            return new SimpleDiffRequest(null, (DiffContent)oldContent, (DiffContent)newContent, null, null);
        }
        return null;
    }

    @NotNull
    private DiffRequest getMethodDiffRequest(Document patternDocument, Document refactoredDocument, TextRange refactoredRange) {
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        PsiElement element = this.myAnchor.getElement();
        int anchorOffset = element != null ? element.getTextRange().getEndOffset() : patternDocument.getTextLength();
        DocumentContent oldContent = contentFactory.createFragment(this.myProject, patternDocument, new TextRange(anchorOffset, anchorOffset));
        refactoredRange = PreviewDiffPanel.extendRangeToStartOfLine(refactoredDocument, refactoredRange);
        DocumentContent newContent = contentFactory.createFragment(this.myProject, refactoredDocument, refactoredRange);
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(null, (DiffContent)oldContent, (DiffContent)newContent, null, null);
        if (simpleDiffRequest == null) {
            PreviewDiffPanel.$$$reportNull$$$0(10);
        }
        return simpleDiffRequest;
    }

    private static TextRange extendRangeToStartOfLine(Document document, TextRange range) {
        CharSequence text2 = document.getCharsSequence();
        for (int offset = range.getStartOffset(); offset > 0; --offset) {
            char c = text2.charAt(offset - 1);
            if (c != '\n' && Character.isWhitespace(c)) continue;
            return new TextRange(offset, range.getEndOffset());
        }
        return range;
    }

    @NotNull
    private PsiElement[] getPattern() {
        ArrayList<PsiElement> pattern = new ArrayList<PsiElement>();
        PsiElement startElement = this.myPatternStart.getElement();
        PsiElement endElement = this.myPatternEnd.getElement();
        if (startElement != null && endElement != null) {
            for (PsiElement element = startElement; element != null; element = element.getNextSibling()) {
                pattern.add(element);
                if (element != endElement) continue;
                PsiElement[] psiElementArray = pattern.toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    PreviewDiffPanel.$$$reportNull$$$0(11);
                }
                return psiElementArray;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PreviewDiffPanel.$$$reportNull$$$0(12);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allNodes";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenDone";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelectedDuplicates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodDiffRequest";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initLater";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initLaterImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doExtractImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterSelectedDuplicates";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initLaterImpl$10";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initLaterImpl$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RefactoringResult {
        final PsiMethod myMethod;
        final ElementsRange myOriginalReplacement;
        final Map<DuplicateNode, ElementsRange> myDuplicateReplacements;
        final Document myDocument;

        public RefactoringResult(@NotNull PsiMethod method, @NotNull ElementsRange originalReplacement, @NotNull Map<DuplicateNode, ElementsRange> duplicateReplacements, @NotNull Document document) {
            if (method == null) {
                RefactoringResult.$$$reportNull$$$0(0);
            }
            if (originalReplacement == null) {
                RefactoringResult.$$$reportNull$$$0(1);
            }
            if (duplicateReplacements == null) {
                RefactoringResult.$$$reportNull$$$0(2);
            }
            if (document == null) {
                RefactoringResult.$$$reportNull$$$0(3);
            }
            this.myMethod = method;
            this.myOriginalReplacement = originalReplacement;
            this.myDuplicateReplacements = duplicateReplacements;
            this.myDocument = document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalReplacement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "duplicateReplacements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$RefactoringResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ElementsRange {
        PsiElement myStart;
        PsiElement myEnd;

        public ElementsRange(@NotNull PsiElement start, @NotNull PsiElement end) {
            if (start == null) {
                ElementsRange.$$$reportNull$$$0(0);
            }
            if (end == null) {
                ElementsRange.$$$reportNull$$$0(1);
            }
            this.myStart = start;
            this.myEnd = end;
        }

        public TextRange getTextRange() {
            return new TextRange(this.myStart.getTextRange().getStartOffset(), this.myEnd.getTextRange().getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "start";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "end";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$ElementsRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Bounds {
        final PsiElement myParent;
        final PsiElement myBefore;
        final PsiElement myAfter;

        public Bounds(@NotNull PsiElement start, @NotNull PsiElement end) {
            if (start == null) {
                Bounds.$$$reportNull$$$0(0);
            }
            if (end == null) {
                Bounds.$$$reportNull$$$0(1);
            }
            this.myParent = start.getParent();
            assert (this.myParent != null) : "bounds' parent is null";
            this.myBefore = PsiTreeUtil.skipSiblingsBackward((PsiElement)start, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            this.myAfter = PsiTreeUtil.skipSiblingsForward((PsiElement)end, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        }

        ElementsRange getElementsRange() {
            PsiElement end;
            PsiElement start = this.myBefore != null ? PsiTreeUtil.skipSiblingsForward((PsiElement)this.myBefore, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}) : null;
            PsiElement psiElement = end = this.myAfter != null ? PsiTreeUtil.skipSiblingsBackward((PsiElement)this.myAfter, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class}) : null;
            if (start == null) {
                start = this.myParent.getFirstChild();
            }
            if (end == null) {
                end = this.myParent.getLastChild();
            }
            if (start != null && end != null) {
                return new ElementsRange(start, end);
            }
            return new ElementsRange(this.myParent, this.myParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "start";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "end";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/extractMethod/preview/PreviewDiffPanel$Bounds";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

