/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.refactoring.extractMethod.preview.OriginalNode;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

class PreviewTreeModel
extends DefaultTreeModel {
    private DefaultMutableTreeNode myDuplicatesGroup;

    public PreviewTreeModel(ExtractMethodProcessor processor) {
        super(new DefaultMutableTreeNode(""));
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode methodGroup = new DefaultMutableTreeNode("Method to extract");
        root.add(methodGroup);
        methodGroup.add(new MethodNode(processor.generateEmptyMethod(processor.getMethodName(), (PsiElement)processor.getTargetClass())));
        DefaultMutableTreeNode originalGroup = new DefaultMutableTreeNode("Original code fragment");
        root.add(originalGroup);
        PsiElement[] elements = processor.getElements();
        originalGroup.add(new OriginalNode(elements));
        List<Match> duplicates = processor.getDuplicates();
        if (!ContainerUtil.isEmpty(duplicates)) {
            this.myDuplicatesGroup = new DefaultMutableTreeNode("Duplicate code fragments");
            root.add(this.myDuplicatesGroup);
            for (Match duplicate : duplicates) {
                this.myDuplicatesGroup.add(new DuplicateNode(duplicate));
            }
        }
    }

    public List<DuplicateNode> getEnabledDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                DuplicateNode duplicateNode;
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode) || (duplicateNode = (DuplicateNode)node).isExcluded() || !duplicateNode.isValid()) continue;
                duplicates.add(duplicateNode);
            }
            return duplicates;
        }
        return Collections.emptyList();
    }

    public List<DuplicateNode> getAllDuplicates() {
        if (this.myDuplicatesGroup != null && this.myDuplicatesGroup.getChildCount() != 0) {
            ArrayList<DuplicateNode> duplicates = new ArrayList<DuplicateNode>();
            for (int i = 0; i < this.myDuplicatesGroup.getChildCount(); ++i) {
                TreeNode node = this.myDuplicatesGroup.getChildAt(i);
                if (!(node instanceof DuplicateNode)) continue;
                duplicates.add((DuplicateNode)node);
            }
            return duplicates;
        }
        return Collections.emptyList();
    }
}

