/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueClassNode;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class SliceNullnessAnalyzerBase {
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceNullnessAnalyzerBase(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        if (leafEquality == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(1);
        }
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    private void groupByNullness(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = this.createNewTree(result, oldRoot, map);
        SliceUsage rootUsage = (SliceUsage)((SliceNode)oldRoot.myCachedChildren.get(0)).getValue();
        SliceManager.getInstance((Project)root.getProject()).createToolWindow(true, root, true, SliceManager.getElementDescription(null, (PsiElement)rootUsage.getElement(), (String)" Grouped by Nullness"));
    }

    @NotNull
    public SliceRootNode createNewTree(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList();
        this.createValueRootNode(result, oldRoot, map, root, oldRootStart, "Null Values", 0);
        this.createValueRootNode(result, oldRoot, map, root, oldRootStart, "NotNull Values", 1);
        this.createValueRootNode(result, oldRoot, map, root, oldRootStart, "Other Values", 2);
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(2);
        }
        return sliceRootNode;
    }

    private void createValueRootNode(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map, SliceRootNode root, SliceNode oldRootStart, String nodeName, int group) {
        Collection<PsiElement> groupedByValue = result.groupedByValue[group];
        if (groupedByValue.isEmpty()) {
            return;
        }
        SliceLeafValueClassNode valueRoot = new SliceLeafValueClassNode(root.getProject(), (SliceNode)root, nodeName);
        root.myCachedChildren.add(valueRoot);
        THashSet uniqueValues = new THashSet(groupedByValue, (TObjectHashingStrategy)this.myLeafEquality);
        for (PsiElement expression2 : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree((SliceNode)oldRootStart, oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                for (PsiElement nullSuspect : SliceNullnessAnalyzerBase.group(oldNode, map, group)) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression2)) continue;
                    return oldNode.copy();
                }
                return null;
            }, (node, children) -> {
                if (!children.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)node.getValue()).getElement();
                if (element == null) {
                    return false;
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression2);
            });
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), (SliceNode)valueRoot, this.myProvider.createRootUsage(expression2, ((SliceUsage)oldRoot.getValue()).params), Collections.singletonList(newRoot)));
        }
    }

    public void startAnalyzeNullness(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        if (treeStructure == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(3);
        }
        if (finish == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(4);
        }
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map = SliceNullnessAnalyzerBase.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                NullAnalysisResult l = SliceNullnessAnalyzerBase.this.calcNullableLeaves((SliceNode)root, treeStructure, map);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    SliceNullnessAnalyzerBase.this.groupByNullness(leaves, root, map);
                }
                finally {
                    finish.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/slicer/SliceNullnessAnalyzerBase$1", "run"));
            }
        });
    }

    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return FactoryMap.createMap(k -> new NullAnalysisResult(), ContainerUtil::newIdentityTroveMap);
    }

    private static NullAnalysisResult node(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls) {
        if (node == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(5);
        }
        if (nulls == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(6);
        }
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls, int group) {
        if (node == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(7);
        }
        if (nulls == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(8);
        }
        return nulls.get((Object)node).groupedByValue[group];
    }

    @NotNull
    public NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, NullAnalysisResult> map) {
        if (root == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(9);
        }
        if (treeStructure == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(10);
        }
        if (map == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(11);
        }
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(@NotNull SliceNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                element.calculateDupNode();
                SliceNullnessAnalyzerBase.node(element, map).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceNullnessAnalyzerBase.node(element, map).add(SliceNullnessAnalyzerBase.node(duplicate, map));
                } else {
                    PsiElement value2 = (PsiElement)ReadAction.compute(() -> {
                        if (element == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return ((SliceUsage)element.getValue()).getElement();
                    });
                    Nullness nullness = (Nullness)((Object)ReadAction.compute(() -> SliceNullnessAnalyzerBase.this.checkNullness(value2)));
                    if (nullness == Nullness.NULLABLE) {
                        SliceNullnessAnalyzerBase.group(element, map, 0).add(value2);
                    } else if (nullness == Nullness.NOT_NULL) {
                        SliceNullnessAnalyzerBase.group(element, map, 1).add(value2);
                    } else {
                        Collection children = (Collection)ReadAction.compute(() -> {
                            if (element == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            return element.getChildren();
                        });
                        if (children.isEmpty()) {
                            SliceNullnessAnalyzerBase.group(element, map, 2).add(value2);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                SliceNode parent;
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((parent = guide.getParent(element)) != null) {
                    SliceNullnessAnalyzerBase.node(parent, map).add(SliceNullnessAnalyzerBase.node(element, map));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/slicer/SliceNullnessAnalyzerBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$visit$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$visit$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        walkingState.visit((Object)root);
        NullAnalysisResult nullAnalysisResult = SliceNullnessAnalyzerBase.node(root, map);
        if (nullAnalysisResult == null) {
            SliceNullnessAnalyzerBase.$$$reportNull$$$0(12);
        }
        return nullAnalysisResult;
    }

    @NotNull
    protected abstract Nullness checkNullness(PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafEquality";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/SliceNullnessAnalyzerBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nulls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/SliceNullnessAnalyzerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNullableLeaves";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startAnalyzeNullness";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "node";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcNullableLeaves";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NullAnalysisResult {
        static final int NULLS = 0;
        static final int NOT_NULLS = 1;
        static final int UNKNOWNS = 2;
        final Collection<PsiElement>[] groupedByValue = new Collection[]{new THashSet(), new THashSet(), new THashSet()};

        public void clear() {
            for (Collection<PsiElement> elements : this.groupedByValue) {
                elements.clear();
            }
        }

        private void add(NullAnalysisResult duplicate) {
            for (int i = 0; i < this.groupedByValue.length; ++i) {
                Collection<PsiElement> elements = this.groupedByValue[i];
                Collection<PsiElement> other = duplicate.groupedByValue[i];
                elements.addAll(other);
            }
        }
    }
}

