/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspection
extends BaseGlobalInspection {
    public boolean ignoreTestClasses = false;
    public boolean ignoreAnonymousClasses = true;
    public boolean ignoreOnConflicts = true;
    static final Key<SmartPsiElementPointer<PsiClass>> MARKER = Key.create((String)"STATIC_METHOD_USED_IN_ONE_CLASS");

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.display.name", new Object[0]);
        if (string == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.test.option", new Object[0]), "ignoreTestClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.anonymous.option", new Object[0]), "ignoreAnonymousClasses");
        panel.addCheckbox(InspectionGadgetsBundle.message("static.method.only.used.in.one.class.ignore.on.conflicts", new Object[0]), "ignoreOnConflicts");
        return panel;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod method = (RefMethod)refEntity;
        if (!method.isStatic() || method.getAccessModifier() == "private") {
            return null;
        }
        RefClass usageClass = null;
        for (RefElement reference : method.getInReferences()) {
            RefClass ownerClass = RefJavaUtil.getInstance().getOwnerClass(reference);
            if (usageClass == null) {
                usageClass = ownerClass;
                continue;
            }
            if (usageClass == ownerClass) continue;
            return null;
        }
        RefClass containingClass = method.getOwnerClass();
        if (usageClass == containingClass) {
            return null;
        }
        if (usageClass == null) {
            PsiClass aClass = containingClass.getElement();
            if (aClass != null) {
                SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)manager.getProject());
                method.putUserData(MARKER, (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)aClass));
            }
            return null;
        }
        if (this.ignoreAnonymousClasses && (usageClass.isAnonymous() || usageClass.isLocalClass() || usageClass.getOwner() instanceof RefClass && !usageClass.isStatic())) {
            return null;
        }
        if (this.ignoreTestClasses && usageClass.isTestCase()) {
            return null;
        }
        PsiClass psiClass = usageClass.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)method.getElement();
        if (psiMethod == null) {
            return null;
        }
        if (this.ignoreOnConflicts && (psiClass.findMethodsBySignature(psiMethod, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)psiMethod, (PsiElement)psiClass))) {
            return null;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)manager.getProject());
        method.putUserData(MARKER, (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiClass));
        return new ProblemDescriptor[]{StaticMethodOnlyUsedInOneClassInspection.createProblemDescriptor(manager, (PsiElement)psiMethod.getNameIdentifier(), psiClass)};
    }

    @NotNull
    static ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager manager, PsiElement problemElement, PsiClass usageClass) {
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(5);
        }
        String message2 = usageClass instanceof PsiAnonymousClass ? InspectionGadgetsBundle.message("static.method.only.used.in.one.anonymous.class.problem.descriptor", ((PsiAnonymousClass)usageClass).getBaseClassReference().getText()) : InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", usageClass.getName());
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(problemElement, message2, false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        if (problemDescriptor == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(6);
        }
        return problemDescriptor;
    }

    public boolean queryExternalUsagesRequests(final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (manager == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(8);
        }
        if (problemDescriptionsProcessor == null) {
            StaticMethodOnlyUsedInOneClassInspection.$$$reportNull$$$0(9);
        }
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(final @NotNull RefEntity refEntity) {
                SmartPsiElementPointer classPointer;
                if (refEntity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (refEntity instanceof RefMethod && (classPointer = (SmartPsiElementPointer)refEntity.getUserData(MARKER)) != null) {
                    final Ref ref = Ref.create((Object)classPointer.getElement());
                    GlobalJavaInspectionContext globalJavaContext = (GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT);
                    globalJavaContext.enqueueMethodUsagesProcessor((RefMethod)refEntity, new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference reference) {
                            PsiClass containingClass = ClassUtils.getContainingClass(reference.getElement());
                            if (problemDescriptionsProcessor.getDescriptions(refEntity) != null) {
                                if (containingClass != ref.get()) {
                                    problemDescriptionsProcessor.ignoreElement(refEntity);
                                    return false;
                                }
                                return true;
                            }
                            PsiIdentifier identifier = ((PsiMethod)((RefMethod)refEntity).getElement()).getNameIdentifier();
                            ProblemDescriptor problemDescriptor = StaticMethodOnlyUsedInOneClassInspection.createProblemDescriptor(manager, (PsiElement)identifier, containingClass);
                            problemDescriptionsProcessor.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                            ref.set((Object)containingClass);
                            return true;
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$1", "visitElement"));
            }
        });
        return false;
    }

    static boolean areReferenceTargetsAccessible(PsiElement elementToCheck, PsiElement place) {
        AccessibleVisitor visitor = new AccessibleVisitor(elementToCheck, place);
        elementToCheck.accept((PsiElementVisitor)visitor);
        return visitor.isAccessible();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new StaticMethodOnlyUsedInOneClassLocalInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StaticMethodOnlyUsedInOneClassLocalInspection
    extends BaseSharedLocalInspection<StaticMethodOnlyUsedInOneClassInspection> {
        public StaticMethodOnlyUsedInOneClassLocalInspection(StaticMethodOnlyUsedInOneClassInspection settingsDelegate) {
            super(settingsDelegate);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            PsiClass usageClass = (PsiClass)infos[0];
            String string = usageClass instanceof PsiAnonymousClass ? InspectionGadgetsBundle.message("static.method.only.used.in.one.anonymous.class.problem.descriptor", ((PsiAnonymousClass)usageClass).getBaseClassReference().getText()) : InspectionGadgetsBundle.message("static.method.only.used.in.one.class.problem.descriptor", usageClass.getName());
            if (string == null) {
                StaticMethodOnlyUsedInOneClassLocalInspection.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        protected InspectionGadgetsFix buildFix(Object ... infos) {
            PsiClass usageClass = (PsiClass)infos[0];
            return new StaticMethodOnlyUsedInOneClassFix(usageClass);
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new StaticMethodOnlyUsedInOneClassVisitor();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassLocalInspection", "buildErrorString"));
        }

        private class StaticMethodOnlyUsedInOneClassVisitor
        extends BaseInspectionVisitor {
            private StaticMethodOnlyUsedInOneClassVisitor() {
            }

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                if (!method.hasModifierProperty("static") || method.hasModifierProperty("private") || method.getNameIdentifier() == null) {
                    return;
                }
                if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)method, true)) {
                    return;
                }
                UsageProcessor usageProcessor = new UsageProcessor();
                PsiClass usageClass = usageProcessor.findUsageClass(method);
                if (usageClass == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (usageClass.equals(containingClass)) {
                    return;
                }
                if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreTestClasses && TestUtils.isInTestCode((PsiElement)usageClass)) {
                    return;
                }
                if (usageClass.getContainingClass() != null && !usageClass.hasModifierProperty("static") || PsiUtil.isLocalOrAnonymousClass((PsiClass)usageClass)) {
                    if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreAnonymousClasses) {
                        return;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)usageClass, (boolean)true)) {
                        return;
                    }
                }
                if (((StaticMethodOnlyUsedInOneClassInspection)((StaticMethodOnlyUsedInOneClassLocalInspection)StaticMethodOnlyUsedInOneClassLocalInspection.this).mySettingsDelegate).ignoreOnConflicts && (usageClass.findMethodsBySignature(method, true).length > 0 || !StaticMethodOnlyUsedInOneClassInspection.areReferenceTargetsAccessible((PsiElement)method, (PsiElement)usageClass))) {
                    return;
                }
                this.registerMethodError(method, usageClass);
            }
        }

        private static class StaticMethodOnlyUsedInOneClassFix
        extends RefactoringInspectionGadgetsFix {
            private final SmartPsiElementPointer<PsiClass> usageClass;

            public StaticMethodOnlyUsedInOneClassFix(PsiClass usageClass) {
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)usageClass.getProject());
                this.usageClass = pointerManager.createSmartPsiElementPointer((PsiElement)usageClass);
            }

            @NotNull
            public String getFamilyName() {
                String string = InspectionGadgetsBundle.message("static.method.only.used.in.one.class.quickfix", new Object[0]);
                if (string == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public RefactoringActionHandler getHandler() {
                RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
                if (refactoringActionHandler == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(1);
                }
                return refactoringActionHandler;
            }

            @NotNull
            public DataContext enhanceDataContext(DataContext context) {
                DataContext dataContext = SimpleDataContext.getSimpleContext((String)LangDataKeys.TARGET_PSI_ELEMENT.getName(), (Object)this.usageClass.getElement(), (DataContext)context);
                if (dataContext == null) {
                    StaticMethodOnlyUsedInOneClassFix.$$$reportNull$$$0(2);
                }
                return dataContext;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/siyeh/ig/abstraction/StaticMethodOnlyUsedInOneClassInspection$StaticMethodOnlyUsedInOneClassLocalInspection$StaticMethodOnlyUsedInOneClassFix";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHandler";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "enhanceDataContext";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    private static class UsageProcessor
    implements Processor<PsiReference> {
        private final AtomicReference<PsiClass> foundClass = new AtomicReference();

        private UsageProcessor() {
        }

        public boolean process(PsiReference reference) {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            PsiClass usageClass = ClassUtils.getContainingClass(element);
            if (usageClass == null) {
                return true;
            }
            if (this.foundClass.compareAndSet(null, usageClass)) {
                return true;
            }
            PsiClass aClass = this.foundClass.get();
            PsiManager manager = usageClass.getManager();
            return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)usageClass);
        }

        @Nullable
        public PsiClass findUsageClass(PsiMethod method) {
            ProgressManager.getInstance().runProcess(() -> {
                Query query = MethodReferencesSearch.search((PsiMethod)method);
                if (!query.forEach((Processor)this)) {
                    this.foundClass.set(null);
                }
            }, null);
            return this.foundClass.get();
        }
    }

    private static class AccessibleVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myElementToCheck;
        private final PsiElement myPlace;
        private boolean myAccessible = true;

        public AccessibleVisitor(PsiElement elementToCheck, PsiElement place) {
            this.myElementToCheck = elementToCheck;
            this.myPlace = place;
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            if (!this.myAccessible) {
                return;
            }
            super.visitCallExpression(callExpression);
            PsiMethod method = callExpression.resolveMethod();
            if (callExpression instanceof PsiNewExpression && method == null) {
                PsiNewExpression newExpression = (PsiNewExpression)callExpression;
                PsiJavaCodeReferenceElement reference = newExpression.getClassReference();
                if (reference != null) {
                    this.checkElement(reference.resolve());
                }
            } else {
                this.checkElement((PsiElement)method);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (!this.myAccessible) {
                return;
            }
            super.visitReferenceExpression(expression2);
            this.checkElement(expression2.resolve());
        }

        private void checkElement(PsiElement element) {
            if (!(element instanceof PsiMember)) {
                return;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myElementToCheck, (PsiElement)element, (boolean)false)) {
                return;
            }
            this.myAccessible = PsiUtil.isAccessible((PsiMember)((PsiMember)element), (PsiElement)this.myPlace, null);
        }

        public boolean isAccessible() {
            return this.myAccessible;
        }
    }
}

