/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MismatchedStringBuilderQueryUpdateInspection
extends BaseInspection {
    @NonNls
    static final Set<String> returnSelfNames = ContainerUtil.set((Object[])new String[]{"append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse"});

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfStringBuilder" == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(0);
        }
        return "MismatchedQueryAndUpdateOfStringBuilder";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.query.update.display.name", new Object[0]);
        if (string == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        PsiType type2 = (PsiType)infos[1];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.string.builder.updated.problem.descriptor", type2.getPresentableText());
            if (string == null) {
                MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.queried.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedQueryAndUpdateOfStringBuilderVisitor();
    }

    static boolean hasReferenceToVariable(PsiVariable variable, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            return referenceExpression.isReferenceTo((PsiElement)variable);
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            PsiExpression expression2 = parenthesizedExpression.getExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)expression2);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (returnSelfNames.contains(name)) {
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)methodExpression.getQualifierExpression());
            }
        } else if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)thenExpression2)) {
                return true;
            }
            PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)elseExpression2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringBuilderQueryCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> queryNames = ContainerUtil.set((Object[])new String[]{"toString", "indexOf", "lastIndexOf", "capacity", "charAt", "codePointAt", "codePointBefore", "codePointCount", "equals", "getChars", "hashCode", "length", "offsetByCodePoints", "subSequence", "substring"});
        private final PsiVariable variable;
        private boolean queried;

        StringBuilderQueryCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isQueried() {
            return this.queried;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(0);
            }
            if (this.queried) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.queried) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type2 = polyadicExpression.getType();
            if (type2 == null || !type2.equalsToText("java.lang.String")) {
                return;
            }
            this.queried = true;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.queried) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!queryNames.contains(name)) {
                if (returnSelfNames.contains(name) && MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression2) && StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)expression2)) {
                    this.queried = true;
                }
                return;
            }
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression2)) {
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
                if (parent instanceof PsiStatement && !SideEffectChecker.mayHaveSideEffects(parent, e -> e instanceof PsiMethodCallExpression && this.isSideEffectFreeBuilderMethodCall((PsiMethodCallExpression)e))) {
                    return;
                }
                this.queried = true;
            }
        }

        private boolean isSideEffectFreeBuilderMethodCall(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return !"getChars".equals(methodExpression.getReferenceName()) && ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), this.variable);
        }

        private static boolean isVariableValueUsed(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)parent;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)parenthesizedExpression);
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)typeCastExpression);
            }
            if (parent instanceof PsiReturnStatement) {
                return true;
            }
            if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiMethodCallExpression) {
                    return true;
                }
            } else {
                if (parent instanceof PsiArrayInitializerExpression) {
                    return true;
                }
                if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    return expression2.equals(rhs);
                }
                if (parent instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)parent;
                    PsiExpression initializer = variable.getInitializer();
                    return expression2.equals(initializer);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderQueryCalledVisitor", "visitElement"));
        }
    }

    private static class StringBuilderUpdateCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> updateNames = ContainerUtil.set((Object[])new String[]{"append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse", "setCharAt", "setLength"});
        private final PsiVariable variable;
        private boolean updated;

        public StringBuilderUpdateCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.updated) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            this.checkReferenceExpression(expression2.getMethodExpression());
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (this.updated) {
                return;
            }
            super.visitMethodReferenceExpression(expression2);
            this.checkReferenceExpression((PsiReferenceExpression)expression2);
        }

        private void checkReferenceExpression(PsiReferenceExpression methodExpression) {
            String name = methodExpression.getReferenceName();
            if (!updateNames.contains(name)) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression2)) {
                this.updated = true;
            }
        }
    }

    private static class MismatchedQueryAndUpdateOfStringBuilderVisitor
    extends BaseInspectionVisitor {
        private MismatchedQueryAndUpdateOfStringBuilderVisitor() {
        }

        public void visitField(PsiField field) {
            boolean updated;
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried((PsiVariable)field, (PsiElement)containingClass);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated((PsiVariable)field, (PsiElement)containingClass)) || UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
                return;
            }
            this.registerFieldError(field, updated, field.getType());
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            boolean updated;
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried((PsiVariable)variable, (PsiElement)codeBlock);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated((PsiVariable)variable, (PsiElement)codeBlock))) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, updated, variable.getType());
        }

        private static boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.AbstractStringBuilder")) {
                return false;
            }
            if (!(PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()) instanceof PsiNewExpression)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean isStringBuilderUpdated(PsiVariable variable, PsiElement context) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !ConstructionUtils.isEmptyStringBuilderInitializer(initializer)) {
                return true;
            }
            StringBuilderUpdateCalledVisitor visitor = new StringBuilderUpdateCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isUpdated();
        }

        private static boolean isStringBuilderQueried(PsiVariable variable, PsiElement context) {
            StringBuilderQueryCalledVisitor visitor = new StringBuilderQueryCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueried();
        }
    }
}

