/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntegerDivisionInFloatingPointContextInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_integralTypes = new HashSet<String>(10);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.display.name", new Object[0]);
        if (string == null) {
            IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("integer.division.in.floating.point.context.problem.descriptor", new Object[0]);
        if (string == null) {
            IntegerDivisionInFloatingPointContextInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerDivisionInFloatingPointContextVisitor();
    }

    static {
        s_integralTypes.add("int");
        s_integralTypes.add("long");
        s_integralTypes.add("short");
        s_integralTypes.add("byte");
        s_integralTypes.add("char");
        s_integralTypes.add("java.lang.Integer");
        s_integralTypes.add("java.lang.Long");
        s_integralTypes.add("java.lang.Short");
        s_integralTypes.add("java.lang.Byte");
        s_integralTypes.add("java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class IntegerDivisionInFloatingPointContextVisitor
    extends BaseInspectionVisitor {
        private IntegerDivisionInFloatingPointContextVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            if (expression2 == null) {
                IntegerDivisionInFloatingPointContextVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIV)) {
                return;
            }
            for (PsiExpression operand2 : expression2.getOperands()) {
                if (IntegerDivisionInFloatingPointContextVisitor.isIntegral(operand2.getType())) continue;
                return;
            }
            PsiExpression context = IntegerDivisionInFloatingPointContextVisitor.getContainingExpression((PsiExpression)expression2);
            if (context == null) {
                return;
            }
            PsiType contextType = ExpectedTypeUtils.findExpectedType(context, true);
            if (contextType == null) {
                return;
            }
            if (!contextType.equals(PsiType.FLOAT) && !contextType.equals(PsiType.DOUBLE)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isIntegral(PsiType type2) {
            if (type2 == null) {
                return false;
            }
            String text2 = type2.getCanonicalText();
            return text2 != null && s_integralTypes.contains(text2);
        }

        private static PsiExpression getContainingExpression(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiBinaryExpression || parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return IntegerDivisionInFloatingPointContextVisitor.getContainingExpression((PsiExpression)parent);
            }
            return expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/IntegerDivisionInFloatingPointContextInspection$IntegerDivisionInFloatingPointContextVisitor", "visitPolyadicExpression"));
        }
    }
}

