/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.DynamicRegexReplaceableByCompiledPatternInspectionBase;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.HighlightUtils;
import org.jetbrains.annotations.NotNull;

public class DynamicRegexReplaceableByCompiledPatternInspection
extends DynamicRegexReplaceableByCompiledPatternInspectionBase {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DynamicRegexReplaceableByCompiledPatternFix();
    }

    private static class DynamicRegexReplaceableByCompiledPatternFix
    extends InspectionGadgetsFix {
        private DynamicRegexReplaceableByCompiledPatternFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.quickfix", new Object[0]);
            if (string == null) {
                DynamicRegexReplaceableByCompiledPatternFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            int i;
            String qualifierText;
            String methodName;
            boolean literalReplacement;
            PsiElement element = descriptor.getPsiElement();
            PsiClass aClass = ClassUtils.getContainingStaticClass(element);
            if (aClass == null) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = methodExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList list = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = list.getExpressions();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder fieldText = new StringBuilder("private static final java.util.regex.Pattern PATTERN = java.util.regex.Pattern.compile(");
            int expressionsLength = expressions2.length;
            if (expressionsLength > 0) {
                fieldText.append(commentTracker.text((PsiElement)expressions2[0]));
            }
            if (literalReplacement = "replace".equals(methodName = methodExpression.getReferenceName())) {
                fieldText.append(", java.util.regex.Pattern.LITERAL");
            }
            fieldText.append(");");
            StringBuilder expressionText = new StringBuilder("PATTERN.");
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String string = qualifierText = qualifier == null ? "this" : commentTracker.text((PsiElement)qualifier);
            if ("split".equals(methodName)) {
                expressionText.append(methodName);
                expressionText.append('(');
                expressionText.append(qualifierText);
                for (i = 1; i < expressionsLength; ++i) {
                    expressionText.append(',').append(commentTracker.text((PsiElement)expressions2[i]));
                }
                expressionText.append(')');
            } else {
                expressionText.append("matcher(").append(qualifierText).append(").");
                if (literalReplacement) {
                    expressionText.append("replaceAll");
                } else {
                    expressionText.append(methodName);
                }
                expressionText.append('(');
                if (literalReplacement) {
                    expressionText.append("java.util.regex.Matcher.quoteReplacement(");
                }
                if (expressionsLength > 1) {
                    expressionText.append(commentTracker.text((PsiElement)expressions2[1]));
                    for (i = 2; i < expressionsLength; ++i) {
                        expressionText.append(',').append(commentTracker.text((PsiElement)expressions2[i]));
                    }
                }
                if (literalReplacement) {
                    expressionText.append(')');
                }
                expressionText.append(')');
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement field = aClass.add((PsiElement)factory.createFieldFromText(fieldText.toString(), element));
            PsiMethodCallExpression newMethodCallExpression = (PsiMethodCallExpression)commentTracker.replaceAndRestoreComments((PsiElement)methodCallExpression, expressionText.toString());
            newMethodCallExpression = (PsiMethodCallExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newMethodCallExpression);
            PsiReferenceExpression reference = DynamicRegexReplaceableByCompiledPatternFix.getReference(newMethodCallExpression);
            HighlightUtils.showRenameTemplate((PsiElement)aClass, (PsiNameIdentifierOwner)field, new PsiReference[]{reference});
        }

        private static PsiReferenceExpression getReference(PsiMethodCallExpression newMethodCallExpression) {
            PsiReferenceExpression methodExpression = newMethodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression2;
                return DynamicRegexReplaceableByCompiledPatternFix.getReference(methodCallExpression);
            }
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            return (PsiReferenceExpression)qualifierExpression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection$DynamicRegexReplaceableByCompiledPatternFix", "getFamilyName"));
        }
    }
}

