/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DynamicRegexReplaceableByCompiledPatternInspectionBase
extends BaseInspection {
    @NonNls
    protected static final Collection<String> regexMethodNames = new HashSet<String>(4);

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.display.name", new Object[0]);
        if (string == null) {
            DynamicRegexReplaceableByCompiledPatternInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.problem.descriptor", new Object[0]);
        if (string == null) {
            DynamicRegexReplaceableByCompiledPatternInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DynamicRegexReplaceableByCompiledPatternVisitor();
    }

    static {
        regexMethodNames.add("matches");
        regexMethodNames.add("replace");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DynamicRegexReplaceableByCompiledPatternVisitor
    extends BaseInspectionVisitor {
        private DynamicRegexReplaceableByCompiledPatternVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!DynamicRegexReplaceableByCompiledPatternVisitor.isCallToRegexMethod(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isCallToRegexMethod(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!regexMethodNames.contains(name)) {
                return false;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return false;
            }
            Object value2 = ExpressionUtils.computeConstantExpression(arguments[0]);
            if (!(value2 instanceof String)) {
                return false;
            }
            String regex = (String)value2;
            if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2) && "split".equals(name) && DynamicRegexReplaceableByCompiledPatternVisitor.isOptimizedPattern(regex) || PsiUtil.isLanguageLevel9OrHigher((PsiElement)expression2) && "replace".equals(name)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return false;
            }
            if (Extensions.getRootArea().hasExtensionPoint(AllowedApiFilterExtension.EP_NAME.getName())) {
                return AllowedApiFilterExtension.isClassAllowed("java.util.regex.Pattern", (PsiElement)expression2);
            }
            return true;
        }

        private static boolean isOptimizedPattern(String regex) {
            char ch;
            return (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
        }
    }
}

