/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ChainedMethodCallInspectionBase
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean m_ignoreThisSuperCalls = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chained.method.call.display.name", new Object[0]);
        if (string == null) {
            ChainedMethodCallInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.method.call.problem.descriptor", new Object[0]);
        if (string == null) {
            ChainedMethodCallInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedMethodCallVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ChainedMethodCallInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ChainedMethodCallVisitor
    extends BaseInspectionVisitor {
        private ChainedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiElement parent;
            PsiExpressionList expressionList;
            PsiElement field;
            if (expression2 == null) {
                ChainedMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression reference = expression2.getMethodExpression();
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!this.isCallExpression(qualifier)) {
                return;
            }
            if (ChainedMethodCallInspectionBase.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            if (ChainedMethodCallInspectionBase.this.m_ignoreThisSuperCalls && (expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class)) != null && ExpressionUtils.isConstructorInvocation(parent = expressionList.getParent())) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private boolean isCallExpression(PsiExpression expression2) {
            return (expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression || expression2 instanceof PsiNewExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ChainedMethodCallInspectionBase$ChainedMethodCallVisitor", "visitMethodCallExpression"));
        }
    }
}

