/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithArraysAsListIntention
extends Intention
implements HighPriorityAction {
    private String replacementText = null;

    @Override
    @NotNull
    public String getText() {
        String string = IntentionPowerPackBundle.message("replace.with.arrays.as.list.intention.name", this.replacementText);
        if (string == null) {
            ReplaceWithArraysAsListIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = e -> {
            if (!(e instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)e;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals("java.util.Collections")) {
                return false;
            }
            String name = method.getName();
            this.replacementText = ReplaceWithArraysAsListIntention.getReplacementMethodText(name, methodCallExpression);
            return this.replacementText != null;
        };
        if (psiElementPredicate == null) {
            ReplaceWithArraysAsListIntention.$$$reportNull$$$0(1);
        }
        return psiElementPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ReplaceWithArraysAsListIntention.$$$reportNull$$$0(2);
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiReferenceParameterList parameterList = methodExpression.getParameterList();
        CommentTracker commentTracker = new CommentTracker();
        if (parameterList != null) {
            int dotIndex = this.replacementText.lastIndexOf(46) + 1;
            this.replacementText = this.replacementText.substring(0, dotIndex) + commentTracker.text((PsiElement)parameterList) + this.replacementText.substring(dotIndex);
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, this.replacementText + commentTracker.text((PsiElement)argumentList), commentTracker);
    }

    private static String getReplacementMethodText(String methodName, PsiMethodCallExpression context) {
        PsiExpression[] arguments = context.getArgumentList().getExpressions();
        if (methodName.equals("emptyList") && arguments.length == 1 && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)context) && ClassUtils.findClass("com.google.common.collect.ImmutableList", (PsiElement)context) == null) {
            return "java.util.Collections.singletonList";
        }
        if (methodName.equals("emptyList") || methodName.equals("singletonList")) {
            if (Arrays.stream(arguments).noneMatch(e -> ReplaceWithArraysAsListIntention.isPossiblyNull(e))) {
                if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                    return "java.util.List.of";
                }
                if (ClassUtils.findClass("com.google.common.collect.ImmutableList", (PsiElement)context) != null) {
                    return "com.google.common.collect.ImmutableList.of";
                }
            }
            return "java.util.Arrays.asList";
        }
        if (methodName.equals("emptySet") || methodName.equals("singleton")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Set.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableSet", (PsiElement)context) != null) {
                return "com.google.common.collect.ImmutableSet.of";
            }
        } else if (methodName.equals("emptyMap") || methodName.equals("singletonMap")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Map.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableMap", (PsiElement)context) != null) {
                return "com.google.common.collect.ImmutableMap.of";
            }
        }
        return null;
    }

    private static boolean isPossiblyNull(PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiModifierListOwner) {
                PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
                return NullableNotNullManager.getInstance((Project)expression2.getProject()).isNullable(modifierListOwner, false);
            }
        } else {
            if (ExpressionUtils.isNullLiteral(expression2)) {
                return true;
            }
            if (expression2 instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
                return ReplaceWithArraysAsListIntention.isPossiblyNull(conditionalExpression.getThenExpression()) || ReplaceWithArraysAsListIntention.isPossiblyNull(conditionalExpression.getElseExpression());
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/collections/ReplaceWithArraysAsListIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/collections/ReplaceWithArraysAsListIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

