/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.GroovyRtConstants;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.groovy.CompilingGroovycRunner;
import org.jetbrains.jps.incremental.groovy.DefaultOutputConsumer;
import org.jetbrains.jps.incremental.groovy.GreclipseBuilder;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.incremental.java.ClassPostProcessor;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public class GroovyBuilder
extends ModuleLevelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.GroovyBuilder");
    static final Key<Map<String, String>> STUB_TO_SRC = Key.create((String)"STUB_TO_SRC");
    private static final Key<Boolean> FILES_MARKED_DIRTY_FOR_NEXT_ROUND = Key.create((String)"SRC_MARKED_DIRTY");
    private static final String GROOVY_EXTENSION = "groovy";
    private final JpsGroovycRunner<JavaSourceRootDescriptor, ModuleBuildTarget> myHelper;
    private final boolean myForStubs;
    private final String myBuilderName;

    public GroovyBuilder(boolean forStubs) {
        super(forStubs ? BuilderCategory.SOURCE_GENERATOR : BuilderCategory.OVERWRITING_TRANSLATOR);
        this.myForStubs = forStubs;
        this.myBuilderName = "Groovy " + (forStubs ? "stub generator" : "compiler");
        this.myHelper = new CompilingGroovycRunner(forStubs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException {
        if (GreclipseBuilder.useGreclipse(context)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        try {
            ModuleLevelBuilder.ExitCode code = this.myHelper.doBuild(context, chunk, dirtyFilesHolder, (Builder)this, new DefaultOutputConsumer(outputConsumer));
            if ((code == ModuleLevelBuilder.ExitCode.OK || code == ModuleLevelBuilder.ExitCode.NOTHING_DONE) && this.hasFilesToCompileForNextRound(context)) {
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
                return exitCode;
            }
            ModuleLevelBuilder.ExitCode exitCode = code;
            return exitCode;
        }
        finally {
            if (!this.myForStubs) {
                FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, null);
            }
        }
    }

    private boolean hasFilesToCompileForNextRound(CompileContext context) {
        return !this.myForStubs && (Boolean)FILES_MARKED_DIRTY_FOR_NEXT_ROUND.get((UserDataHolder)context, (Object)Boolean.FALSE) != false;
    }

    public void buildStarted(CompileContext context) {
        File stubRoot;
        if (this.myForStubs && (stubRoot = GroovyBuilder.getStubRoot(context)).exists() && !FileUtil.deleteWithRenaming((File)stubRoot)) {
            context.processMessage((BuildMessage)new CompilerMessage(this.myBuilderName, BuildMessage.Kind.ERROR, "External build cannot clean " + stubRoot.getPath()));
        }
    }

    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        JavaBuilderUtil.cleanupChunkResources((CompileContext)context);
        JpsGroovycRunner.clearContinuation(context, chunk);
        STUB_TO_SRC.set((UserDataHolder)context, null);
    }

    static File getStubRoot(CompileContext context) {
        return new File(context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot(), "groovyStubs");
    }

    @Nullable
    static Map<ModuleBuildTarget, String> getCanonicalModuleOutputs(CompileContext context, ModuleChunk chunk, Builder builder) {
        LinkedHashMap<ModuleBuildTarget, String> finalOutputs = new LinkedHashMap<ModuleBuildTarget, String>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File moduleOutputDir = target.getOutputDir();
            if (moduleOutputDir == null) {
                context.processMessage((BuildMessage)new CompilerMessage(builder.getPresentableName(), BuildMessage.Kind.ERROR, "Output directory not specified for module " + target.getModule().getName()));
                return null;
            }
            moduleOutputDir.mkdirs();
            String moduleOutputPath = FileUtil.toCanonicalPath((String)moduleOutputDir.getPath());
            assert (moduleOutputPath != null);
            finalOutputs.put(target, moduleOutputPath.endsWith("/") ? moduleOutputPath : moduleOutputPath + "/");
        }
        return finalOutputs;
    }

    static JpsSdk<JpsDummyElement> getJdk(ModuleChunk chunk) {
        return ((JpsModule)chunk.getModules().iterator().next()).getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
    }

    static List<String> getGroovyRtRoots() {
        File rt = ClasspathBootstrap.getResourceFile(GroovyBuilder.class);
        File constants = ClasspathBootstrap.getResourceFile(GroovyRtConstants.class);
        return Arrays.asList(new File(rt.getParentFile(), rt.isFile() ? "groovy_rt.jar" : "intellij.groovy.rt").getPath(), new File(constants.getParentFile(), constants.isFile() ? "groovy-rt-constants.jar" : "intellij.groovy.constants.rt").getPath());
    }

    public static boolean isGroovyFile(String path) {
        return path.endsWith(".groovy");
    }

    public List<String> getCompilableFileExtensions() {
        return Collections.singletonList(GROOVY_EXTENSION);
    }

    public String toString() {
        return this.myBuilderName;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myBuilderName;
        if (string == null) {
            GroovyBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        JavaBuilder.registerClassPostProcessor((ClassPostProcessor)new RecompileStubSources());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyBuilder", "getPresentableName"));
    }

    private static class RecompileStubSources
    implements ClassPostProcessor {
        private RecompileStubSources() {
        }

        public void process(CompileContext context, OutputFileObject out) {
            Map stubToSrc = (Map)STUB_TO_SRC.get((UserDataHolder)context);
            if (stubToSrc == null) {
                return;
            }
            File src = out.getSourceFile();
            if (src == null) {
                return;
            }
            String groovy = (String)stubToSrc.get(FileUtil.toSystemIndependentName((String)src.getPath()));
            if (groovy == null) {
                return;
            }
            try {
                File groovyFile = new File(groovy);
                if (!FSOperations.isMarkedDirty((CompileContext)context, (CompilationRound)CompilationRound.CURRENT, (File)groovyFile)) {
                    FSOperations.markDirty((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (File)groovyFile);
                    FILES_MARKED_DIRTY_FOR_NEXT_ROUND.set((UserDataHolder)context, (Object)Boolean.TRUE);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

