/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.compiler.rt.ClassDependencyLoader;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JointCompilationClassLoader;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;

class InProcessGroovyc
implements GroovycFlavor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.InProcessGroovyc");
    private static final Pattern GROOVY_ALL_JAR_PATTERN = Pattern.compile("groovy-all(-(.*))?\\.jar");
    private static final Pattern GROOVY_JAR_PATTERN = Pattern.compile("groovy(-(.*))?\\.jar");
    private static final Pattern GROOVY_ECLIPSE_BATCH_PATTERN = Pattern.compile("groovy-eclipse-batch-(.*)\\.jar");
    private static final ThreadPoolExecutor ourExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Groovyc");
    private static SoftReference<Pair<String, ClassLoader>> ourParentLoaderCache;
    private static final UrlClassLoader.CachePool ourLoaderCachePool;
    private final Collection<String> myOutputs;
    private final boolean myHasStubExcludes;

    InProcessGroovyc(Collection<String> outputs, boolean hasStubExcludes) {
        this.myOutputs = outputs;
        this.myHasStubExcludes = hasStubExcludes;
    }

    @Override
    public GroovycContinuation runGroovyc(Collection<String> compilationClassPath, boolean forStubs, JpsGroovySettings settings, File tempFile, GroovycOutputParser parser) throws Exception {
        boolean jointPossible = forStubs && !this.myHasStubExcludes;
        LinkedBlockingQueue<String> mailbox = jointPossible && SystemProperties.getBooleanProperty((String)"groovyc.joint.compilation", (boolean)true) ? new LinkedBlockingQueue<String>() : null;
        JointCompilationClassLoader loader = this.createCompilationClassLoader(compilationClassPath);
        if (loader == null) {
            parser.addCompilerMessage(parser.reportNoGroovy(null));
            return null;
        }
        Future<Void> future = ourExecutor.submit(() -> {
            InProcessGroovyc.runGroovycInThisProcess((ClassLoader)((Object)loader), forStubs, settings, tempFile, parser, mailbox);
            return null;
        });
        if (mailbox == null) {
            future.get();
            return null;
        }
        return InProcessGroovyc.waitForStubGeneration(future, mailbox, parser, loader);
    }

    @Nullable
    private static GroovycContinuation waitForStubGeneration(Future<Void> future, LinkedBlockingQueue<String> mailbox, GroovycOutputParser parser, JointCompilationClassLoader loader) throws InterruptedException {
        String msg;
        do {
            if (future.isDone()) {
                return null;
            }
            msg = mailbox.poll(10L, TimeUnit.MILLISECONDS);
            if (!"Stubs generated".equals(msg)) continue;
            loader.resetCache();
            return InProcessGroovyc.createContinuation(future, mailbox, parser);
        } while (msg == null);
        throw new AssertionError((Object)("Unknown message: " + msg));
    }

    @NotNull
    private static GroovycContinuation createContinuation(final Future<Void> future, final LinkedBlockingQueue<String> mailbox, final GroovycOutputParser parser) {
        GroovycContinuation groovycContinuation = new GroovycContinuation(){

            @Override
            @NotNull
            public GroovycOutputParser continueCompilation() throws Exception {
                parser.onContinuation();
                mailbox.offer("Javac completed");
                future.get();
                GroovycOutputParser groovycOutputParser = parser;
                if (groovycOutputParser == null) {
                    1.$$$reportNull$$$0(0);
                }
                return groovycOutputParser;
            }

            @Override
            public void buildAborted() {
                mailbox.offer("Build aborted");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/InProcessGroovyc$1", "continueCompilation"));
            }
        };
        if (groovycContinuation == null) {
            InProcessGroovyc.$$$reportNull$$$0(0);
        }
        return groovycContinuation;
    }

    private static void runGroovycInThisProcess(ClassLoader loader, boolean forStubs, JpsGroovySettings settings, File tempFile, GroovycOutputParser parser, @Nullable Queue mailbox) throws Exception {
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        System.setOut(InProcessGroovyc.createStream(parser, ProcessOutputTypes.STDOUT, oldOut));
        System.setErr(InProcessGroovyc.createStream(parser, ProcessOutputTypes.STDERR, oldErr));
        Thread.currentThread().setContextClassLoader(loader);
        try {
            Class<?> runnerClass = loader.loadClass("org.jetbrains.groovy.compiler.rt.GroovycRunner");
            Method intMain = runnerClass.getDeclaredMethod("intMain2", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Queue.class);
            Integer exitCode = (Integer)intMain.invoke(null, settings.invokeDynamic, false, forStubs, tempFile.getPath(), settings.configScript, mailbox);
            parser.notifyFinished(exitCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            System.out.flush();
            System.err.flush();
            System.setOut(oldOut);
            System.setErr(oldErr);
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Nullable
    private JointCompilationClassLoader createCompilationClassLoader(Collection<String> compilationClassPath) throws Exception {
        ClassLoader groovyClassLoader;
        ClassLoader parent = InProcessGroovyc.obtainParentLoader(compilationClassPath);
        try {
            ClassLoader auxiliary = parent != null ? parent : this.buildCompilationClassLoader(compilationClassPath, null).get();
            Class<?> gcl = auxiliary.loadClass("groovy.lang.GroovyClassLoader");
            groovyClassLoader = (ClassLoader)gcl.getConstructor(ClassLoader.class).newInstance(parent != null ? parent : ClassLoaderUtil.getPlatformLoaderParentIfOnJdk9());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return new JointCompilationClassLoader(this.buildCompilationClassLoader(compilationClassPath, groovyClassLoader));
    }

    private UrlClassLoader.Builder buildCompilationClassLoader(Collection<String> compilationClassPath, ClassLoader parent) throws MalformedURLException {
        return UrlClassLoader.build().urls(InProcessGroovyc.toUrls(compilationClassPath)).parent(parent).allowLock().useCache(ourLoaderCachePool, new UrlClassLoader.CachingCondition(){

            public boolean shouldCacheData(@NotNull URL url) {
                if (url == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    String file = FileUtil.toCanonicalPath((String)new File(url.toURI()).getPath());
                    for (String output : InProcessGroovyc.this.myOutputs) {
                        if (!FileUtil.startsWith((String)output, (String)file)) continue;
                        return false;
                    }
                    return true;
                }
                catch (URISyntaxException e) {
                    LOG.info((Throwable)e);
                    return false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/incremental/groovy/InProcessGroovyc$2", "shouldCacheData"));
            }
        });
    }

    @Nullable
    private static ClassLoader obtainParentLoader(Collection<String> compilationClassPath) throws MalformedURLException {
        if (!SystemInfo.IS_AT_LEAST_JAVA9 && !"true".equals(System.getProperty("groovyc.reuse.compiler.classes", "true"))) {
            return null;
        }
        List groovyJars = ContainerUtil.findAll(compilationClassPath, s -> {
            String fileName = StringUtil.getShortName((String)s, (char)'/');
            return GROOVY_ALL_JAR_PATTERN.matcher(fileName).matches() || GROOVY_JAR_PATTERN.matcher(fileName).matches();
        });
        ContainerUtil.retainAll((Collection)groovyJars, s -> !GROOVY_ECLIPSE_BATCH_PATTERN.matcher(StringUtil.getShortName((String)s, (char)'/')).matches());
        LOG.debug("Groovy jars: " + groovyJars);
        if (groovyJars.size() != 1 || !GROOVY_ALL_JAR_PATTERN.matcher(StringUtil.getShortName((String)((String)groovyJars.get(0)), (char)'/')).matches()) {
            return null;
        }
        String groovyAll = (String)groovyJars.get(0);
        Pair pair = (Pair)SoftReference.dereference(ourParentLoaderCache);
        if (pair != null && ((String)pair.first).equals(groovyAll)) {
            return (ClassLoader)pair.second;
        }
        final ClassDependencyLoader checkWellFormed = new ClassDependencyLoader(){

            protected void loadClassDependencies(Class aClass) throws ClassNotFoundException {
                if (!this.isCompilerCoreClass(aClass.getName()) || !(aClass.getClassLoader() instanceof UrlClassLoader)) {
                    super.loadClassDependencies(aClass);
                }
            }

            private boolean isCompilerCoreClass(String name) {
                if (name.startsWith("groovyjarjar")) {
                    return true;
                }
                if (name.startsWith("org.codehaus.groovy.")) {
                    String tail = name.substring("org.codehaus.groovy.".length());
                    if (tail.startsWith("ast") || tail.startsWith("classgen") || tail.startsWith("tools.javac") || tail.startsWith("antlr") || tail.startsWith("vmplugin") || tail.startsWith("reflection") || tail.startsWith("control")) {
                        return true;
                    }
                    if (tail.startsWith("runtime") && name.contains("GroovyMethods")) {
                        return true;
                    }
                }
                return false;
            }
        };
        UrlClassLoader.Builder builder = UrlClassLoader.build();
        builder.urls(InProcessGroovyc.toUrls(ContainerUtil.concat(GroovyBuilder.getGroovyRtRoots(), Collections.singletonList(groovyAll))));
        builder.allowLock();
        builder.useCache(ourLoaderCachePool, new UrlClassLoader.CachingCondition(){

            public boolean shouldCacheData(@NotNull URL url) {
                if (url == null) {
                    4.$$$reportNull$$$0(0);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/jps/incremental/groovy/InProcessGroovyc$4", "shouldCacheData"));
            }
        });
        ClassLoaderUtil.addPlatformLoaderParentIfOnJdk9((UrlClassLoader.Builder)builder);
        UrlClassLoader groovyAllLoader = builder.get();
        URLClassLoader wrapper = new URLClassLoader(new URL[0], (ClassLoader)groovyAllLoader){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith("groovy.grape.")) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return checkWellFormed.loadDependencies(super.loadClass(name, resolve));
                }
                catch (NoClassDefFoundError e) {
                    throw new ClassNotFoundException(name, e);
                }
            }
        };
        ourParentLoaderCache = new SoftReference((Object)Pair.create((Object)groovyAll, (Object)wrapper));
        return wrapper;
    }

    @NotNull
    private static List<URL> toUrls(Collection<String> paths) throws MalformedURLException {
        ArrayList urls = ContainerUtil.newArrayList();
        for (String s : paths) {
            urls.add(new File(s).toURI().toURL());
        }
        ArrayList arrayList = urls;
        if (arrayList == null) {
            InProcessGroovyc.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static PrintStream createStream(final GroovycOutputParser parser, final Key type, final PrintStream overridden) {
        final Thread thread = Thread.currentThread();
        PrintStream printStream = new PrintStream(new OutputStream(){
            ByteArrayOutputStream line = new ByteArrayOutputStream();
            boolean hasLineSeparator = false;

            @Override
            public void write(int b) throws IOException {
                if (Thread.currentThread() != thread) {
                    overridden.write(b);
                    return;
                }
                if (this.hasLineSeparator && !this.isLineSeparator(b)) {
                    this.flush();
                } else {
                    this.hasLineSeparator |= this.isLineSeparator(b);
                }
                this.line.write(b);
            }

            private boolean isLineSeparator(int b) {
                return b == 10 || b == 13;
            }

            @Override
            public void flush() throws IOException {
                if (Thread.currentThread() != thread) {
                    overridden.flush();
                    return;
                }
                if (this.line.size() > 0) {
                    parser.notifyTextAvailable(StringUtil.convertLineSeparators((String)this.line.toString()), type);
                    this.line = new ByteArrayOutputStream();
                    this.hasLineSeparator = false;
                }
            }
        });
        if (printStream == null) {
            InProcessGroovyc.$$$reportNull$$$0(2);
        }
        return printStream;
    }

    static {
        ourLoaderCachePool = UrlClassLoader.createCachePool();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/incremental/groovy/InProcessGroovyc";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createContinuation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrls";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStream";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

