/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryStatsTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.google.protobuf3jarjar.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MemoryDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private MemoryProfiler.AllocationsInfo myPendingAllocationSample = null;
    private MemoryProfiler.HeapDumpInfo myPendingHeapDumpSample = null;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryStatsTable myMemoryStatsTable;
    private int myProcessId = -1;
    private final Common.Session mySession;
    private final Consumer<Runnable> myFetchExecutor;

    public MemoryDataPoller(int processId, Common.Session session, MemoryStatsTable statsTable, MemoryServiceGrpc.MemoryServiceBlockingStub pollingService, Consumer<Runnable> fetchExecutor) {
        super(POLLING_DELAY_NS);
        this.myProcessId = processId;
        this.mySession = session;
        this.myMemoryStatsTable = statsTable;
        this.myPollingService = pollingService;
        this.myFetchExecutor = fetchExecutor;
    }

    @Override
    public void stop() {
        if (this.myPendingHeapDumpSample != null) {
            this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.myProcessId, this.mySession, this.myPendingHeapDumpSample.toBuilder().setEndTime(this.myPendingHeapDumpSample.getStartTime() + 1L).build());
            this.myMemoryStatsTable.insertHeapDumpData(this.myProcessId, this.mySession, this.myPendingHeapDumpSample.getStartTime(), MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN, ByteString.EMPTY);
            this.myPendingHeapDumpSample = null;
        }
        if (this.myPendingAllocationSample != null && this.myPendingAllocationSample.getLegacy()) {
            this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.myProcessId, this.mySession, this.myPendingAllocationSample.toBuilder().setEndTime(this.myPendingAllocationSample.getStartTime() + 1L).setStatus(MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN).build());
        }
        super.stop();
    }

    @Override
    public void poll() {
        if (this.myProcessId == -1) {
            return;
        }
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setProcessId(this.myProcessId).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getData(dataRequestBuilder.build());
        this.myMemoryStatsTable.insertMemory(this.myProcessId, this.mySession, response.getMemSamplesList());
        this.myMemoryStatsTable.insertAllocStats(this.myProcessId, this.mySession, response.getAllocStatsSamplesList());
        this.myMemoryStatsTable.insertGcStats(this.myProcessId, this.mySession, response.getGcStatsSamplesList());
        ArrayList<MemoryProfiler.AllocationsInfo> allocDumpsToFetch = new ArrayList<MemoryProfiler.AllocationsInfo>();
        for (int i = 0; i < response.getAllocationsInfoCount(); ++i) {
            MemoryProfiler.AllocationsInfo info;
            if (this.myPendingAllocationSample != null) {
                assert (i == 0);
                info = response.getAllocationsInfo(i);
                assert (this.myPendingAllocationSample.getStartTime() == info.getStartTime());
                if (info.getEndTime() == Long.MAX_VALUE) break;
                this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.myProcessId, this.mySession, info);
                allocDumpsToFetch.add(info);
                this.myPendingAllocationSample = null;
                continue;
            }
            info = response.getAllocationsInfo(i);
            this.myMemoryStatsTable.insertOrReplaceAllocationsInfo(this.myProcessId, this.mySession, info);
            if (info.getEndTime() == Long.MAX_VALUE) {
                assert (i == response.getAllocationsInfoCount() - 1);
                this.myPendingAllocationSample = info;
                continue;
            }
            allocDumpsToFetch.add(info);
        }
        ArrayList<MemoryProfiler.HeapDumpInfo> heapDumpsToFetch = new ArrayList<MemoryProfiler.HeapDumpInfo>();
        for (int i = 0; i < response.getHeapDumpInfosCount(); ++i) {
            MemoryProfiler.HeapDumpInfo info;
            if (this.myPendingHeapDumpSample != null) {
                assert (i == 0);
                info = response.getHeapDumpInfos(i);
                assert (this.myPendingHeapDumpSample.getStartTime() == info.getStartTime());
                if (info.getEndTime() == Long.MAX_VALUE) break;
                this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.myProcessId, this.mySession, info);
                heapDumpsToFetch.add(info);
                this.myPendingHeapDumpSample = null;
                continue;
            }
            info = response.getHeapDumpInfos(i);
            this.myMemoryStatsTable.insertOrReplaceHeapInfo(this.myProcessId, this.mySession, info);
            if (info.getEndTime() == Long.MAX_VALUE) {
                assert (i == response.getHeapDumpInfosCount() - 1);
                this.myPendingHeapDumpSample = info;
                continue;
            }
            heapDumpsToFetch.add(info);
        }
        this.fetchLegacyAllocData(allocDumpsToFetch.stream().filter(MemoryProfiler.AllocationsInfo::getLegacy).collect(Collectors.toList()));
        this.fetchHeapDumpData(heapDumpsToFetch);
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }

    private void fetchLegacyAllocData(@NotNull List<MemoryProfiler.AllocationsInfo> dumpsToFetch) {
        if (dumpsToFetch == null) {
            MemoryDataPoller.$$$reportNull$$$0(0);
        }
        if (dumpsToFetch.isEmpty()) {
            return;
        }
        Runnable query = () -> {
            if (dumpsToFetch == null) {
                MemoryDataPoller.$$$reportNull$$$0(3);
            }
            HashSet classesToFetch = new HashSet();
            HashSet stacksToFetch = new HashSet();
            HashMap<Long, MemoryProfiler.LegacyAllocationEventsResponse> eventsToSave = new HashMap<Long, MemoryProfiler.LegacyAllocationEventsResponse>();
            for (MemoryProfiler.AllocationsInfo sample : dumpsToFetch) {
                MemoryProfiler.LegacyAllocationEventsResponse allocEventsResponse = this.myPollingService.getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest.newBuilder().setProcessId(this.myProcessId).setStartTime(sample.getStartTime()).setEndTime(sample.getEndTime()).build());
                eventsToSave.put(sample.getStartTime(), allocEventsResponse);
                allocEventsResponse.getEventsList().forEach(event -> {
                    classesToFetch.add(event.getClassId());
                    stacksToFetch.add(event.getStackId());
                });
                MemoryProfiler.DumpDataResponse allocDumpResponse = this.myPollingService.getLegacyAllocationDump(MemoryProfiler.DumpDataRequest.newBuilder().setProcessId(this.myProcessId).setDumpTime(sample.getStartTime()).build());
                this.myMemoryStatsTable.updateLegacyAllocationDump(this.myProcessId, this.mySession, sample.getStartTime(), allocDumpResponse.getData().toByteArray());
            }
            MemoryProfiler.LegacyAllocationContextsRequest contextRequest = MemoryProfiler.LegacyAllocationContextsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).addAllClassIds(classesToFetch).addAllStackIds(stacksToFetch).build();
            MemoryProfiler.AllocationContextsResponse contextsResponse = this.myPollingService.getLegacyAllocationContexts(contextRequest);
            this.myMemoryStatsTable.insertLegacyAllocationContext(this.myProcessId, this.mySession, contextsResponse.getAllocatedClassesList(), contextsResponse.getAllocationStacksList());
            eventsToSave.forEach((startTime, response) -> this.myMemoryStatsTable.updateLegacyAllocationEvents(this.myProcessId, this.mySession, (long)startTime, (MemoryProfiler.LegacyAllocationEventsResponse)response));
        };
        this.myFetchExecutor.accept(query);
    }

    private void fetchHeapDumpData(@NotNull List<MemoryProfiler.HeapDumpInfo> dumpsToFetch) {
        if (dumpsToFetch == null) {
            MemoryDataPoller.$$$reportNull$$$0(1);
        }
        if (dumpsToFetch.isEmpty()) {
            return;
        }
        Runnable query = () -> {
            if (dumpsToFetch == null) {
                MemoryDataPoller.$$$reportNull$$$0(2);
            }
            for (MemoryProfiler.HeapDumpInfo sample : dumpsToFetch) {
                MemoryProfiler.DumpDataResponse dumpDataResponse = this.myPollingService.getHeapDump(MemoryProfiler.DumpDataRequest.newBuilder().setProcessId(this.myProcessId).setDumpTime(sample.getStartTime()).build());
                this.myMemoryStatsTable.insertHeapDumpData(this.myProcessId, this.mySession, sample.getStartTime(), dumpDataResponse.getStatus(), dumpDataResponse.getData());
            }
        };
        this.myFetchExecutor.accept(query);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dumpsToFetch";
        objectArray2[1] = "com/android/tools/datastore/poller/MemoryDataPoller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchLegacyAllocData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchHeapDumpData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fetchHeapDumpData$3";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$fetchLegacyAllocData$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

