/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.database.MemoryStatsTable;
import com.android.tools.datastore.poller.MemoryDataPoller;
import com.android.tools.datastore.poller.MemoryJvmtiDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.google.protobuf3jarjar.ByteString;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryService
extends MemoryServiceGrpc.MemoryServiceImplBase
implements ServicePassThrough {
    private static final DataStoreService.BackingNamespace LIVE_ALLOCATION_NAMESPACE = new DataStoreService.BackingNamespace("LiveAllocations", DataStoreDatabase.Characteristic.PERFORMANT);
    private final Map<Integer, PollRunner> myRunners;
    private final Map<Integer, PollRunner> myJvmtiRunners;
    private final MemoryStatsTable myStatsTable;
    private final MemoryLiveAllocationTable myAllocationsTable;
    private final Consumer<Runnable> myFetchExecutor;
    private final DataStoreService myService;

    public MemoryService(@NotNull DataStoreService dataStoreService, Consumer<Runnable> fetchExecutor, @NotNull Map<Common.Session, Long> sessionIdLookup) {
        if (dataStoreService == null) {
            MemoryService.$$$reportNull$$$0(0);
        }
        if (sessionIdLookup == null) {
            MemoryService.$$$reportNull$$$0(1);
        }
        this.myRunners = new HashMap<Integer, PollRunner>();
        this.myJvmtiRunners = new HashMap<Integer, PollRunner>();
        this.myFetchExecutor = fetchExecutor;
        this.myService = dataStoreService;
        this.myStatsTable = new MemoryStatsTable(sessionIdLookup);
        this.myAllocationsTable = new MemoryLiveAllocationTable(sessionIdLookup);
    }

    public void startMonitoringApp(MemoryProfiler.MemoryStartRequest request, StreamObserver<MemoryProfiler.MemoryStartResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.startMonitoringApp(request));
            observer.onCompleted();
            int processId = request.getProcessId();
            Common.Session session = request.getSession();
            this.myJvmtiRunners.put(processId, new MemoryJvmtiDataPoller(processId, session, this.myAllocationsTable, client));
            this.myRunners.put(processId, new MemoryDataPoller(processId, session, this.myStatsTable, client, this.myFetchExecutor));
            this.myFetchExecutor.accept(this.myJvmtiRunners.get(processId));
            this.myFetchExecutor.accept(this.myRunners.get(processId));
        } else {
            observer.onNext((Object)MemoryProfiler.MemoryStartResponse.getDefaultInstance());
            observer.onCompleted();
        }
    }

    public void stopMonitoringApp(MemoryProfiler.MemoryStopRequest request, StreamObserver<MemoryProfiler.MemoryStopResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub service;
        int processId = request.getProcessId();
        PollRunner runner = this.myRunners.remove(processId);
        if (runner != null) {
            runner.stop();
        }
        if ((runner = this.myJvmtiRunners.remove(processId)) != null) {
            runner.stop();
        }
        if ((service = this.myService.getMemoryClient(request.getSession())) == null) {
            observer.onNext((Object)MemoryProfiler.MemoryStopResponse.getDefaultInstance());
        } else {
            observer.onNext((Object)service.stopMonitoringApp(request));
        }
        observer.onCompleted();
    }

    public void triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest request, StreamObserver<MemoryProfiler.TriggerHeapDumpResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        MemoryProfiler.TriggerHeapDumpResponse response = MemoryProfiler.TriggerHeapDumpResponse.getDefaultInstance();
        if (client != null && (response = client.triggerHeapDump(request)).getStatus() == MemoryProfiler.TriggerHeapDumpResponse.Status.SUCCESS) {
            assert (response.getInfo() != null);
            this.myStatsTable.insertOrReplaceHeapInfo(request.getProcessId(), request.getSession(), response.getInfo());
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getHeapDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.DumpDataResponse.Status status = this.myStatsTable.getHeapDumpStatus(request.getProcessId(), request.getSession(), request.getDumpTime());
        switch (status) {
            case SUCCESS: {
                byte[] data = this.myStatsTable.getHeapDumpData(request.getProcessId(), request.getSession(), request.getDumpTime());
                assert (data != null);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
                responseBuilder.setStatus(status);
                break;
            }
            case NOT_READY: 
            case FAILURE_UNKNOWN: 
            case NOT_FOUND: {
                responseBuilder.setStatus(status);
                break;
            }
            default: {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
            }
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void listHeapDumpInfos(MemoryProfiler.ListDumpInfosRequest request, StreamObserver<MemoryProfiler.ListHeapDumpInfosResponse> responseObserver) {
        MemoryProfiler.ListHeapDumpInfosResponse.Builder responseBuilder = MemoryProfiler.ListHeapDumpInfosResponse.newBuilder();
        List<MemoryProfiler.HeapDumpInfo> dump = this.myStatsTable.getHeapDumpInfoByRequest(request.getProcessId(), request.getSession(), request);
        responseBuilder.addAllInfos(dump);
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void trackAllocations(MemoryProfiler.TrackAllocationsRequest request, StreamObserver<MemoryProfiler.TrackAllocationsResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        MemoryProfiler.TrackAllocationsResponse response = MemoryProfiler.TrackAllocationsResponse.getDefaultInstance();
        if (client != null) {
            response = client.trackAllocations(request);
            if (request.getEnabled() && response.getStatus() == MemoryProfiler.TrackAllocationsResponse.Status.SUCCESS) {
                assert (response.getInfo() != null);
                this.myStatsTable.insertOrReplaceAllocationsInfo(request.getProcessId(), request.getSession(), response.getInfo());
            }
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void suspendTrackAllocations(MemoryProfiler.SuspendTrackAllocationsRequest request, StreamObserver<MemoryProfiler.SuspendTrackAllocationsResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        MemoryProfiler.SuspendTrackAllocationsResponse response = MemoryProfiler.SuspendTrackAllocationsResponse.getDefaultInstance();
        if (client != null) {
            response = client.suspendTrackAllocations(request);
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void resumeTrackAllocations(MemoryProfiler.ResumeTrackAllocationsRequest request, StreamObserver<MemoryProfiler.ResumeTrackAllocationsResponse> responseObserver) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        MemoryProfiler.ResumeTrackAllocationsResponse response = MemoryProfiler.ResumeTrackAllocationsResponse.getDefaultInstance();
        if (client != null) {
            response = client.resumeTrackAllocations(request);
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationContexts(MemoryProfiler.LegacyAllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        responseObserver.onNext((Object)this.myStatsTable.getLegacyAllocationContexts(request));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationDump(MemoryProfiler.DumpDataRequest request, StreamObserver<MemoryProfiler.DumpDataResponse> responseObserver) {
        MemoryProfiler.DumpDataResponse.Builder responseBuilder = MemoryProfiler.DumpDataResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getProcessId(), request.getSession(), request.getDumpTime());
        if (response == null) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            byte[] data = this.myStatsTable.getLegacyAllocationDumpData(request.getProcessId(), request.getSession(), request.getDumpTime());
            if (data == null) {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.NOT_READY);
            } else {
                responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.SUCCESS);
                responseBuilder.setData(ByteString.copyFrom((byte[])data));
            }
        } else {
            responseBuilder.setStatus(MemoryProfiler.DumpDataResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    public void getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest request, StreamObserver<MemoryProfiler.StackFrameInfoResponse> responseObserver) {
        responseObserver.onNext((Object)this.myAllocationsTable.getStackFrameInfo(request.getProcessId(), request.getSession(), request.getMethodId()));
        responseObserver.onCompleted();
    }

    public void getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest request, StreamObserver<MemoryProfiler.LegacyAllocationEventsResponse> responseObserver) {
        MemoryProfiler.LegacyAllocationEventsResponse.Builder builder = MemoryProfiler.LegacyAllocationEventsResponse.newBuilder();
        MemoryProfiler.AllocationsInfo response = this.myStatsTable.getAllocationsInfo(request.getProcessId(), request.getSession(), request.getStartTime());
        if (response == null) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_FOUND);
        } else if (response.getStatus() == MemoryProfiler.AllocationsInfo.Status.FAILURE_UNKNOWN) {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        } else if (response.getLegacy()) {
            MemoryProfiler.LegacyAllocationEventsResponse events = this.myStatsTable.getLegacyAllocationData(request.getProcessId(), request.getSession(), request.getStartTime());
            if (events == null) {
                builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY);
            } else {
                builder.mergeFrom(events);
            }
        } else {
            builder.setStatus(MemoryProfiler.LegacyAllocationEventsResponse.Status.FAILURE_UNKNOWN);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver) {
        MemoryProfiler.MemoryData response = this.myStatsTable.getData(request);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocations(MemoryProfiler.AllocationSnapshotRequest request, StreamObserver<MemoryProfiler.BatchAllocationSample> responseObserver) {
        MemoryProfiler.BatchAllocationSample response = this.myAllocationsTable.getAllocations(request.getProcessId(), request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getAllocationContexts(MemoryProfiler.AllocationContextsRequest request, StreamObserver<MemoryProfiler.AllocationContextsResponse> responseObserver) {
        MemoryProfiler.AllocationContextsResponse response = this.myAllocationsTable.getAllocationContexts(request.getProcessId(), request.getSession(), request.getStartTime(), request.getEndTime());
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest request, StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse> observer) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = this.myService.getMemoryClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.forceGarbageCollection(request));
        } else {
            observer.onNext((Object)MemoryProfiler.ForceGarbageCollectionResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Arrays.asList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE, LIVE_ALLOCATION_NAMESPACE);
        if (list == null) {
            MemoryService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            MemoryService.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            MemoryService.$$$reportNull$$$0(4);
        }
        assert (this.getBackingNamespaces().contains(namespace));
        if (namespace.equals(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE)) {
            this.myStatsTable.initialize(connection);
        } else {
            this.myAllocationsTable.initialize(connection);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionIdLookup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/MemoryService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/MemoryService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

