/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.art;

import com.android.tools.perflib.vmtrace.TraceAction;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.MethodModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class CaptureNodeConstructor {
    private final MethodModel myTopLevelMethodModel;
    private final List<CaptureNode> myTopLevelNodes = new ArrayList<CaptureNode>();
    @Nullable
    private CaptureNode myCurrentNode;
    private CaptureNode myTopLevelNode;

    CaptureNodeConstructor(MethodModel methodModel) {
        this.myTopLevelMethodModel = methodModel;
    }

    void addTraceAction(MethodModel methodModel, TraceAction action, int threadTime, int globalTime) {
        if (action == TraceAction.METHOD_ENTER) {
            this.enterMethod(methodModel, threadTime, globalTime);
        } else {
            this.exitMethod(methodModel, threadTime, globalTime);
        }
    }

    private void enterMethod(MethodModel methodModel, int threadTime, int globalTime) {
        CaptureNode node = new CaptureNode();
        node.setStartGlobal(globalTime);
        node.setStartThread(threadTime);
        node.setMethodModel(methodModel);
        if (this.myCurrentNode == null) {
            this.myTopLevelNodes.add(node);
        } else {
            this.myCurrentNode.addChild(node);
        }
        this.myCurrentNode = node;
    }

    private void exitMethod(MethodModel methodModel, long threadTime, long globalTime) {
        if (this.myCurrentNode != null) {
            assert (this.myCurrentNode.getMethodModel() != null);
            if (this.myCurrentNode.getMethodModel() != methodModel) {
                String msg = String.format("Error during call stack reconstruction. Attempt to exit from method %s while in method %s", this.myCurrentNode.getMethodModel().getId(), methodModel.getId());
                throw new RuntimeException(msg);
            }
            this.myCurrentNode.setEndGlobal(globalTime);
            this.myCurrentNode.setEndThread(threadTime);
            this.myCurrentNode = this.myCurrentNode.getParent();
        } else {
            CaptureNode node = new CaptureNode();
            node.setMethodModel(methodModel);
            for (CaptureNode topLevel : this.myTopLevelNodes) {
                node.addChild(topLevel);
            }
            this.myTopLevelNodes.clear();
            this.myTopLevelNodes.add(node);
            node.setEndGlobal(globalTime);
            node.setEndThread(threadTime);
            long entryThreadTime = threadTime - 1L;
            long entryGlobalTime = globalTime - 1L;
            if (node.getChildCount() > 0) {
                CaptureNode first = node.getFirstChild();
                assert (first != null);
                entryThreadTime = Math.max(first.getStartThread() - 1L, 0L);
                entryGlobalTime = Math.max(first.getStartGlobal() - 1L, 0L);
            }
            node.setStartGlobal(entryGlobalTime);
            node.setStartThread(entryThreadTime);
        }
    }

    private void exitMethod(MethodModel methodModel, long entryThreadTime, long entryGlobalTime, @Nullable List<CaptureNode> children) {
        long lastExitGlobalTime;
        long lastExitThreadTime;
        if (children == null || children.isEmpty()) {
            lastExitThreadTime = entryThreadTime + 1L;
            lastExitGlobalTime = entryGlobalTime + 1L;
        } else {
            CaptureNode last = children.get(children.size() - 1);
            lastExitThreadTime = last.getEndThread() + 1L;
            lastExitGlobalTime = last.getEndGlobal() + 1L;
        }
        this.exitMethod(methodModel, lastExitThreadTime, lastExitGlobalTime);
    }

    private void fixUpCallStacks() {
        if (this.myTopLevelNode != null) {
            return;
        }
        while (this.myCurrentNode != null) {
            this.exitMethod(this.myCurrentNode.getMethodModel(), this.myCurrentNode.getStartThread(), this.myCurrentNode.getStartGlobal(), this.myCurrentNode.getChildren());
        }
        this.exitMethod(this.myTopLevelMethodModel, 0L, 0L, this.myTopLevelNodes);
        assert (this.myTopLevelNodes.size() == 1);
        this.myTopLevelNode = this.myTopLevelNodes.get(0);
    }

    public CaptureNode getTopLevel() {
        this.fixUpCallStacks();
        return this.myTopLevelNode;
    }
}

