/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.ActivityAction;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.event.EventMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EventMonitorTooltipView
extends ProfilerTooltipView {
    private JLabel myTimeRange;
    private final EventMonitor myMonitor;

    public EventMonitorTooltipView(StudioMonitorStageView parent, EventMonitor monitor) {
        super(monitor.getTimeline(), monitor.getName());
        this.myMonitor = monitor;
        monitor.getProfilers().getTimeline().getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::dataRangeChanged);
    }

    @Override
    protected void timeChanged() {
        this.updateTimelineText();
    }

    private void updateTimelineText() {
        ProfilerTimeline timeline = this.myMonitor.getProfilers().getTimeline();
        Range dataRange = timeline.getDataRange();
        Range range = timeline.getTooltipRange();
        if (!range.isEmpty()) {
            ActivityAction activity = this.getActivityAt(range.getMin());
            if (activity != null) {
                double endTime = activity.getEndUs() == 0L ? dataRange.getMax() : (double)activity.getEndUs();
                String time = TimeAxisFormatter.DEFAULT.getFormattedString(dataRange.getLength(), endTime - (double)activity.getStartUs(), true);
                this.setTimelineText(timeline.getDataRange(), activity, endTime);
                this.myLabel.setText(activity.getData() + " " + time);
            } else {
                super.timeChanged();
                this.myTimeRange.setText("");
            }
        } else {
            this.myLabel.setText("");
        }
    }

    protected void dataRangeChanged() {
        this.updateTimelineText();
    }

    private void setTimelineText(Range dataRange, ActivityAction activity, double endTime) {
        String startTime = TimeAxisFormatter.DEFAULT.getFormattedString(dataRange.getLength(), (double)activity.getStartUs() - dataRange.getMin(), true);
        String endTimeString = TimeAxisFormatter.DEFAULT.getFormattedString(dataRange.getLength(), endTime - dataRange.getMin(), true);
        this.myTimeRange.setText(String.format("%s - %s", startTime, endTimeString));
    }

    private ActivityAction getActivityAt(double time) {
        List activitySeries = this.myMonitor.getActivityEvents().getRangedSeries().getSeries();
        for (SeriesData series : activitySeries) {
            if (!((double)((EventAction)series.value).getStartUs() <= time) || !((double)((EventAction)series.value).getEndUs() > time) && ((EventAction)series.value).getEndUs() != 0L) continue;
            return (ActivityAction)series.value;
        }
        return null;
    }

    @Override
    public Component createTooltip() {
        TabularLayout grid = new TabularLayout("*", "*");
        this.myTimeRange = new JLabel();
        this.myTimeRange.setForeground(Color.GRAY);
        JPanel panel = new JPanel(new BorderLayout());
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.myTimeRange.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        panel.add((Component)this.myTimeRange, "North");
        panel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        return panel;
    }
}

