/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.RelativeTimeConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationsInstanceObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LegacyAllocationCaptureObject
implements CaptureObject {
    static final int DEFAULT_HEAP_ID = 0;
    static final String DEFAULT_HEAP_NAME = "default";
    static final long DEFAULT_CLASSLOADER_ID = -1L;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final String myLabel;
    private final int myProcessId;
    private final Common.Session mySession;
    private long myStartTimeNs;
    private long myEndTimeNs;
    private final FeatureTracker myFeatureTracker;
    private volatile boolean myIsDoneLoading;
    private volatile boolean myIsLoadingError;
    private final HeapSet myFakeHeapSet;

    public LegacyAllocationCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @Nullable Common.Session session, int processId, @NotNull MemoryProfiler.AllocationsInfo info, @NotNull RelativeTimeConverter converter, @NotNull FeatureTracker featureTracker) {
        if (client == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(0);
        }
        if (info == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(1);
        }
        if (converter == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(2);
        }
        if (featureTracker == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(3);
        }
        this.myIsDoneLoading = false;
        this.myIsLoadingError = false;
        this.myClient = client;
        this.myClassDb = new ClassDb();
        this.myProcessId = processId;
        this.mySession = session;
        this.myStartTimeNs = info.getStartTime();
        this.myEndTimeNs = info.getEndTime();
        this.myFakeHeapSet = new HeapSet(this, DEFAULT_HEAP_NAME, 0);
        this.myLabel = "Allocations" + (this.myStartTimeNs != Long.MAX_VALUE ? " from " + TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(converter.convertToRelativeTime(this.myStartTimeNs))) : "") + (this.myEndTimeNs != Long.MIN_VALUE ? " to " + TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(converter.convertToRelativeTime(this.myEndTimeNs))) : "");
        this.myFeatureTracker = featureTracker;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myLabel;
        if (string == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "alloc";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        MemoryProfiler.DumpDataResponse response;
        if (outputStream == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(5);
        }
        if ((response = this.myClient.getLegacyAllocationDump(MemoryProfiler.DumpDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setDumpTime(this.myStartTimeNs).build())).getStatus() != MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            throw new IOException("Could not retrieve allocation dump.");
        }
        response.getData().writeTo(outputStream);
        this.myFeatureTracker.trackExportAllocation();
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        Stream<InstanceObject> stream = this.myFakeHeapSet.getInstancesStream();
        if (stream == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        MemoryProfiler.LegacyAllocationEventsResponse response;
        while ((response = this.myClient.getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(this.myStartTimeNs).setEndTime(this.myEndTimeNs).build())).getStatus() != MemoryProfiler.LegacyAllocationEventsResponse.Status.SUCCESS) {
            if (response.getStatus() == MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.myIsLoadingError = true;
                    return false;
                }
            }
            this.myIsLoadingError = true;
            return false;
        }
        MemoryProfiler.LegacyAllocationContextsRequest contextRequest = MemoryProfiler.LegacyAllocationContextsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).addAllStackIds((Iterable)response.getEventsList().stream().map(MemoryProfiler.LegacyAllocationEvent::getStackId).collect(Collectors.toSet())).addAllClassIds((Iterable)response.getEventsList().stream().map(MemoryProfiler.LegacyAllocationEvent::getClassId).collect(Collectors.toSet())).build();
        MemoryProfiler.AllocationContextsResponse contextsResponse = this.myClient.getLegacyAllocationContexts(contextRequest);
        HashMap classEntryMap = new HashMap();
        HashMap callStacks = new HashMap();
        contextsResponse.getAllocatedClassesList().forEach(className -> classEntryMap.put(className.getClassId(), this.myClassDb.registerClass(-1L, className.getClassName())));
        contextsResponse.getAllocationStacksList().forEach(callStack -> callStacks.putIfAbsent(callStack.getStackId(), callStack));
        for (MemoryProfiler.LegacyAllocationEvent event : response.getEventsList()) {
            assert (classEntryMap.containsKey(event.getClassId()));
            assert (callStacks.containsKey(event.getStackId()));
            this.myFakeHeapSet.addInstanceObject(new LegacyAllocationsInstanceObject(event, (ClassDb.ClassEntry)classEntryMap.get(event.getClassId()), (MemoryProfiler.AllocationStack)callStacks.get(event.getStackId())));
        }
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        List<CaptureObject.ClassifierAttribute> list = Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOC_COUNT, CaptureObject.ClassifierAttribute.SHALLOW_SIZE);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        List<CaptureObject.InstanceAttribute> list = Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.SHALLOW_SIZE);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        List<HeapSet> list = Collections.singletonList(this.myFakeHeapSet);
        if (list == null) {
            LegacyAllocationCaptureObject.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myFakeHeapSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/LegacyAllocationCaptureObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/LegacyAllocationCaptureObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassifierAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeapSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

