/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackFrameParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpData {
    private static final Map<String, String> CONTENT_EXTENSIONS_MAP = new ImmutableMap.Builder().put((Object)"/bmp", (Object)".bmp").put((Object)"/gif", (Object)".gif").put((Object)"/html", (Object)".html").put((Object)"/jpeg", (Object)".jpg").put((Object)"/json", (Object)".json").put((Object)"/png", (Object)".png").put((Object)"/xml", (Object)".xml").build();
    private static final String STATUS_CODE_NAME = "response-status-code";
    public static final String FIELD_CONTENT_TYPE = "content-type";
    public static final String FIELD_CONTENT_LENGTH = "content-length";
    public static final int NO_STATUS_CODE = -1;
    private final long myId;
    private final long myStartTimeUs;
    private final long myEndTimeUs;
    private final long myDownloadingTimeUs;
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myMethod;
    @NotNull
    private final StackTrace myTrace;
    @NotNull
    private final List<JavaThread> myThreads;
    @Nullable
    private final String myResponsePayloadId;
    private int myStatusCode;
    private final Map<String, String> myResponseFields;
    private final Map<String, String> myRequestFields;
    private File myResponsePayloadFile;

    private HttpData(@NotNull Builder builder) {
        if (builder == null) {
            HttpData.$$$reportNull$$$0(0);
        }
        this.myStatusCode = -1;
        this.myResponseFields = new HashMap<String, String>();
        this.myRequestFields = new HashMap<String, String>();
        this.myId = builder.myId;
        this.myStartTimeUs = builder.myStartTimeUs;
        this.myEndTimeUs = builder.myEndTimeUs;
        this.myDownloadingTimeUs = builder.myDownloadingTimeUs;
        this.myUrl = builder.myUrl;
        this.myMethod = builder.myMethod;
        this.myTrace = new StackTrace(builder.myTrace);
        this.myThreads = builder.myThreads;
        this.myResponsePayloadId = builder.myResponsePayloadId;
        if (builder.myResponseFields != null) {
            this.parseResponseFields(builder.myResponseFields);
        }
        if (builder.myRequestFields != null) {
            this.parseRequestFields(builder.myRequestFields);
        }
    }

    public long getId() {
        return this.myId;
    }

    public long getStartTimeUs() {
        return this.myStartTimeUs;
    }

    public long getEndTimeUs() {
        return this.myEndTimeUs;
    }

    public long getDownloadingTimeUs() {
        return this.myDownloadingTimeUs;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            HttpData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getMethod() {
        String string = this.myMethod;
        if (string == null) {
            HttpData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public StackTrace getStackTrace() {
        StackTrace stackTrace = this.myTrace;
        if (stackTrace == null) {
            HttpData.$$$reportNull$$$0(3);
        }
        return stackTrace;
    }

    @NotNull
    public List<JavaThread> getJavaThreads() {
        List<JavaThread> list = this.myThreads;
        if (list == null) {
            HttpData.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String getResponsePayloadId() {
        return this.myResponsePayloadId;
    }

    public int getStatusCode() {
        return this.myStatusCode;
    }

    @Nullable
    public File getResponsePayloadFile() {
        return this.myResponsePayloadFile;
    }

    public void setResponsePayloadFile(@NotNull File payloadFile) {
        if (payloadFile == null) {
            HttpData.$$$reportNull$$$0(5);
        }
        this.myResponsePayloadFile = payloadFile;
    }

    @Nullable
    public String getResponseField(@NotNull String field) {
        if (field == null) {
            HttpData.$$$reportNull$$$0(6);
        }
        return this.myResponseFields.get(field.toLowerCase());
    }

    @Nullable
    public ContentType getContentType() {
        String type = this.getResponseField(FIELD_CONTENT_TYPE);
        return type == null ? null : new ContentType(type);
    }

    @NotNull
    public ImmutableMap<String, String> getResponseHeaders() {
        ImmutableMap immutableMap = ImmutableMap.copyOf(this.myResponseFields);
        if (immutableMap == null) {
            HttpData.$$$reportNull$$$0(7);
        }
        return immutableMap;
    }

    @NotNull
    public ImmutableMap<String, String> getRequestHeaders() {
        ImmutableMap immutableMap = ImmutableMap.copyOf(this.myRequestFields);
        if (immutableMap == null) {
            HttpData.$$$reportNull$$$0(8);
        }
        return immutableMap;
    }

    private void parseResponseFields(@NotNull String fields) {
        String[] tokens;
        if (fields == null) {
            HttpData.$$$reportNull$$$0(9);
        }
        if ((fields = fields.trim()).isEmpty()) {
            return;
        }
        String[] firstLineSplit = fields.split("\\n", 2);
        String status = firstLineSplit[0].trim();
        if (!status.isEmpty() && (status = (tokens = status.split("=", 2))[tokens.length - 1].trim()).startsWith("HTTP/1.")) {
            this.myStatusCode = Integer.parseInt(status.split(" ")[1]);
            fields = firstLineSplit.length > 1 ? firstLineSplit[1] : "";
        }
        HttpData.parseHeaderFields(fields, this.myResponseFields);
        if (this.myResponseFields.containsKey(STATUS_CODE_NAME)) {
            String statusCode = this.myResponseFields.remove(STATUS_CODE_NAME);
            this.myStatusCode = Integer.parseInt(statusCode);
        }
        assert (this.myStatusCode != -1) : String.format("Unexpected http response (%s)", fields);
    }

    private void parseRequestFields(@NotNull String fields) {
        if (fields == null) {
            HttpData.$$$reportNull$$$0(10);
        }
        HttpData.parseHeaderFields(fields, this.myRequestFields);
    }

    private static void parseHeaderFields(@NotNull String fields, @NotNull Map<String, String> map) {
        if (fields == null) {
            HttpData.$$$reportNull$$$0(11);
        }
        if (map == null) {
            HttpData.$$$reportNull$$$0(12);
        }
        map.clear();
        Arrays.stream(fields.split("\\n")).filter(line -> !line.trim().isEmpty()).forEach(line -> {
            if (map == null) {
                HttpData.$$$reportNull$$$0(16);
            }
            String[] keyAndValue = line.split("=", 2);
            assert (keyAndValue.length == 2) : String.format("Unexpected http header field (%s)", line);
            map.put(keyAndValue[0].trim().toLowerCase(), StringUtil.trimEnd((String)keyAndValue[1].trim(), (char)';'));
        });
    }

    @NotNull
    public static String getUrlName(@NotNull String url) {
        URI uri;
        if (url == null) {
            HttpData.$$$reportNull$$$0(13);
        }
        if ((uri = URI.create(url)).getPath().isEmpty()) {
            String string = uri.getHost();
            if (string == null) {
                HttpData.$$$reportNull$$$0(14);
            }
            return string;
        }
        String name = StringUtil.trimTrailing((String)uri.getPath(), (char)'/');
        String string = name = name.lastIndexOf(47) != -1 ? name.substring(name.lastIndexOf(47) + 1) : name;
        if (uri.getQuery() != null) {
            name = name + "?" + uri.getQuery();
        }
        try {
            String lastName;
            do {
                lastName = name;
            } while (!(name = URLDecoder.decode(name, "UTF-8")).equals(lastName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = name;
        if (string2 == null) {
            HttpData.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpData data = (HttpData)o;
        return this.myId == data.myId;
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/HttpData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payloadFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/HttpData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaThreads";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseHeaders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestHeaders";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setResponsePayloadFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResponseField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseResponseFields";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseRequestFields";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseHeaderFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUrlName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$parseHeaderFields$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private final long myId;
        private final long myStartTimeUs;
        private final long myEndTimeUs;
        private final long myDownloadingTimeUs;
        private String myUrl;
        private String myMethod;
        private String myResponseFields;
        private String myRequestFields;
        private String myResponsePayloadId;
        private String myTrace = "";
        private List<JavaThread> myThreads = new ArrayList<JavaThread>();

        public Builder(long id, long startTimeUs, long endTimeUs, long downloadingTimeUS) {
            this.myId = id;
            this.myStartTimeUs = startTimeUs;
            this.myEndTimeUs = endTimeUs;
            this.myDownloadingTimeUs = downloadingTimeUS;
        }

        @NotNull
        public Builder setUrl(@NotNull String url) {
            if (url == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myUrl = url;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setMethod(@NotNull String method) {
            if (method == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myMethod = method;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setTrace(@NotNull String trace) {
            if (trace == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myTrace = trace;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder addJavaThread(@NotNull JavaThread thread) {
            if (thread == null) {
                Builder.$$$reportNull$$$0(6);
            }
            if (!this.myThreads.stream().anyMatch(t -> {
                if (thread == null) {
                    Builder.$$$reportNull$$$0(15);
                }
                return t.getId() == thread.getId();
            })) {
                this.myThreads.add(thread);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder setResponseFields(@NotNull String responseFields) {
            if (responseFields == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myResponseFields = responseFields;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder;
        }

        @NotNull
        public Builder setResponsePayloadId(@NotNull String payloadId) {
            if (payloadId == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myResponsePayloadId = payloadId;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder setRequestFields(@NotNull String requestFields) {
            if (requestFields == null) {
                Builder.$$$reportNull$$$0(12);
            }
            this.myRequestFields = requestFields;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public HttpData build() {
            HttpData httpData = new HttpData(this);
            if (httpData == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return httpData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/HttpData$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 6: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "responseFields";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "payloadId";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestFields";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/HttpData$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTrace";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addJavaThread";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setResponseFields";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setResponsePayloadId";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRequestFields";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setUrl";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setMethod";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTrace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addJavaThread";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setResponseFields";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setResponsePayloadId";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setRequestFields";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addJavaThread$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class JavaThread {
        private final long myId;
        @NotNull
        private final String myName;

        /*
         * WARNING - void declaration
         */
        public JavaThread(long id, @NotNull String string) {
            void name;
            if (string == null) {
                JavaThread.$$$reportNull$$$0(0);
            }
            this.myId = id;
            this.myName = name;
        }

        public long getId() {
            return this.myId;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                JavaThread.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/HttpData$JavaThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/HttpData$JavaThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ContentType {
        @NotNull
        private final String myContentType;

        public ContentType(@NotNull String contentType) {
            if (contentType == null) {
                ContentType.$$$reportNull$$$0(0);
            }
            this.myContentType = contentType;
        }

        @NotNull
        public String getMimeType() {
            String string = this.myContentType.split(";")[0];
            if (string == null) {
                ContentType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String guessFileExtension() {
            for (Map.Entry entry : CONTENT_EXTENSIONS_MAP.entrySet()) {
                if (!this.myContentType.contains((CharSequence)entry.getKey())) continue;
                return (String)entry.getValue();
            }
            return null;
        }

        @NotNull
        public String getContentType() {
            String string = this.myContentType;
            if (string == null) {
                ContentType.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.getContentType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/HttpData$ContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/HttpData$ContentType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMimeType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class StackTrace {
        private final ImmutableList<CodeLocation> myLocations;
        private final String myTrace;

        private StackTrace(@NotNull String trace) {
            if (trace == null) {
                StackTrace.$$$reportNull$$$0(0);
            }
            this.myTrace = trace;
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (String line : trace.split("\\n")) {
                if (line.trim().isEmpty()) continue;
                builder.add((Object)new StackFrameParser(line).toCodeLocation());
            }
            this.myLocations = builder.build();
        }

        @NotNull
        public ImmutableList<CodeLocation> getCodeLocations() {
            ImmutableList<CodeLocation> immutableList = this.myLocations;
            if (immutableList == null) {
                StackTrace.$$$reportNull$$$0(1);
            }
            return immutableList;
        }

        @VisibleForTesting
        @NotNull
        public String getTrace() {
            String string = this.myTrace;
            if (string == null) {
                StackTrace.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/HttpData$StackTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/HttpData$StackTrace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeLocations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

