/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR45Util {
    private static final String FILE_SECTION = "*F\n";
    private static final String LINE_SECTION = "*L\n";
    private static final String END_SECTION = "*E";

    public static FileMapData[] extractLineMapping(String debug, String className) {
        if (debug.startsWith("SMAP")) {
            TIntObjectHashMap linesMap = new TIntObjectHashMap();
            debug = debug.substring(4);
            int fileSectionIdx = debug.indexOf(FILE_SECTION);
            int lineInfoIdx = debug.indexOf(LINE_SECTION);
            TIntObjectHashMap<String> fileNames = JSR45Util.parseFileNames(debug.substring(fileSectionIdx + FILE_SECTION.length(), lineInfoIdx), className);
            String lineInfo = debug.substring(lineInfoIdx + LINE_SECTION.length(), debug.indexOf(END_SECTION));
            String[] lines = lineInfo.split("\n");
            int fileId = 1;
            for (String line : lines) {
                int startOutLine;
                int startSrcLine;
                int repeat = 1;
                int outLineInc = 1;
                int idx = line.indexOf(":");
                String srcLine = line.substring(0, idx);
                String outLine = line.substring(idx + 1);
                int srcCommaIdx = srcLine.indexOf(44);
                int sharpIdx = srcLine.indexOf("#");
                if (sharpIdx > -1) {
                    startSrcLine = Integer.parseInt(srcLine.substring(0, sharpIdx));
                    if (srcCommaIdx > -1) {
                        repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1, srcCommaIdx));
                    } else {
                        fileId = Integer.parseInt(srcLine.substring(sharpIdx + 1));
                    }
                } else if (srcCommaIdx > -1) {
                    repeat = Integer.parseInt(srcLine.substring(srcCommaIdx + 1));
                    startSrcLine = Integer.parseInt(srcLine.substring(0, srcCommaIdx));
                } else {
                    startSrcLine = Integer.parseInt(srcLine);
                }
                int outCommaIdx = outLine.indexOf(44);
                if (outCommaIdx > -1) {
                    outLineInc = Integer.parseInt(outLine.substring(outCommaIdx + 1));
                    startOutLine = Integer.parseInt(outLine.substring(0, outCommaIdx));
                } else {
                    startOutLine = Integer.parseInt(outLine);
                }
                THashSet currentFile = (THashSet)linesMap.get(fileId);
                if (currentFile == null) {
                    currentFile = new THashSet();
                    linesMap.put(fileId, (Object)currentFile);
                }
                for (int r = 0; r < repeat; ++r) {
                    currentFile.add((Object)new LineMapData(startSrcLine + r, startOutLine + r * outLineInc, startOutLine + (r + 1) * outLineInc - 1));
                }
            }
            ArrayList<FileMapData> result = new ArrayList<FileMapData>();
            int[] keys = linesMap.keys();
            Arrays.sort(keys);
            for (int key : keys) {
                result.add(new FileMapData((String)fileNames.get(key), JSR45Util.getLinesMapping((THashSet<LineMapData>)((THashSet)linesMap.get(key)))));
            }
            return result.toArray(FileMapData.EMPTY_FILE_MAP);
        }
        return null;
    }

    private static TIntObjectHashMap<String> parseFileNames(String fileSection, String className) {
        if ((fileSection = fileSection.trim()).endsWith("\n")) {
            fileSection = fileSection.substring(0, fileSection.length() - 1);
        }
        final String defaultPrefix = JSR45Util.getClassPackageName(className);
        String[] fileNameIdx = fileSection.split("\n");
        TIntObjectHashMap result = new TIntObjectHashMap();
        boolean generatedPrefix = true;
        for (int i = 0; i < fileNameIdx.length; ++i) {
            String fileName;
            String idAndName = fileName = fileNameIdx[i];
            String path = null;
            if (fileName.startsWith("+ ")) {
                idAndName = fileName.substring(2);
                path = fileNameIdx[++i];
            }
            int idx = idAndName.indexOf(" ");
            int key = Integer.parseInt(idAndName.substring(0, idx));
            String currentClassName = idAndName.substring(idx + 1);
            path = path == null ? currentClassName : JSR45Util.processRelative(path);
            int lastDot = path.lastIndexOf(".");
            String fileNameWithDots = lastDot < 0 ? path : path.substring(0, lastDot) + "_" + path.substring(lastDot + 1);
            fileNameWithDots = fileNameWithDots.replace('/', '.');
            generatedPrefix &= !fileNameWithDots.startsWith(defaultPrefix);
            currentClassName = fileNameWithDots;
            result.put(key, (Object)currentClassName);
        }
        if (generatedPrefix) {
            result.transformValues((TObjectFunction)new TObjectFunction<String, String>(){

                public String execute(String selfValue) {
                    return defaultPrefix + selfValue;
                }
            });
        }
        return result;
    }

    public static String processRelative(String fileName) {
        int idx;
        while ((idx = fileName.indexOf("..")) > -1) {
            String rest = fileName.substring(idx + "..".length());
            String start = fileName.substring(0, idx);
            if (!start.endsWith("/")) {
                return fileName;
            }
            int endIndex = (start = start.substring(0, start.length() - 1)).lastIndexOf(47);
            if (endIndex > -1) {
                fileName = start.substring(0, endIndex) + rest;
                continue;
            }
            fileName = rest.startsWith("/") ? rest.substring(1) : rest;
        }
        return fileName;
    }

    private static String getClassPackageName(String className) {
        String generatePrefix = "";
        int fqnLastDotIdx = className.lastIndexOf(".");
        if (fqnLastDotIdx > -1) {
            generatePrefix = className.substring(0, fqnLastDotIdx + 1);
        }
        return generatePrefix;
    }

    private static LineMapData[] getLinesMapping(THashSet<LineMapData> linesMap) {
        int max = 0;
        for (LineMapData aLinesMap1 : linesMap) {
            LineMapData lmd = aLinesMap1;
            if (max >= lmd.getSourceLineNumber()) continue;
            max = lmd.getSourceLineNumber();
        }
        LineMapData[] result = new LineMapData[max + 1];
        Iterator i$ = linesMap.iterator();
        while (i$.hasNext()) {
            LineMapData aLinesMap;
            LineMapData lmd;
            result[lmd.getSourceLineNumber()] = lmd = (aLinesMap = (LineMapData)i$.next());
        }
        return result;
    }
}

