/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.editor

import com.intellij.openapi.actionSystem.ActionGroup
import com.intellij.openapi.actionSystem.DefaultActionGroup

/** Action groups for the DesignSurface. */
interface EditorActionsToolbarActionGroups {

  val zoomControlsGroup: ActionGroup?
    get() = null

  val zoomLabelGroup: ActionGroup?
    get() = null

  val otherGroups: List<ActionGroup>
    get() = listOf()
}

/** The default implementation for [EditorActionsToolbarActionGroups], only returns [DefaultActionGroup.EMPTY_GROUP]. */
object DesignSurfaceEmptyActionGroups: EditorActionsToolbarActionGroups {
  override val zoomControlsGroup: ActionGroup
    get() = DefaultActionGroup.EMPTY_GROUP

  override val zoomLabelGroup: ActionGroup
    get() = DefaultActionGroup.EMPTY_GROUP
}