/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs.graph;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;

public class ExceptionHandlingBlock {

  @NotNull
  public PsiType[] getHandlerTypes() {
    return PsiType.EMPTY_ARRAY;
  }

  @Nullable
  public MethodGraph getExceptionHandler(PsiType exceptionType) {
    return null;
  }

  @Nullable
  public MethodGraph getFinallyBlock() {
    return null;
  }
}
