/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import org.jetbrains.annotations.NotNull;

/**
 * Displays the "Default Project Structure" dialog.
 */
public class AndroidTemplateProjectStructureAction extends DumbAwareAction {
  public AndroidTemplateProjectStructureAction() {
    this("Project Structure");
  }

  public AndroidTemplateProjectStructureAction(@NotNull String text) {
    super(text, null, AllIcons.General.ProjectStructure);
  }

  @Override
  public void actionPerformed(@NotNull final AnActionEvent e) {
    Project project = ProjectManagerEx.getInstanceEx().getDefaultProject();
    ProjectStructureConfigurable.getInstance(project).show();
  }
}
