/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.regex.Pattern;

interface MessageFormatter {
  Pattern PROCESS_ID = Pattern.compile("\\d+");
  Pattern THREAD_ID = Pattern.compile("\\d+");
  Pattern PACKAGE = Pattern.compile("\\S+");
  Pattern PRIORITY = Pattern.compile("[VDIWEAF]");
  Pattern TAG = Pattern.compile("[^ ]+");
  Pattern MESSAGE = Pattern.compile(".*");

  @NotNull
  String format(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message);

  @Nullable
  LogCatMessage tryParse(@NotNull String message);
}
