/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.naveditor.actions

import com.android.tools.idea.common.model.NlComponent
import com.android.tools.idea.naveditor.model.isActivity
import com.android.tools.idea.naveditor.model.isStartDestination
import com.android.tools.idea.naveditor.model.setAsStartDestination
import com.intellij.openapi.actionSystem.AnAction
import com.intellij.openapi.actionSystem.AnActionEvent
import com.intellij.openapi.command.WriteCommandAction

class StartDestinationAction(private val component: NlComponent) : AnAction("Set as Start Destination") {
  init {
    templatePresentation.isEnabled = isEnabled
  }

  override fun actionPerformed(e: AnActionEvent) {
    WriteCommandAction.runWriteCommandAction(component.model.project) {
      component.setAsStartDestination()
    }
  }

  override fun update(e: AnActionEvent) {
    super.update(e)
    e.presentation.isEnabled = isEnabled
  }

  private val isEnabled
    get() = !component.id.isNullOrEmpty() && !component.isActivity && !component.isStartDestination
}