/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.npw.module

import com.android.tools.idea.npw.model.ProjectSyncInvoker
import com.android.tools.idea.wizard.model.SkippableWizardStep
import com.intellij.openapi.project.Project
import java.io.File
import javax.swing.Icon

interface ModuleGalleryEntry {
  // TODO(qumeric): remove it
  /**
   * The file from where this template was loaded.
   */
  val templateFile: File? get() = null
  /**
   * Icon to be used in the gallery.
   */
  val icon: Icon?
  /**
   * Module template name.
   */
  val name: String
  /**
   * Description of the template or `null` if none.
   */
  val description: String?

  /**
   * Returns a new instance of a wizard step that will allow the user to edit the details of this module entry
   */
  fun createStep(project: Project, projectSyncInvoker: ProjectSyncInvoker, moduleParent: String?): SkippableWizardStep<*>
}