/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.npw.module.recipes.pureLibrary

import com.android.SdkConstants.FN_BUILD_GRADLE
import com.android.SdkConstants.LIBS_FOLDER
import com.android.tools.idea.npw.module.recipes.addKotlinDependencies
import com.android.tools.idea.npw.module.recipes.gitignore
import com.android.tools.idea.npw.module.recipes.pureLibrary.src.placeholderJava
import com.android.tools.idea.npw.module.recipes.pureLibrary.src.placeholderKt
import com.android.tools.idea.npw.module.recipes.setKotlinVersion
import com.android.tools.idea.wizard.template.Language
import com.android.tools.idea.wizard.template.ModuleTemplateData
import com.android.tools.idea.wizard.template.RecipeExecutor

fun RecipeExecutor.generatePureLibrary(
  moduleData: ModuleTemplateData, className: String
) {
  val (projectData, srcOut) = moduleData
  val moduleOut = moduleData.rootDir
  val language = projectData.language
  val packageName = moduleData.packageName

  addIncludeToSettings(moduleData.name)

  save(buildGradle("JavaVersion.VERSION_1_7"), moduleOut.resolve(FN_BUILD_GRADLE))
  applyPlugin("java-library")
  save(
    if (language == Language.Kotlin) placeholderKt(packageName, className) else placeholderJava(packageName, className),
    srcOut.resolve("$className.${language.extension}")
  )

  save(
    gitignore(),
    moduleOut.resolve(".gitignore")
  )

  if (language == Language.Kotlin) {
    setKotlinVersion(projectData.kotlinVersion)
    addKotlinDependencies(androidX = false)
    applyPlugin("kotlin")
  }

  createDirectory(moduleOut.resolve(LIBS_FOLDER))
}
