/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.observable.core;

import com.android.tools.idea.observable.AbstractProperty;
import org.jetbrains.annotations.NotNull;

/**
 * A boolean-backed {@link AbstractProperty}.
 */
public final class BoolValueProperty extends BoolProperty {

  private Boolean myValue;

  public BoolValueProperty(@NotNull Boolean value) {
    myValue = value;
  }

  public BoolValueProperty() {
    this(false);
  }

  @NotNull
  @Override
  public Boolean get() {
    return myValue;
  }

  @Override
  protected void setDirectly(@NotNull Boolean value) {
    myValue = value;
  }
}
