/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property2.action;

import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property2.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property2.NewCustomAttributePanel;
import com.android.tools.property.panel.api.TableLineModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class AddCustomFieldAction extends AnAction {
  private final MotionLayoutAttributesModel myModel;
  private final MotionSelection mySelection;
  private TableLineModel myLineModel;
  private NewCustomAttributePanel myDialog;

  public AddCustomFieldAction(@NotNull MotionLayoutAttributesModel model, @NotNull MotionSelection selection) {
    super(null, "Add custom attribute", AllIcons.General.Add);
    myModel = model;
    mySelection = selection;
  }

  public void setLineModel(@NotNull TableLineModel lineModel) {
    myLineModel = lineModel;
  }

  @Override
  public void actionPerformed(@NotNull AnActionEvent event) {
    if (myDialog == null || myDialog.isDisposed()) {
      myDialog = new NewCustomAttributePanel(myModel, mySelection, myLineModel);
    }
    myDialog.show();
  }
}
