/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.property.panel.impl.ui

import com.android.tools.adtui.stdui.KeyStrokes
import com.android.tools.adtui.stdui.registerActionKey
import com.intellij.openapi.actionSystem.ActionToolbar
import com.intellij.openapi.actionSystem.AnAction
import com.intellij.openapi.actionSystem.impl.ActionButton

/**
 * An [ActionButton] that is focusable.
 */
class FocusableActionButton(action: AnAction) :
  ActionButton(action, action.templatePresentation, "", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE) {

  init {
    registerActionKey({ click() }, KeyStrokes.ENTER, "enter")
  }

  override fun isFocusable(): Boolean {
    return action.templatePresentation.isEnabled
  }
}
