// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.execution.configurations

import com.intellij.execution.ui.FragmentedSettings
import com.intellij.openapi.components.BaseState
import com.intellij.util.xmlb.annotations.*

@Tag("predefined_log_file")
class PredefinedLogFile() : BaseState() {
  constructor(id: String, isEnabled: Boolean) : this() {
    this.id = id
    this.isEnabled = isEnabled
  }

  @get:Attribute
  var id by string()
  @get:Attribute("enabled")
  var isEnabled by property(false)
}

open class RunConfigurationOptions : BaseState(), FragmentedSettings {
  @Tag("output_file")
  class OutputFileOptions : BaseState() {
    @get:Attribute("path")
    var fileOutputPath by string()
    @get:Attribute("is_save")
    var isSaveOutput by property(false)
  }

  // we use object instead of 2 fields because XML serializer cannot reuse tag for several fields
  @get:Property(surroundWithTag = false)
  var fileOutput by property(OutputFileOptions())

  @get:Property(surroundWithTag = false)
  @get:XCollection
  var predefinedLogFiles by list<PredefinedLogFile>()

  @com.intellij.configurationStore.Property(description = "Show console when a message is printed to standard output stream")
  @get:Attribute("show_console_on_std_out")
  var isShowConsoleOnStdOut by property(false)
  @com.intellij.configurationStore.Property(description = "Show console when a message is printed to standard error stream")
  @get:Attribute("show_console_on_std_err")
  var isShowConsoleOnStdErr by property(false)

  @get:Property(surroundWithTag = false)
  @get:XCollection
  var logFiles by list<LogFileOptions>()

  @com.intellij.configurationStore.Property(description = "Allow parallel run")
  @get:Transient
  var isAllowRunningInParallel by property(false)

  @get:OptionTag(tag = "target", valueAttribute = "name", nameAttribute = "")
  var remoteTarget by string()

  @get:OptionTag(tag = "projectPathOnTarget")
  var projectPathOnTarget by string()

  @get:XCollection(propertyElementName = "selectedOptions")
  override var selectedOptions by list<FragmentedSettings.Option>();
}

open class LocatableRunConfigurationOptions : RunConfigurationOptions() {
  @com.intellij.configurationStore.Property(ignore = true)
  @get:Attribute("nameIsGenerated")
  var isNameGenerated by property(false)
}

open class ModuleBasedConfigurationOptions : LocatableRunConfigurationOptions() {
  @get:OptionTag(tag = "module", valueAttribute = "name", nameAttribute = "")
  var module by string()
}