// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.icons;

import com.intellij.ui.IconManager;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

import org.jetbrains.annotations.ApiStatus.ScheduledForRemoval;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run "Generate icon classes" configuration instead
 */
public class AllIcons {
  private static @NotNull Icon load(@NotNull String path, long cacheKey, int flags) {
    return IconManager.getInstance().loadRasterizedIcon(path, AllIcons.class.getClassLoader(), cacheKey, flags);
  }

  public static final class Actions {
    /** 16x16 */ public static final @NotNull Icon AddFile = load("actions/addFile.svg", 8630828675481524949L, 2);
    /** 16x16 */ public static final @NotNull Icon AddMulticaret = load("actions/AddMulticaret.svg", -1417925245974412498L, 2);
    /** 16x16 */ public static final @NotNull Icon AddToDictionary = load("actions/addToDictionary.svg", 6748693087544996573L, 2);
    /** 16x16 */ public static final @NotNull Icon Annotate = load("actions/annotate.svg", 7018280457980935152L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowCollapse = load("actions/arrowCollapse.svg", 1450072550494927920L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowExpand = load("actions/arrowExpand.svg", 1785300788085612971L, 2);
    /** 16x16 */ public static final @NotNull Icon Back = load("actions/back.svg", -5238722930425998786L, 2);
    /** 16x16 */ public static final @NotNull Icon BuildAutoReloadChanges = load("actions/buildAutoReloadChanges.svg", 1338096814076615262L, 2);
    /** 16x16 */ public static final @NotNull Icon BuildLoadChanges = load("actions/buildLoadChanges.svg", 14591242167310557L, 2);
    /** 16x16 */ public static final @NotNull Icon Cancel = load("actions/cancel.svg", -6341677320965468585L, 2);
    /** 16x16 */ public static final @NotNull Icon ChangeView = load("actions/changeView.svg", -8234939136540527086L, 2);
    /** 12x12 */ public static final @NotNull Icon Checked = load("actions/checked.svg", -3201348830378726323L, 0);
    /** 12x12 */ public static final @NotNull Icon Checked_selected = load("actions/checked_selected.svg", 7511827689082506209L, 0);
    /** 16x16 */ public static final @NotNull Icon CheckMulticaret = load("actions/CheckMulticaret.svg", 3470827709003063235L, 2);
    /** 16x16 */ public static final @NotNull Icon CheckOut = load("actions/checkOut.svg", 1851728405443320099L, 2);
    /** 16x16 */ public static final @NotNull Icon Close = load("actions/close.svg", -1889655828109783727L, 0);
    /** 16x16 */ public static final @NotNull Icon CloseDarkGrey = load("actions/closeDarkGrey.svg", -7122201781693680036L, 2);
    /** 16x16 */ public static final @NotNull Icon CloseHovered = load("actions/closeHovered.svg", 4877286543791366915L, 0);
    /** 16x16 */ public static final @NotNull Icon Collapseall = load("actions/collapseall.svg", -5787123259220462367L, 2);
    /** 16x16 */ public static final @NotNull Icon Colors = load("actions/colors.svg", -526074966926511230L, 2);
    /** 16x16 */ public static final @NotNull Icon Commit = load("actions/commit.svg", -7056817985277432401L, 2);
    /** 16x16 */ public static final @NotNull Icon Compile = load("actions/compile.svg", 5685135305138041666L, 2);
    /** 16x16 */ public static final @NotNull Icon Copy = load("actions/copy.svg", 9161479160758195766L, 2);
    /** 16x16 */ public static final @NotNull Icon DeleteTag = load("actions/deleteTag.svg", -1256130733283195738L, 2);
    /** 16x16 */ public static final @NotNull Icon DeleteTagHover = load("actions/deleteTagHover.svg", 5580544105554597808L, 2);
    /** 16x16 */ public static final @NotNull Icon DiagramDiff = load("actions/diagramDiff.svg", 4050539090745180126L, 2);
    /** 16x16 */ public static final @NotNull Icon Diff = load("actions/diff.svg", -4789806540685383240L, 2);
    /** 16x17 */ public static final @NotNull Icon DiffWithClipboard = load("actions/diffWithClipboard.svg", -4644729761610662766L, 2);
    /** 16x16 */ public static final @NotNull Icon Download = load("actions/download.svg", -5995640021644586396L, 2);
    /** 16x16 */ public static final @NotNull Icon Dump = load("actions/dump.svg", -1999792581111822882L, 2);
    /** 16x16 */ public static final @NotNull Icon DynamicUsages = load("actions/dynamicUsages.svg", -3038340384984333293L, 2);
    /** 16x16 */ public static final @NotNull Icon Edit = load("actions/edit.svg", 6256745109677636307L, 2);
    /** 16x16 */ public static final @NotNull Icon EditScheme = load("actions/editScheme.svg", 2969091749870783802L, 2);
    /** 16x16 */ public static final @NotNull Icon EditSource = load("actions/editSource.svg", 561957038266216006L, 2);
    /** 16x16 */ public static final @NotNull Icon Execute = load("actions/execute.svg", -8483270745489547280L, 2);
    /** 16x16 */ public static final @NotNull Icon Exit = load("actions/exit.svg", -4438554714897420340L, 2);
    /** 16x16 */ public static final @NotNull Icon Expandall = load("actions/expandall.svg", 3067494853883564797L, 2);
    /** 16x16 */ public static final @NotNull Icon Find = load("actions/find.svg", -7573679044876289097L, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowNextMatches = load("actions/findAndShowNextMatches.svg", -6460677671288297186L, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowNextMatchesSmall = load("actions/findAndShowNextMatchesSmall.svg", 1804414385884557970L, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowPrevMatches = load("actions/findAndShowPrevMatches.svg", 8184601017969148538L, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowPrevMatchesSmall = load("actions/findAndShowPrevMatchesSmall.svg", 5743186222727265453L, 2);
    /** 16x16 */ public static final @NotNull Icon FindBackward = load("actions/findBackward.svg", 2254712483132528509L, 2);
    /** 16x16 */ public static final @NotNull Icon FindEntireFile = load("actions/findEntireFile.svg", -3295298973304529539L, 2);
    /** 16x16 */ public static final @NotNull Icon FindForward = load("actions/findForward.svg", -5056220172504342825L, 2);
    /** 16x16 */ public static final @NotNull Icon ForceRefresh = load("actions/forceRefresh.svg", -4820043730813305509L, 2);
    /** 16x16 */ public static final @NotNull Icon Forward = load("actions/forward.svg", -6911971082377513030L, 2);
    /** 16x16 */ public static final @NotNull Icon GC = load("actions/gc.svg", -8575168390950363090L, 2);
    /** 16x16 */ public static final @NotNull Icon GeneratedFolder = load("actions/generatedFolder.svg", 3275380518479818409L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupBy = load("actions/groupBy.svg", -211287332248382369L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByClass = load("actions/GroupByClass.svg", -6060827396505222324L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByFile = load("actions/GroupByFile.svg", -3508076526395798427L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByMethod = load("actions/groupByMethod.svg", -3589344609093081399L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByModule = load("actions/GroupByModule.svg", -6835289273583562755L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByModuleGroup = load("actions/GroupByModuleGroup.svg", -6316352951740106067L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByPackage = load("actions/GroupByPackage.svg", 9020853646753863582L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByPrefix = load("actions/GroupByPrefix.svg", 2388965546570220180L, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByTestProduction = load("actions/groupByTestProduction.svg", 2369076600408557383L, 2);
    /** 16x16 */ public static final @NotNull Icon Help = load("actions/help.svg", -6313728113390275714L, 2);
    /** 16x16 */ public static final @NotNull Icon Highlighting = load("actions/highlighting.svg", 7696578575386178796L, 2);
    /** 9x5 */ public static final @NotNull Icon InlayDropTriangle = load("actions/inlayDropTriangle.svg", -7545613337505264334L, 0);
    /** 12x12 */ public static final @NotNull Icon InlayGear = load("actions/inlayGear.svg", 1977227583093877761L, 0);
    /** 12x12 */ public static final @NotNull Icon InlayGlobe = load("actions/inlayGlobe.svg", 1996305597754741974L, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInComments = load("actions/inlayRenameInComments.svg", -4518704000426215376L, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInCommentsActive = load("actions/inlayRenameInCommentsActive.svg", -494794368278084800L, 2);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInNoCodeFiles = load("actions/inlayRenameInNoCodeFiles.svg", 8418198486316416113L, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInNoCodeFilesActive = load("actions/inlayRenameInNoCodeFilesActive.svg", 8255917969505710411L, 2);
    /** 16x16 */ public static final @NotNull Icon InSelection = load("actions/inSelection.svg", 5020415327169094030L, 2);
    /** 16x16 */ public static final @NotNull Icon Install = load("actions/install.svg", -2970729039779294915L, 2);
    /** 16x16 */ public static final @NotNull Icon IntentionBulb = load("actions/intentionBulb.svg", 9025824012437250774L, 2);
    /** 16x16 */ public static final @NotNull Icon IntentionBulbGrey = load("actions/intentionBulbGrey.svg", 4499632565818630301L, 2);
    /** 16x16 */ public static final @NotNull Icon Lightning = load("actions/lightning.svg", -9087560625040805047L, 2);
    /** 16x16 */ public static final @NotNull Icon ListChanges = load("actions/listChanges.svg", -5203253593337508401L, 2);
    /** 16x16 */ public static final @NotNull Icon ListFiles = load("actions/listFiles.svg", 5808475928904640049L, 2);
    /** 16x16 */ public static final @NotNull Icon MatchCase = load("actions/matchCase.svg", -7190671993295366574L, 0);
    /** 16x16 */ public static final @NotNull Icon MatchCaseHovered = load("actions/matchCaseHovered.svg", 7100576073278636516L, 0);
    /** 16x16 */ public static final @NotNull Icon MatchCaseSelected = load("actions/matchCaseSelected.svg", -4447504870471917240L, 0);
    /** 16x16 */ public static final @NotNull Icon MenuCut = load("actions/menu-cut.svg", 833671025599564624L, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_cut = MenuCut;
    /** 16x16 */ public static final @NotNull Icon MenuOpen = load("actions/menu-open.svg", 7227999428473585553L, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_open = MenuOpen;
    /** 16x16 */ public static final @NotNull Icon MenuPaste = load("actions/menu-paste.svg", 58251009612783400L, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_paste = MenuPaste;
    /** 16x16 */ public static final @NotNull Icon MenuSaveall = load("actions/menu-saveall.svg", -4987978715156629295L, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_saveall = MenuSaveall;
    /** 16x16 */ public static final @NotNull Icon ModuleDirectory = load("actions/moduleDirectory.svg", -2537657051916062475L, 2);
    /** 16x16 */ public static final @NotNull Icon More = load("actions/more.svg", 2471097429083150951L, 2);
    /** 16x16 */ public static final @NotNull Icon MoreHorizontal = load("actions/moreHorizontal.svg", -536130783500281121L, 2);
    /** 12x12 */ public static final @NotNull Icon MoveToButton = load("actions/move-to-button.svg", 7258801418676609324L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveDown = load("actions/moveDown.svg", 6019790359720881156L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveTo2 = load("actions/MoveTo2.svg", 3303221477623645841L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToBottomLeft = load("actions/moveToBottomLeft.svg", 8613177686485684153L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToBottomRight = load("actions/moveToBottomRight.svg", -222081205497652709L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToLeftBottom = load("actions/moveToLeftBottom.svg", 4881950383383690929L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToLeftTop = load("actions/moveToLeftTop.svg", 8327948652611043133L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToRightBottom = load("actions/moveToRightBottom.svg", -1853904522662955881L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToRightTop = load("actions/moveToRightTop.svg", 7756392225506283975L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToTopLeft = load("actions/moveToTopLeft.svg", 2219614238189285848L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToTopRight = load("actions/moveToTopRight.svg", 4771455248045913770L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToWindow = load("actions/moveToWindow.svg", -1011081424892633580L, 2);
    /** 16x16 */ public static final @NotNull Icon MoveUp = load("actions/moveUp.svg", 7642414214183682259L, 2);
    /** 16x16 */ public static final @NotNull Icon New = load("actions/new.svg", -6025218298955980075L, 2);
    /** 16x16 */ public static final @NotNull Icon NewFolder = load("actions/newFolder.svg", -5771568658957023247L, 2);
    /** 16x16 */ public static final @NotNull Icon NextOccurence = load("actions/nextOccurence.svg", -7996011607551541498L, 2);
    /** 16x16 */ public static final @NotNull Icon OfflineMode = load("actions/offlineMode.svg", 6006018294881718457L, 2);
    /** 16x16 */ public static final @NotNull Icon OpenNewTab = load("actions/openNewTab.svg", -6999907221634749132L, 2);
    /** 16x16 */ public static final @NotNull Icon Pause = load("actions/pause.svg", 8940165492022361470L, 2);
    /** 16x16 */ public static final @NotNull Icon PinTab = load("actions/pinTab.svg", -3810432975011581135L, 0);
    /** 16x16 */ public static final @NotNull Icon Play_back = load("actions/play_back.svg", -4243016413705450414L, 2);
    /** 16x16 */ public static final @NotNull Icon Play_first = load("actions/play_first.svg", -6092167383886705307L, 2);
    /** 16x16 */ public static final @NotNull Icon Play_forward = load("actions/play_forward.svg", -3861886799491248314L, 2);
    /** 16x16 */ public static final @NotNull Icon Play_last = load("actions/play_last.svg", 8561966384508807746L, 2);
    /** 16x16 */ public static final @NotNull Icon PopFrame = load("actions/popFrame.svg", 4001160359081710211L, 2);
    /** 16x16 */ public static final @NotNull Icon PreserveCase = load("actions/preserveCase.svg", -1322116453035686737L, 0);
    /** 16x16 */ public static final @NotNull Icon PreserveCaseHover = load("actions/preserveCaseHover.svg", 6175350140642539380L, 0);
    /** 16x16 */ public static final @NotNull Icon PreserveCaseSelected = load("actions/preserveCaseSelected.svg", -3589871950844855647L, 0);
    /** 16x16 */ public static final @NotNull Icon PrettyPrint = load("actions/prettyPrint.svg", -306145386571111647L, 2);
    /** 16x16 */ public static final @NotNull Icon Preview = load("actions/preview.svg", -4590724503395184315L, 2);
    /** 16x16 */ public static final @NotNull Icon PreviewDetails = load("actions/previewDetails.svg", 3503221558376525063L, 2);
    /** 16x16 */ public static final @NotNull Icon PreviewDetailsVertically = load("actions/previewDetailsVertically.svg", -2842977284225757197L, 2);
    /** 16x16 */ public static final @NotNull Icon PreviousOccurence = load("actions/previousOccurence.svg", -4109992584836216197L, 2);
    /** 16x16 */ public static final @NotNull Icon Profile = load("actions/profile.svg", -2174330136700270399L, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileBlue = load("actions/profileBlue.svg", 3472955242677971932L, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileCPU = load("actions/profileCPU.svg", 7803574856781493431L, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileMemory = load("actions/profileMemory.svg", -1435735105619396468L, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileRed = load("actions/profileRed.svg", -5397081292725366730L, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileYellow = load("actions/profileYellow.svg", -1996801427383721020L, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectDirectory = load("actions/projectDirectory.svg", -2286332708757590503L, 2);
    /** 16x16 */ public static final @NotNull Icon Properties = load("actions/properties.svg", -1192087932538467805L, 2);
    /** 16x16 */ public static final @NotNull Icon QuickfixBulb = load("actions/quickfixBulb.svg", 487925246148052249L, 2);
    /** 16x16 */ public static final @NotNull Icon QuickfixOffBulb = load("actions/quickfixOffBulb.svg", -9152331797598346514L, 2);
    /** 16x16 */ public static final @NotNull Icon RealIntentionBulb = load("actions/realIntentionBulb.svg", 4462317638084577335L, 2);
    /** 16x16 */ public static final @NotNull Icon Redo = load("actions/redo.svg", 3093713791864237789L, 2);
    /** 16x16 */ public static final @NotNull Icon RefactoringBulb = load("actions/refactoringBulb.svg", 1359250671718505734L, 2);
    /** 16x16 */ public static final @NotNull Icon Refresh = load("actions/refresh.svg", 4404061801588842518L, 2);
    /** 16x16 */ public static final @NotNull Icon Regex = load("actions/regex.svg", 7079949254075541463L, 0);
    /** 16x16 */ public static final @NotNull Icon RegexHovered = load("actions/regexHovered.svg", 8040243692229073219L, 0);
    /** 16x16 */ public static final @NotNull Icon RegexSelected = load("actions/regexSelected.svg", 5820105841109204204L, 0);
    /** 16x16 */ public static final @NotNull Icon RemoveMulticaret = load("actions/RemoveMulticaret.svg", 72335666655416148L, 2);
    /** 16x16 */ public static final @NotNull Icon Replace = load("actions/replace.svg", 2546378297129085220L, 2);
    /** 16x16 */ public static final @NotNull Icon Rerun = load("actions/rerun.svg", 303797536788218649L, 2);
    /** 16x16 */ public static final @NotNull Icon Restart = load("actions/restart.svg", -6697622318039577676L, 2);
    /** 16x16 */ public static final @NotNull Icon RestartDebugger = load("actions/restartDebugger.svg", -5206657780261670483L, 2);
    /** 16x16 */ public static final @NotNull Icon RestartFrame = load("actions/restartFrame.svg", 5453695065416234006L, 2);
    /** 16x16 */ public static final @NotNull Icon Resume = load("actions/resume.svg", -8310922573701913021L, 2);
    /** 16x16 */ public static final @NotNull Icon Rollback = load("actions/rollback.svg", -7881342578002296873L, 2);
    /** 16x16 */ public static final @NotNull Icon Run_anything = load("actions/run_anything.svg", -8180174250439524764L, 2);
    /** 16x16 */ public static final @NotNull Icon RunAll = load("actions/runAll.svg", -7728958574177164255L, 2);
    /** 16x16 */ public static final @NotNull Icon RunToCursor = load("actions/runToCursor.svg", 4336276862336109559L, 2);
    /** 16x16 */ public static final @NotNull Icon Scratch = load("actions/scratch.svg", 8029347498509121787L, 2);
    /** 16x16 */ public static final @NotNull Icon Search = load("actions/search.svg", 426760262963559341L, 0);
    /** 16x16 */ public static final @NotNull Icon SearchNewLine = load("actions/searchNewLine.svg", -3224677980131903010L, 0);
    /** 16x16 */ public static final @NotNull Icon SearchNewLineHover = load("actions/searchNewLineHover.svg", 2025867515574190653L, 0);
    /** 16x16 */ public static final @NotNull Icon SearchWithHistory = load("actions/searchWithHistory.svg", -6109652440271084329L, 0);
    /** 16x16 */ public static final @NotNull Icon Selectall = load("actions/selectall.svg", -7943891274258271806L, 2);
    /** 16x16 */ public static final @NotNull Icon SetDefault = load("actions/setDefault.svg", -7290529120102192751L, 2);
    /** 14x14 */ public static final @NotNull Icon Share = load("actions/share.png", 0L, 1);
    /** 16x16 */ public static final @NotNull Icon ShortcutFilter = load("actions/shortcutFilter.svg", 3764946284720879818L, 2);
    /** 16x16 */ public static final @NotNull Icon Show = load("actions/show.svg", -2738211844022695819L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowAsTree = load("actions/showAsTree.svg", 6302851947523799483L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowCode = load("actions/showCode.svg", 6241633899328193100L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowHiddens = load("actions/showHiddens.svg", -3328168920283963312L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowImportStatements = load("actions/showImportStatements.svg", -4547130578303611999L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowReadAccess = load("actions/showReadAccess.svg", -732490403124011256L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowWriteAccess = load("actions/showWriteAccess.svg", 3273905754142296282L, 2);
    /** 16x16 */ public static final @NotNull Icon SplitHorizontally = load("actions/splitHorizontally.svg", 5912653530363148932L, 2);
    /** 16x16 */ public static final @NotNull Icon SplitVertically = load("actions/splitVertically.svg", -6022584484892652253L, 2);
    /** 16x16 */ public static final @NotNull Icon StartDebugger = load("actions/startDebugger.svg", 310781418073208995L, 2);
    /** 16x16 */ public static final @NotNull Icon StartMemoryProfile = load("actions/startMemoryProfile.svg", -5723179870613849748L, 2);
    /** 16x16 */ public static final @NotNull Icon StepOut = load("actions/stepOut.svg", 759551024898688211L, 2);
    /** 16x16 */ public static final @NotNull Icon StepOutCodeBlock = load("actions/stepOutCodeBlock.svg", 6866502153426800357L, 2);
    /** 16x16 */ public static final @NotNull Icon StopRefresh = load("actions/stopRefresh.svg", 5442164503548178852L, 2);
    /** 16x16 */ public static final @NotNull Icon Stub = load("actions/stub.svg", 3323634267307057727L, 2);
    /** 16x16 */ public static final @NotNull Icon SuggestedRefactoringBulb = load("actions/suggestedRefactoringBulb.svg", 5321872747124763583L, 2);
    /** 16x16 */ public static final @NotNull Icon Suspend = load("actions/suspend.svg", 8432390976216963516L, 2);
    /** 16x16 */ public static final @NotNull Icon SwapPanels = load("actions/swapPanels.svg", 5385595242555230581L, 2);
    /** 16x16 */ public static final @NotNull Icon SynchronizeScrolling = load("actions/synchronizeScrolling.svg", -9102172840245054089L, 2);
    /** 16x16 */ public static final @NotNull Icon SyncPanels = load("actions/syncPanels.svg", 5660097119862757375L, 2);
    /** 16x16 */ public static final @NotNull Icon ToggleSoftWrap = load("actions/toggleSoftWrap.svg", -6823070809588959782L, 2);
    /** 16x16 */ public static final @NotNull Icon TraceInto = load("actions/traceInto.svg", 6677723924811002477L, 2);
    /** 16x16 */ public static final @NotNull Icon TraceOver = load("actions/traceOver.svg", -2057035440183686022L, 2);
    /** 16x16 */ public static final @NotNull Icon Undo = load("actions/undo.svg", 5740002309169920728L, 2);
    /** 16x16 */ public static final @NotNull Icon Uninstall = load("actions/uninstall.svg", 9172567028649779603L, 2);
    /** 16x16 */ public static final @NotNull Icon Unselectall = load("actions/unselectall.svg", -412208965386235219L, 2);
    /** 14x14 */ public static final @NotNull Icon Unshare = load("actions/unshare.png", 0L, 1);
    /** 16x16 */ public static final @NotNull Icon Upload = load("actions/upload.svg", 4192897216526058663L, 2);
    /** 16x16 */ public static final @NotNull Icon Words = load("actions/words.svg", -8783977327151960900L, 0);
    /** 16x16 */ public static final @NotNull Icon WordsHovered = load("actions/wordsHovered.svg", -335654288408814947L, 0);
    /** 16x16 */ public static final @NotNull Icon WordsSelected = load("actions/wordsSelected.svg", -1991403695370154844L, 0);

    /** @deprecated to be removed in IDEA 2021.1 (use expandable text field instead, see https://jetbrains.design/intellij/controls/built_in_button/) */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval(inVersion = "2021.1")
    public static final @NotNull Icon ShowViewer = load("actions/showViewer.png", 0L, 0);
  }

  public static final class Chooser {
    /** 16x16 */ public static final @NotNull Icon Bottom = load("chooser/bottom.svg", -8108010060508403731L, 2);
    /** 16x16 */ public static final @NotNull Icon Left = load("chooser/left.svg", 4895662085937558378L, 2);
    /** 16x16 */ public static final @NotNull Icon Right = load("chooser/right.svg", -3022123317635132687L, 2);
    /** 16x16 */ public static final @NotNull Icon Top = load("chooser/top.svg", -7250113669665053530L, 2);
  }

  public static final class CodeStyle {
    /** 16x16 */ public static final @NotNull Icon AddNewSectionRule = load("codeStyle/AddNewSectionRule.svg", 6106753974582276537L, 2);
  }

  public static final class CodeWithMe {
    /** 16x16 */ public static final @NotNull Icon CwmAccess = load("codeWithMe/cwmAccess.svg", -8506332554421268584L, 2);
    /** 12x16 */ public static final @NotNull Icon CwmAccessDotOff = load("codeWithMe/cwmAccessDotOff.svg", -8812063715608207365L, 2);
    /** 12x16 */ public static final @NotNull Icon CwmAccessDotOn = load("codeWithMe/cwmAccessDotOn.svg", -2516495234422554919L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmAccessOff = load("codeWithMe/cwmAccessOff.svg", -3285420431309666253L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmAccessOn = load("codeWithMe/cwmAccessOn.svg", 4803550132182083872L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmCamOff = load("codeWithMe/cwmCamOff.svg", -2088058011499646084L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmCamOn = load("codeWithMe/cwmCamOn.svg", 4185871417777959344L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmDisableCall = load("codeWithMe/cwmDisableCall.svg", -2723979276510942685L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmEnableCall = load("codeWithMe/cwmEnableCall.svg", -6726452533302541429L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFollow = load("codeWithMe/cwmFollow.svg", 421350531028907789L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFollowMe = load("codeWithMe/cwmFollowMe.svg", -270893421881497261L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmForceFollowMe = load("codeWithMe/cwmForceFollowMe.svg", 4620331311933886528L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFullSync = load("codeWithMe/cwmFullSync.svg", -5990287561754382387L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmInvite = load("codeWithMe/cwmInvite.svg", -6378398958929348504L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmJoin = load("codeWithMe/cwmJoin.svg", -5688831560680536203L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmJump = load("codeWithMe/cwmJump.svg", 6222033519634375585L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmKick = load("codeWithMe/cwmKick.svg", -4882021339463982249L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmLeaveCall = load("codeWithMe/cwmLeaveCall.svg", 2933730550014524791L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmMicOff = load("codeWithMe/cwmMicOff.svg", -2532064138621392922L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmMicOn = load("codeWithMe/cwmMicOn.svg", -2521698193171779423L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionEdit = load("codeWithMe/cwmPermissionEdit.svg", -467237567778538603L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissions = load("codeWithMe/cwmPermissions.svg", -3626990678285946908L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionView = load("codeWithMe/cwmPermissionView.svg", -7408159216023644971L, 2);
    /** 16x16 */ public static final @NotNull Icon CwmTerminate = load("codeWithMe/cwmTerminate.svg", -3719367957211773326L, 2);
    /** 16x16 */ public static final @NotNull Icon Users = load("codeWithMe/users.svg", -3982956695729524383L, 2);
  }

  public static final class Debugger {
    /** 16x16 */ public static final @NotNull Icon AddToWatch = load("debugger/addToWatch.svg", -1598627067206727945L, 2);
    /** 16x16 */ public static final @NotNull Icon AttachToProcess = load("debugger/attachToProcess.svg", -6115499259772058160L, 2);
    /** 16x16 */ public static final @NotNull Icon ClassLevelWatch = load("debugger/classLevelWatch.svg", 2525965139499029804L, 2);
    /** 16x16 */ public static final @NotNull Icon Console = load("debugger/console.svg", -4822071816097150917L, 2);
    /** 16x16 */ public static final @NotNull Icon Db_array = load("debugger/db_array.svg", 6024726000166400335L, 2);
    /** 16x16 */ public static final @NotNull Icon Db_db_object = load("debugger/db_db_object.svg", -6904576030708785894L, 0);
    /** 12x12 */ public static final @NotNull Icon Db_dep_field_breakpoint = load("debugger/db_dep_field_breakpoint.svg", -2612867565142998769L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_dep_line_breakpoint = load("debugger/db_dep_line_breakpoint.svg", 4399606591283061377L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_dep_method_breakpoint = load("debugger/db_dep_method_breakpoint.svg", 1868862666434784455L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_breakpoint = load("debugger/db_disabled_breakpoint.svg", -4395769550840486041L, 2);
    /** 16x16 */ public static final @NotNull Icon Db_disabled_breakpoint_process = load("debugger/db_disabled_breakpoint_process.svg", 2340867480739960110L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_exception_breakpoint = load("debugger/db_disabled_exception_breakpoint.svg", 7274406050587235623L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_field_breakpoint = load("debugger/db_disabled_field_breakpoint.svg", 7656821614110185640L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_method_breakpoint = load("debugger/db_disabled_method_breakpoint.svg", -7299887470245444041L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_exception_breakpoint = load("debugger/db_exception_breakpoint.svg", 8691931814100524090L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_field_breakpoint = load("debugger/db_field_breakpoint.svg", 1976393415556332348L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_invalid_breakpoint = load("debugger/db_invalid_breakpoint.svg", -6238781240120262679L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_method_breakpoint = load("debugger/db_method_breakpoint.svg", 1703283998821800901L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_breakpoint = load("debugger/db_muted_breakpoint.svg", 6403882043267209232L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_field_breakpoint = load("debugger/db_muted_dep_field_breakpoint.svg", -3360198471107860032L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_line_breakpoint = load("debugger/db_muted_dep_line_breakpoint.svg", 3986697065787472899L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_method_breakpoint = load("debugger/db_muted_dep_method_breakpoint.svg", 3172612937061693879L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_breakpoint = load("debugger/db_muted_disabled_breakpoint.svg", 1789453030990354805L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_field_breakpoint = load("debugger/db_muted_disabled_field_breakpoint.svg", 6450745814932172116L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_method_breakpoint = load("debugger/db_muted_disabled_method_breakpoint.svg", 855617282600290270L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_field_breakpoint = load("debugger/db_muted_field_breakpoint.svg", -2204782650511111852L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_method_breakpoint = load("debugger/db_muted_method_breakpoint.svg", -1186869202400455614L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_breakpoint = load("debugger/db_no_suspend_breakpoint.svg", 1095949901055556855L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_field_breakpoint = load("debugger/db_no_suspend_field_breakpoint.svg", -3361130143101679615L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_method_breakpoint = load("debugger/db_no_suspend_method_breakpoint.svg", -4271928561563803001L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_obsolete = load("debugger/db_obsolete.svg", 6747040375064157095L, 2);
    /** 16x16 */ public static final @NotNull Icon Db_primitive = load("debugger/db_primitive.svg", 6013703726201908518L, 0);
    /** 12x12 */ public static final @NotNull Icon Db_set_breakpoint = load("debugger/db_set_breakpoint.svg", -3735585395109295158L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_breakpoint = load("debugger/db_verified_breakpoint.svg", -4113899786497182664L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_field_breakpoint = load("debugger/db_verified_field_breakpoint.svg", 7393571177824857413L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_method_breakpoint = load("debugger/db_verified_method_breakpoint.svg", 6041555940569600542L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_breakpoint = load("debugger/db_verified_no_suspend_breakpoint.svg", 6105263352889664674L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_field_breakpoint = load("debugger/db_verified_no_suspend_field_breakpoint.svg", 3666024692740058116L, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_method_breakpoint = load("debugger/db_verified_no_suspend_method_breakpoint.svg", -2650369292250519558L, 2);
    /** 16x16 */ public static final @NotNull Icon Db_watch = load("debugger/db_watch.svg", 9126279772329778481L, 0);
    /** 16x16 */ public static final @NotNull Icon EvaluateExpression = load("debugger/evaluateExpression.svg", 1937959259350865627L, 2);
    /** 16x16 */ public static final @NotNull Icon EvaluationResult = load("debugger/evaluationResult.svg", -4443264578261613055L, 2);
    /** 16x16 */ public static final @NotNull Icon Frame = load("debugger/frame.svg", 6634513910544410078L, 2);
    /** 16x16 */ public static final @NotNull Icon KillProcess = load("debugger/killProcess.svg", -2409254803105965430L, 2);
    /** 12x12 */ public static final @NotNull Icon LambdaBreakpoint = load("debugger/LambdaBreakpoint.svg", -3552469871333191223L, 2);
    /** 12x12 */ public static final @NotNull Icon MultipleBreakpoints = load("debugger/MultipleBreakpoints.svg", 4368043537559321444L, 2);
    /** 16x16 */ public static final @NotNull Icon MuteBreakpoints = load("debugger/muteBreakpoints.svg", -60712244510875215L, 2);
    /** 12x12 */ public static final @NotNull Icon NextStatement = load("debugger/nextStatement.svg", -2286724551958305351L, 2);
    /** 16x16 */ public static final @NotNull Icon Overhead = load("debugger/overhead.svg", -7810432143676375689L, 2);
    /** 16x16 */ public static final @NotNull Icon PromptInput = load("debugger/promptInput.svg", 1837157542111436890L, 2);
    /** 16x16 */ public static final @NotNull Icon PromptInputHistory = load("debugger/promptInputHistory.svg", 267985079255180872L, 2);
    /** 7x9 */ public static final @NotNull Icon Question_badge = load("debugger/question_badge.svg", -8533873966631320931L, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreLayout = load("debugger/restoreLayout.svg", 9080611226970364260L, 2);
    /** 16x16 */ public static final @NotNull Icon Selfreference = load("debugger/selfreference.svg", -6245482850631762733L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowCurrentFrame = load("debugger/showCurrentFrame.svg", 1786771350398767849L, 2);
    /** 16x16 */ public static final @NotNull Icon SmartStepInto = load("debugger/smartStepInto.svg", -8653432387754040588L, 2);
    /** 16x16 */ public static final @NotNull Icon ThreadAtBreakpoint = load("debugger/threadAtBreakpoint.svg", 7133240471129902888L, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadCurrent = load("debugger/threadCurrent.svg", -5369384024686874361L, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadFrozen = load("debugger/threadFrozen.svg", 4116315281496274501L, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadGroup = load("debugger/threadGroup.svg", 7604654365931455726L, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadGroupCurrent = load("debugger/threadGroupCurrent.svg", -6891987693873433865L, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadRunning = load("debugger/threadRunning.svg", 1579259517968411099L, 0);
    /** 16x16 */ public static final @NotNull Icon Threads = load("debugger/threads.svg", -5346129201146961215L, 2);

    public static final class ThreadStates {
      /** 16x16 */ public static final @NotNull Icon Daemon_sign = load("debugger/threadStates/daemon_sign.svg", -5770330505302042691L, 2);
      /** 16x16 */ public static final @NotNull Icon Idle = load("debugger/threadStates/idle.svg", -977372656429975927L, 2);
      /** 16x16 */ public static final @NotNull Icon Socket = load("debugger/threadStates/socket.svg", -4186231854506074667L, 2);
    }

    /** 16x16 */ public static final @NotNull Icon ThreadSuspended = load("debugger/threadSuspended.svg", 5223563256539556046L, 0);
    /** 16x16 */ public static final @NotNull Icon Value = load("debugger/value.svg", -1191202200043322298L, 0);
    /** 16x16 */ public static final @NotNull Icon VariablesTab = load("debugger/variablesTab.svg", 1815043959844051045L, 2);
    /** 16x16 */ public static final @NotNull Icon ViewBreakpoints = load("debugger/viewBreakpoints.svg", 263121527679322298L, 2);
    /** 16x16 */ public static final @NotNull Icon Watch = load("debugger/watch.svg", -3461362885033852817L, 2);
    /** 16x16 */ public static final @NotNull Icon WatchLastReturnValue = load("debugger/watchLastReturnValue.svg", 1709888467733106799L, 2);
  }

  public static final class Diff {
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflicts = load("diff/applyNotConflicts.svg", -9051412667934217416L, 2);
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflictsLeft = load("diff/applyNotConflictsLeft.svg", 8078066539245727125L, 2);
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflictsRight = load("diff/applyNotConflictsRight.svg", -644467944176918954L, 2);
    /** 12x12 */ public static final @NotNull Icon Arrow = load("diff/arrow.svg", 4334798633779627543L, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowLeftDown = load("diff/arrowLeftDown.svg", -8824351364535083438L, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowRight = load("diff/arrowRight.svg", 5491664211546617220L, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowRightDown = load("diff/arrowRightDown.svg", -6340816476176228040L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3LeftMiddle = load("diff/compare3LeftMiddle.svg", -4362433405227455399L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3LeftRight = load("diff/compare3LeftRight.svg", 2352933736883541608L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3MiddleRight = load("diff/compare3MiddleRight.svg", 7433567558007801240L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftBottom = load("diff/compare4LeftBottom.svg", -1283896543325643709L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftMiddle = load("diff/compare4LeftMiddle.svg", -2157846043385782344L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftRight = load("diff/compare4LeftRight.svg", -2762653912563655204L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4MiddleBottom = load("diff/compare4MiddleBottom.svg", 498469730442617959L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4MiddleRight = load("diff/compare4MiddleRight.svg", -1354966159231343998L, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4RightBottom = load("diff/compare4RightBottom.svg", -6778487947434127823L, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBox = load("diff/gutterCheckBox.svg", 3987280751810919561L, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBoxIndeterminate = load("diff/gutterCheckBoxIndeterminate.svg", 729741412660922678L, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBoxSelected = load("diff/gutterCheckBoxSelected.svg", 5282112807636079228L, 2);
    /** 16x16 */ public static final @NotNull Icon Lock = load("diff/lock.svg", -4150062431594376492L, 2);
    /** 12x12 */ public static final @NotNull Icon MagicResolve = load("diff/magicResolve.svg", 2593679079310629736L, 2);
    /** 16x16 */ public static final @NotNull Icon MagicResolveToolbar = load("diff/magicResolveToolbar.svg", -3037227335763775855L, 2);
    /** 12x12 */ public static final @NotNull Icon Remove = load("diff/remove.svg", -2995339176445588748L, 2);
    /** 12x12 */ public static final @NotNull Icon Revert = load("diff/revert.svg", 924557347117081630L, 2);
  }

  public static final class Duplicates {
    /** 16x16 */ public static final @NotNull Icon SendToTheLeft = load("duplicates/sendToTheLeft.png", 0L, 1);
    /** 16x16 */ public static final @NotNull Icon SendToTheLeftGrayed = load("duplicates/sendToTheLeftGrayed.png", 0L, 7);
    /** 16x16 */ public static final @NotNull Icon SendToTheRight = load("duplicates/sendToTheRight.png", 0L, 1);
    /** 16x16 */ public static final @NotNull Icon SendToTheRightGrayed = load("duplicates/sendToTheRightGrayed.png", 0L, 7);
  }

  public static final class FileTypes {
    /** 16x16 */ public static final @NotNull Icon AddAny = load("fileTypes/addAny.svg", 978764432537466394L, 0);
    /** 16x16 */ public static final @NotNull Icon Any_type = load("fileTypes/any_type.svg", 8927404783736139307L, 0);
    /** 16x16 */ public static final @NotNull Icon Archive = load("fileTypes/archive.svg", 6050653414346231066L, 0);
    /** 16x16 */ public static final @NotNull Icon AS = load("fileTypes/as.svg", 2658246194349094706L, 0);
    /** 16x16 */ public static final @NotNull Icon Aspectj = load("fileTypes/aspectj.svg", 6222228160065040843L, 0);
    /** 16x16 */ public static final @NotNull Icon Config = load("fileTypes/config.svg", 4098604773600682101L, 0);
    /** 16x16 */ public static final @NotNull Icon Css = load("fileTypes/css.svg", 973374149748766976L, 0);
    /** 16x16 */ public static final @NotNull Icon Custom = load("fileTypes/custom.svg", -9085020248910575542L, 0);
    /** 16x16 */ public static final @NotNull Icon Diagram = load("fileTypes/diagram.svg", 2878252828662988838L, 0);
    /** 16x16 */ public static final @NotNull Icon Dtd = load("fileTypes/dtd.svg", 1512744705207344987L, 0);
    /** 16x16 */ public static final @NotNull Icon Hprof = load("fileTypes/hprof.svg", -917121733692257803L, 0);
    /** 16x16 */ public static final @NotNull Icon Htaccess = load("fileTypes/htaccess.svg", 8172243446327886417L, 0);
    /** 16x16 */ public static final @NotNull Icon Html = load("fileTypes/html.svg", -3878444809017733799L, 0);
    /** 16x16 */ public static final @NotNull Icon Idl = load("fileTypes/idl.svg", -3673761919827134848L, 0);
    /** 16x16 */ public static final @NotNull Icon Java = load("fileTypes/java.svg", -8031707707310943995L, 0);
    /** 16x16 */ public static final @NotNull Icon JavaClass = load("fileTypes/javaClass.svg", 1537034655787663158L, 0);
    /** 16x16 */ public static final @NotNull Icon JavaOutsideSource = load("fileTypes/javaOutsideSource.svg", -1332262268381891224L, 0);
    /** 16x16 */ public static final @NotNull Icon JavaScript = load("fileTypes/javaScript.svg", -4186188120721108429L, 0);
    /** 16x16 */ public static final @NotNull Icon Jfr = load("fileTypes/jfr.svg", 1504098668566506408L, 0);
    /** 16x16 */ public static final @NotNull Icon Json = load("fileTypes/json.svg", 7047330769488036116L, 2);
    /** 16x16 */ public static final @NotNull Icon JsonSchema = load("fileTypes/jsonSchema.svg", -637530520441570990L, 2);
    /** 16x16 */ public static final @NotNull Icon Jsp = load("fileTypes/jsp.svg", 3865835302853651631L, 0);
    /** 16x16 */ public static final @NotNull Icon Jspx = load("fileTypes/jspx.svg", 2798141038463687444L, 0);
    /** 16x16 */ public static final @NotNull Icon Manifest = load("fileTypes/manifest.svg", -2934446404643427903L, 0);
    /** 16x16 */ public static final @NotNull Icon Properties = load("fileTypes/properties.svg", 5433288177744198037L, 0);
    /** 16x16 */ public static final @NotNull Icon Regexp = load("fileTypes/regexp.svg", -6767899627964867694L, 0);
    /** 16x16 */ public static final @NotNull Icon Text = load("fileTypes/text.svg", 7689645739609550802L, 0);
    /** 16x16 */ public static final @NotNull Icon UiForm = load("fileTypes/uiForm.svg", 3166810128203393082L, 0);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("fileTypes/unknown.svg", -8833146704508793836L, 0);
    /** 16x16 */ public static final @NotNull Icon WsdlFile = load("fileTypes/wsdlFile.svg", 7874564194296539312L, 0);
    /** 16x16 */ public static final @NotNull Icon Xhtml = load("fileTypes/xhtml.svg", 3370090005463069905L, 0);
    /** 16x16 */ public static final @NotNull Icon Xml = load("fileTypes/xml.svg", -6695770898600836212L, 0);
    /** 16x16 */ public static final @NotNull Icon XsdFile = load("fileTypes/xsdFile.svg", 5083763311033177715L, 0);
    /** 16x16 */ public static final @NotNull Icon Yaml = load("fileTypes/yaml.svg", -29541401392162112L, 0);
  }

  public static final class General {
    /** 16x16 */ public static final @NotNull Icon ActualZoom = load("general/actualZoom.svg", 1709696669673525338L, 2);
    /** 16x16 */ public static final @NotNull Icon Add = load("general/add.svg", 3793109198085775081L, 2);
    /** 16x16 */ public static final @NotNull Icon AddJdk = load("general/addJdk.svg", -4111926971593229913L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowDown = load("general/arrowDown.svg", 3747578626285315751L, 2);
    /** 9x5 */ public static final @NotNull Icon ArrowDownSmall = load("general/arrowDownSmall.svg", -7189322418215475325L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowLeft = load("general/arrowLeft.svg", 4472718435241023064L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowRight = load("general/arrowRight.svg", -5945146956100640131L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowSplitCenterH = load("general/arrowSplitCenterH.svg", -3675575761835544296L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowSplitCenterV = load("general/arrowSplitCenterV.svg", 932563386492164243L, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowUp = load("general/arrowUp.svg", 68122225726816389L, 2);
    /** 16x16 */ public static final @NotNull Icon AutoscrollFromSource = load("general/autoscrollFromSource.svg", 5984459734713970517L, 2);
    /** 16x16 */ public static final @NotNull Icon AutoscrollToSource = load("general/autoscrollToSource.svg", 8201797313958569125L, 2);
    /** 16x16 */ public static final @NotNull Icon Balloon = load("general/balloon.svg", -512127883005055856L, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonError = load("general/balloonError.svg", 1436435000612652024L, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonInformation = load("general/balloonInformation.svg", -3942968763988300740L, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonWarning = load("general/balloonWarning.svg", -8276668115639094254L, 2);
    /** 12x12 */ public static final @NotNull Icon BalloonWarning12 = load("general/balloonWarning12.svg", 6705424357398127516L, 2);
    /** 8x4 */ public static final @NotNull Icon ButtonDropTriangle = load("general/buttonDropTriangle.svg", -8269536136438475818L, 2);
    /** 16x16 */ public static final @NotNull Icon ChevronDown = load("general/chevron-down.svg", -6012940629945477261L, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronLeft = load("general/chevron-left.svg", -4543373687359135559L, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronRight = load("general/chevron-right.svg", 1614753329141226892L, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronUp = load("general/chevron-up.svg", 8857373647534016930L, 0);
    /** 16x16 */ public static final @NotNull Icon CollapseComponent = load("general/collapseComponent.svg", 363988761748794912L, 0);
    /** 16x16 */ public static final @NotNull Icon CollapseComponentHover = load("general/collapseComponentHover.svg", 812123968509113857L, 0);
    /** 16x16 */ public static final @NotNull Icon ContextHelp = load("general/contextHelp.svg", 1376735081551049382L, 0);
    /** 16x16 */ public static final @NotNull Icon CopyHovered = load("general/copyHovered.svg", 7053797015248561055L, 0);
    /** 2x19 */ public static final @NotNull Icon Divider = load("general/divider.svg", 2117864223991204527L, 2);
    /** 16x16 */ public static final @NotNull Icon Dropdown = load("general/dropdown.svg", -6260614005469548725L, 2);
    /** 13x13 */ public static final @NotNull Icon DropdownGutter = load("general/dropdownGutter.svg", -2707284235801311248L, 2);
    /** 2x20 */ public static final @NotNull Icon DropPlace = load("general/dropPlace.svg", 3570255038463236798L, 2);
    /** 9x9 */ public static final @NotNull Icon Ellipsis = load("general/ellipsis.svg", 489438886152298535L, 2);
    /** 16x16 */ public static final @NotNull Icon Error = load("general/error.svg", 3699262425366776350L, 0);
    /** 32x32 */ public static final @NotNull Icon ErrorDialog = load("general/errorDialog.svg", -1970692986936510583L, 2);
    /** 16x16 */ public static final @NotNull Icon ExclMark = load("general/exclMark.svg", 37899619886349356L, 2);
    /** 16x16 */ public static final @NotNull Icon ExpandComponent = load("general/expandComponent.svg", 1243758111012832162L, 0);
    /** 16x16 */ public static final @NotNull Icon ExpandComponentHover = load("general/expandComponentHover.svg", -2304277792964696585L, 0);
    /** 16x16 */ public static final @NotNull Icon ExternalTools = load("general/externalTools.svg", -6856678828470399892L, 2);
    /** 16x16 */ public static final @NotNull Icon Filter = load("general/filter.svg", 8424547176780303664L, 2);
    /** 16x16 */ public static final @NotNull Icon FitContent = load("general/fitContent.svg", -8164840460982613929L, 2);
    /** 16x16 */ public static final @NotNull Icon Gear = load("general/gear.svg", -2323667661656053817L, 0);
    /** 16x16 */ public static final @NotNull Icon GearHover = load("general/gearHover.svg", 6953069430927641152L, 0);
    /** 16x16 */ public static final @NotNull Icon GearPlain = load("general/gearPlain.svg", -277797916421653758L, 2);
    /** 16x16 */ public static final @NotNull Icon HideToolWindow = load("general/hideToolWindow.svg", -8384226792954975648L, 2);
    /** 16x16 */ public static final @NotNull Icon ImplementingMethod = load("general/implementingMethod.svg", 3378222749158544348L, 1);
    /** 16x16 */ public static final @NotNull Icon Information = load("general/information.svg", 6074082629107125600L, 0);
    /** 32x32 */ public static final @NotNull Icon InformationDialog = load("general/informationDialog.svg", 4755937775837386279L, 2);
    /** 16x16 */ public static final @NotNull Icon InheritedMethod = load("general/inheritedMethod.svg", -7317236337328768996L, 0);
    /** 16x16 */ public static final @NotNull Icon Inline_edit = load("general/inline_edit.svg", 4709424453577213411L, 0);
    /** 16x16 */ public static final @NotNull Icon Inline_edit_hovered = load("general/inline_edit_hovered.svg", 2988137314589454029L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineAdd = load("general/inlineAdd.svg", 8489137059451859895L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineAddHover = load("general/inlineAddHover.svg", -5542594245343678718L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineCopy = load("general/inlineCopy.svg", -4855094318175728694L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineCopyHover = load("general/inlineCopyHover.svg", -2988721819466634227L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineVariables = load("general/inlineVariables.svg", 8073845700601085490L, 0);
    /** 16x16 */ public static final @NotNull Icon InlineVariablesHover = load("general/inlineVariablesHover.svg", -8704262145129771018L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsError = load("general/inspectionsError.svg", -3535121862077461586L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsErrorEmpty = load("general/inspectionsErrorEmpty.svg", 11387647216617727L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsEye = load("general/inspectionsEye.svg", 987133420215082110L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsMixed = load("general/inspectionsMixed.svg", 892665075895944816L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsOK = load("general/inspectionsOK.svg", 815541511953739551L, 2);
    /** 16x17 */ public static final @NotNull Icon InspectionsOKEmpty = load("general/inspectionsOKEmpty.svg", 1892781370825832798L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsPause = load("general/inspectionsPause.svg", -3427796083793425173L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsPowerSaveMode = load("general/inspectionsPowerSaveMode.svg", -6535434752240636975L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsTrafficOff = load("general/inspectionsTrafficOff.svg", -7518723217038940423L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsTypos = load("general/inspectionsTypos.svg", 338425689313129264L, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsWarning = load("general/inspectionsWarning.svg", -5154740693456021444L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsWarningEmpty = load("general/inspectionsWarningEmpty.svg", 4759846980735283470L, 0);
    /** 16x16 */ public static final @NotNull Icon Layout = load("general/layout.svg", -621162843408662039L, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutEditorOnly = load("general/layoutEditorOnly.svg", -7231040619932830967L, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutEditorPreview = load("general/layoutEditorPreview.svg", -859496470404664277L, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutPreviewOnly = load("general/layoutPreviewOnly.svg", -8797611509612273133L, 2);
    /** 14x14 */ public static final @NotNull Icon LinkDropTriangle = load("general/linkDropTriangle.svg", 3751987927689568332L, 2);
    /** 16x16 */ public static final @NotNull Icon LocalizationSettings = load("general/localizationSettings.svg", 8118707063415821100L, 0);
    /** 16x16 */ public static final @NotNull Icon Locate = load("general/locate.svg", -3218303183886743976L, 2);
    /** 13x13 */ public static final @NotNull Icon Modified = load("general/modified.svg", 3503345716424045403L, 2);
    /** 13x13 */ public static final @NotNull Icon ModifiedSelected = load("general/modifiedSelected.svg", 8970403797972999901L, 0);
    /** 16x16 */ public static final @NotNull Icon MoreTabs = load("general/moreTabs.svg", -4666059273891250119L, 2);
    /** 16x16 */ public static final @NotNull Icon Mouse = load("general/mouse.svg", 6773436392459935344L, 2);
    /** 16x16 */ public static final @NotNull Icon Note = load("general/note.svg", 1394714677475353380L, 0);
    /** 24x24 */ public static final @NotNull Icon NotificationError = load("general/notificationError.svg", -6495747683025289034L, 2);
    /** 24x24 */ public static final @NotNull Icon NotificationInfo = load("general/notificationInfo.svg", -1106920513748051513L, 2);
    /** 24x24 */ public static final @NotNull Icon NotificationWarning = load("general/notificationWarning.svg", 1862003468311508075L, 2);
    /** 16x16 */ public static final @NotNull Icon OpenDisk = load("general/openDisk.svg", 6623757574286286551L, 0);
    /** 16x16 */ public static final @NotNull Icon OpenDiskHover = load("general/openDiskHover.svg", 4610873629549672108L, 0);
    /** 16x16 */ public static final @NotNull Icon OverridenMethod = load("general/overridenMethod.svg", -1441493775704494323L, 0);
    /** 16x16 */ public static final @NotNull Icon OverridingMethod = load("general/overridingMethod.svg", 3742709686740988416L, 0);
    /** 16x16 */ public static final @NotNull Icon Pin_tab = load("general/pin_tab.svg", 7761700865075600681L, 2);
    /** 16x16 */ public static final @NotNull Icon Print = load("general/print.svg", 473084745106679614L, 2);
    /** 9x9 */ public static final @NotNull Icon ProjectConfigurable = load("general/projectConfigurable.svg", -5428195135491798340L, 0);
    /** 16x16 */ public static final @NotNull Icon ProjectStructure = load("general/projectStructure.svg", -1251058499723841860L, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectTab = load("general/projectTab.svg", -5958907997104362345L, 0);
    /** 32x32 */ public static final @NotNull Icon QuestionDialog = load("general/questionDialog.svg", -6789648605209313700L, 2);
    /** 16x16 */ public static final @NotNull Icon ReaderMode = load("general/readerMode.svg", -2751084031984116856L, 2);
    /** 16x16 */ public static final @NotNull Icon Remove = load("general/remove.svg", 2158727271416038095L, 2);
    /** 16x16 */ public static final @NotNull Icon Reset = load("general/reset.svg", -7749819101429740384L, 2);
    /** 16x16 */ public static final @NotNull Icon RunWithCoverage = load("general/runWithCoverage.svg", 4237584546657888714L, 2);
    /** 16x16 */ public static final @NotNull Icon SeparatorH = load("general/separatorH.svg", 2558093117810328524L, 2);
    /** 16x16 */ public static final @NotNull Icon Settings = load("general/settings.svg", -6839813198922242045L, 2);
    /** 16x16 */ public static final @NotNull Icon Show_to_implement = load("general/show_to_implement.svg", 2481263200690573898L, 7);
    /** 16x16 */ public static final @NotNull Icon ShowInfos = load("general/showInfos.svg", -8166075025507201720L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowWarning = load("general/showWarning.svg", 2599959081501997207L, 2);
    /** 16x16 */ public static final @NotNull Icon TbHidden = load("general/tbHidden.svg", 197786840938530159L, 2);
    /** 16x16 */ public static final @NotNull Icon TbShown = load("general/tbShown.svg", 8714623117410639693L, 2);
    /** 32x32 */ public static final @NotNull Icon Tip = load("general/tip.svg", -1616590126773564856L, 2);
    /** 16x16 */ public static final @NotNull Icon TodoDefault = load("general/todoDefault.svg", -6679998985908400939L, 0);
    /** 16x16 */ public static final @NotNull Icon TodoImportant = load("general/todoImportant.svg", 4071827613157420132L, 0);
    /** 16x16 */ public static final @NotNull Icon TodoQuestion = load("general/todoQuestion.svg", -998896081257651016L, 0);
    /** 16x16 */ public static final @NotNull Icon Tree = load("general/tree.svg", -2075024216113450683L, 0);
    /** 16x16 */ public static final @NotNull Icon TreeHovered = load("general/treeHovered.svg", -3207966685029359517L, 0);
    /** 16x16 */ public static final @NotNull Icon TreeSelected = load("general/treeSelected.svg", 1034377141145894224L, 0);
    /** 16x16 */ public static final @NotNull Icon User = load("general/user.svg", -4532685924149411001L, 0);
    /** 16x16 */ public static final @NotNull Icon Warning = load("general/warning.svg", 3745461258866722132L, 2);
    /** 16x16 */ public static final @NotNull Icon WarningDecorator = load("general/warningDecorator.svg", -203970029791479627L, 2);
    /** 32x32 */ public static final @NotNull Icon WarningDialog = load("general/warningDialog.svg", 8389864397699662273L, 2);
    /** 16x16 */ public static final @NotNull Icon Web = load("general/web.svg", -7587749610036185795L, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomIn = load("general/zoomIn.svg", -1361553676982708278L, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomOut = load("general/zoomOut.svg", 7527136225643870797L, 2);
  }

  public static final class Graph {
    /** 16x16 */ public static final @NotNull Icon ActualZoom = load("graph/actualZoom.svg", 1709696669673525338L, 2);
    /** 16x16 */ public static final @NotNull Icon Grid = load("graph/grid.svg", 4707256906911935440L, 2);
    /** 16x16 */ public static final @NotNull Icon Layout = load("graph/layout.svg", -621162843408662039L, 2);
    /** 16x16 */ public static final @NotNull Icon NodeSelectionMode = load("graph/nodeSelectionMode.svg", 29379681383517886L, 2);
    /** 16x16 */ public static final @NotNull Icon SnapToGrid = load("graph/snapToGrid.svg", 556955019029766541L, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomIn = load("graph/zoomIn.svg", -1361553676982708278L, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomOut = load("graph/zoomOut.svg", 7527136225643870797L, 2);

    /** @deprecated to be removed in IDEA 2021.1 - use AllIcons.General.FitContent */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval(inVersion = "2021.1")
    /** 16x16 */ public static final @NotNull Icon FitContent = load("general/fitContent.svg", -8164840460982613929L, 0);
  }

  public static final class Gutter {
    /** 12x12 */ public static final @NotNull Icon Colors = load("gutter/colors.svg", 7907027332811381396L, 2);
    /** 12x12 */ public static final @NotNull Icon ExtAnnotation = load("gutter/extAnnotation.svg", 5529436789549473901L, 2);
    /** 12x12 */ public static final @NotNull Icon ImplementedMethod = load("gutter/implementedMethod.svg", -485896964582856665L, 7);
    /** 12x12 */ public static final @NotNull Icon ImplementingFunctionalInterface = load("gutter/implementingFunctionalInterface.svg", -7552777985115389464L, 2);
    /** 12x12 */ public static final @NotNull Icon ImplementingMethod = load("gutter/implementingMethod.svg", 4835522699224734684L, 7);
    /** 12x12 */ public static final @NotNull Icon Java9Service = load("gutter/java9Service.svg", -4433139201836947277L, 2);
    /** 12x12 */ public static final @NotNull Icon JavadocEdit = load("gutter/javadocEdit.svg", 8543002747211504377L, 0);
    /** 12x12 */ public static final @NotNull Icon JavadocRead = load("gutter/javadocRead.svg", 1780896158447067765L, 0);
    /** 12x12 */ public static final @NotNull Icon OverridenMethod = load("gutter/overridenMethod.svg", 488469117029776803L, 2);
    /** 12x12 */ public static final @NotNull Icon OverridingMethod = load("gutter/overridingMethod.svg", -14227646419653863L, 2);
    /** 12x12 */ public static final @NotNull Icon ReadAccess = load("gutter/readAccess.svg", 8638555485520544560L, 2);
    /** 12x12 */ public static final @NotNull Icon RecursiveMethod = load("gutter/recursiveMethod.svg", -3639120859642942039L, 2);
    /** 12x12 */ public static final @NotNull Icon SiblingInheritedMethod = load("gutter/siblingInheritedMethod.svg", -4798047915845919295L, 7);
    /** 12x12 */ public static final @NotNull Icon SuggestedRefactoringBulb = load("gutter/suggestedRefactoringBulb.svg", 8841821750324628693L, 2);
    /** 13x12 */ public static final @NotNull Icon SuggestedRefactoringBulbDisabled = load("gutter/suggestedRefactoringBulbDisabled.svg", -7745237764693981080L, 2);
    /** 8x8 */ public static final @NotNull Icon Unique = load("gutter/unique.svg", -4943893632735218805L, 2);
    /** 12x12 */ public static final @NotNull Icon WriteAccess = load("gutter/writeAccess.svg", 6088830419904472912L, 2);
  }

  public static final class Hierarchy {
    /** 16x16 */ public static final @NotNull Icon Class = load("hierarchy/class.svg", -8249935969839399816L, 2);
    /** 8x8 */ public static final @NotNull Icon MethodDefined = load("hierarchy/methodDefined.svg", 6392541364689386011L, 2);
    /** 8x8 */ public static final @NotNull Icon MethodNotDefined = load("hierarchy/methodNotDefined.svg", -4333168644532598014L, 2);
    /** 8x8 */ public static final @NotNull Icon ShouldDefineMethod = load("hierarchy/shouldDefineMethod.svg", 826649903588679173L, 2);
    /** 16x16 */ public static final @NotNull Icon Subtypes = load("hierarchy/subtypes.svg", 1355250435614456372L, 2);
    /** 16x16 */ public static final @NotNull Icon Supertypes = load("hierarchy/supertypes.svg", -7474903370009739282L, 2);
  }

  public static final class Icons {
    public static final class Ide {
      /** 12x12 */ public static final @NotNull Icon NextStep = load("icons/ide/nextStep.svg", -3704126782742584898L, 2);
      /** 12x12 */ public static final @NotNull Icon NextStepInverted = load("icons/ide/nextStepInverted.svg", 4350427522257515115L, 0);
    }
  }

  public static final class Ide {
    /** 16x16 */ public static final @NotNull Icon ConfigFile = load("ide/configFile.svg", 2139547723121889474L, 2);
    /** 6x6 */ public static final @NotNull Icon ErrorPoint = load("ide/errorPoint.svg", 3682431941242604110L, 2);
    /** 14x14 */ public static final @NotNull Icon External_link_arrow = load("ide/external_link_arrow.svg", -5822443511453233736L, 0);
    /** 16x16 */ public static final @NotNull Icon FatalErrorRead = load("ide/fatalError-read.svg", 5790644755658310603L, 2);
    /** 16x16 */ public static final @NotNull Icon FatalError = load("ide/fatalError.svg", 1491871820605864885L, 2);
    /** 16x16 */ public static final @NotNull Icon Gift = load("ide/gift.svg", 1988974160425117277L, 2);
    /** 16x16 */ public static final @NotNull Icon HectorOff = load("ide/hectorOff.svg", -5442261973014411165L, 2);
    /** 16x16 */ public static final @NotNull Icon HectorOn = load("ide/hectorOn.svg", 8875244592006865876L, 2);
    /** 16x16 */ public static final @NotNull Icon HectorSyntax = load("ide/hectorSyntax.svg", -8044165310777144926L, 2);
    /** 16x16 */ public static final @NotNull Icon IncomingChangesOn = load("ide/incomingChangesOn.svg", -8375008100917137884L, 2);
    /** 12x12 */ public static final @NotNull Icon Link = load("ide/link.svg", -2667629219323928941L, 2);
    /** 16x16 */ public static final @NotNull Icon LocalScope = load("ide/localScope.svg", 5513520975679807669L, 0);
    /** 16x16 */ public static final @NotNull Icon LocalScopeAction = load("ide/localScopeAction.svg", 353507534085850794L, 2);

    public static final class Macro {
      /** 16x16 */ public static final @NotNull Icon Recording_1 = load("ide/macro/recording_1.svg", 6344714518098305651L, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_2 = load("ide/macro/recording_2.svg", -4161246459997173250L, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_3 = load("ide/macro/recording_3.svg", 7448341762335959482L, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_4 = load("ide/macro/recording_4.svg", -6109363768389626344L, 2);
    }

    /** 5x15 */ public static final @NotNull Icon NavBarSeparator = load("ide/NavBarSeparator.svg", -7447480017785401821L, 0);

    public static final class Notification {
      /** 16x16 */ public static final @NotNull Icon Close = load("ide/notification/close.svg", 5841681451805437232L, 0);
      /** 16x16 */ public static final @NotNull Icon CloseHover = load("ide/notification/closeHover.svg", -244348318118841070L, 0);
      /** 16x16 */ public static final @NotNull Icon Collapse = load("ide/notification/collapse.svg", 7746611255720771704L, 0);
      /** 16x16 */ public static final @NotNull Icon CollapseHover = load("ide/notification/collapseHover.svg", -4835022536171090684L, 0);
      /** 16x16 */ public static final @NotNull Icon DropTriangle = load("ide/notification/dropTriangle.svg", -6691714376327690466L, 0);
      /** 16x16 */ public static final @NotNull Icon ErrorEvents = load("ide/notification/errorEvents.svg", 4348803768817904378L, 2);
      /** 16x16 */ public static final @NotNull Icon Expand = load("ide/notification/expand.svg", -9043436135375780597L, 0);
      /** 16x16 */ public static final @NotNull Icon ExpandHover = load("ide/notification/expandHover.svg", -6923529455314709892L, 0);
      /** 16x16 */ public static final @NotNull Icon Gear = load("ide/notification/gear.svg", -6517441912232259723L, 0);
      /** 16x16 */ public static final @NotNull Icon GearHover = load("ide/notification/gearHover.svg", 8529034088585467841L, 0);
      /** 16x16 */ public static final @NotNull Icon IdeUpdate = load("ide/notification/ideUpdate.svg", -5687507774382455241L, 2);
      /** 16x16 */ public static final @NotNull Icon InfoEvents = load("ide/notification/infoEvents.svg", 8320605274562923160L, 2);
      /** 16x16 */ public static final @NotNull Icon NoEvents = load("ide/notification/noEvents.svg", -5934625381114731420L, 2);
      /** 16x16 */ public static final @NotNull Icon PluginUpdate = load("ide/notification/pluginUpdate.svg", 7670193732028920558L, 2);
      /** 16x16 */ public static final @NotNull Icon WarningEvents = load("ide/notification/warningEvents.svg", -7338122458505861009L, 2);
    }

    /** 16x16 */ public static final @NotNull Icon OutgoingChangesOn = load("ide/outgoingChangesOn.svg", 2812021905179476268L, 2);
    /** 16x16 */ public static final @NotNull Icon Pipette = load("ide/pipette.svg", 5647021460333765538L, 2);
    /** 16x16 */ public static final @NotNull Icon Pipette_rollover = load("ide/pipette_rollover.svg", 3488176339572150605L, 2);
    /** 16x16 */ public static final @NotNull Icon PowerSaveMode = load("ide/powerSaveMode.svg", 6754580929919435464L, 2);
    /** 11x11 */ public static final @NotNull Icon Rating = load("ide/rating.svg", 8543078882067246571L, 2);
    /** 11x11 */ public static final @NotNull Icon Rating1 = load("ide/rating1.svg", 3658996790907164443L, 2);
    /** 11x11 */ public static final @NotNull Icon Rating2 = load("ide/rating2.svg", 5745147031241230315L, 2);
    /** 11x11 */ public static final @NotNull Icon Rating3 = load("ide/rating3.svg", -1846951936995237639L, 2);
    /** 11x11 */ public static final @NotNull Icon Rating4 = load("ide/rating4.svg", 7647079463983519848L, 2);
    /** 16x16 */ public static final @NotNull Icon Readonly = load("ide/readonly.svg", 2700193005429400356L, 2);
    /** 16x16 */ public static final @NotNull Icon Readwrite = load("ide/readwrite.svg", -8250486822642709990L, 2);

    public static final class RunAnything {
      /** 16x16 */ public static final @NotNull Icon OpenRecentProject = load("ide/runAnything/openRecentProject.svg", -2408569117220934305L, 0);
    }

    public static final class Shadow {
      /** 4x14 */ public static final @NotNull Icon Bottom = load("ide/shadow/bottom.svg", 6475016934560722687L, 0);
      /** 18x22 */ public static final @NotNull Icon BottomLeft = load("ide/shadow/bottomLeft.svg", -3585975301355576625L, 0);
      /** 18x22 */ public static final @NotNull Icon BottomRight = load("ide/shadow/bottomRight.svg", 4851950995643856475L, 0);
      /** 10x4 */ public static final @NotNull Icon Left = load("ide/shadow/left.svg", -1434515513614313116L, 0);
      /** 10x4 */ public static final @NotNull Icon Right = load("ide/shadow/right.svg", 5349488810779171132L, 0);
      /** 4x6 */ public static final @NotNull Icon Top = load("ide/shadow/top.svg", -7500268166125812980L, 0);
      /** 18x14 */ public static final @NotNull Icon TopLeft = load("ide/shadow/topLeft.svg", -1034138295646680880L, 0);
      /** 18x14 */ public static final @NotNull Icon TopRight = load("ide/shadow/topRight.svg", 4113496047436747565L, 0);
    }

    /** 7x10 */ public static final @NotNull Icon Statusbar_arrows = load("ide/statusbar_arrows.svg", -8274226850239421234L, 2);
    /** 16x16 */ public static final @NotNull Icon UpDown = load("ide/upDown.svg", -1628230695663601838L, 2);
  }

  /** 100x100 */ public static final @NotNull Icon Idea_logo_welcome = load("idea_logo_welcome.png", 0L, 0);

  public static final class Javaee {
    /** 16x16 */ public static final @NotNull Icon Home = load("javaee/home.svg", -6360039990042361499L, 1);
    /** 16x16 */ public static final @NotNull Icon PersistenceEntity = load("javaee/persistenceEntity.svg", 2082792629586375893L, 0);
    /** 16x16 */ public static final @NotNull Icon UpdateRunningApplication = load("javaee/updateRunningApplication.svg", 1690496016856050962L, 2);
    /** 16x16 */ public static final @NotNull Icon WebModuleGroup = load("javaee/webModuleGroup.svg", 3553806930485720370L, 0);
    /** 16x16 */ public static final @NotNull Icon WebService = load("javaee/WebService.svg", -1644102703872464216L, 0);
    /** 16x16 */ public static final @NotNull Icon WebServiceClient = load("javaee/WebServiceClient.svg", 8621164481989493943L, 0);
  }

  public static final class Json {
    /** 16x16 */ public static final @NotNull Icon Array = load("json/array.svg", -8075387230114765055L, 2);
    /** 16x16 */ public static final @NotNull Icon Object = load("json/object.svg", 6762922397470059523L, 2);
  }

  /** 80x80 */ public static final @NotNull Icon Logo_welcomeScreen = load("Logo_welcomeScreen.png", 0L, 1);
  /** 80x80 */ public static final @NotNull Icon Logo_welcomeScreen_CE = load("Logo_welcomeScreen_CE.png", 0L, 1);

  public static final class Mac {
    /** 55x55 */ public static final @NotNull Icon AppIconOk512 = load("mac/appIconOk512.png", 0L, 0);

    public static final class Touchbar {
      /** 16x16 */ public static final @NotNull Icon PopoverArrow = load("mac/touchbar/popoverArrow.svg", 3063414282040910129L, 0);
      /** 24x24 */ public static final @NotNull Icon PopoverClose = load("mac/touchbar/popoverClose.svg", 2652223602262799216L, 0);
    }
  }

  public static final class Modules {
    /** 16x16 */ public static final @NotNull Icon AddExcludedRoot = load("modules/addExcludedRoot.svg", -4956354231745863722L, 2);
    /** 16x16 */ public static final @NotNull Icon Annotation = load("modules/annotation.svg", 1272506338863006245L, 0);
    /** 16x16 */ public static final @NotNull Icon EditFolder = load("modules/editFolder.svg", -6473854010162989034L, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludedGeneratedRoot = load("modules/excludedGeneratedRoot.svg", 8803873925966124324L, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludeRoot = load("modules/excludeRoot.svg", -3154682451370118014L, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedFolder = load("modules/generatedFolder.svg", 8433635288847908605L, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedSourceRoot = load("modules/generatedSourceRoot.svg", -831070553133680911L, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedTestRoot = load("modules/generatedTestRoot.svg", -2156036415089274575L, 0);
    /** 16x16 */ public static final @NotNull Icon Output = load("modules/output.svg", 5147823772085656492L, 0);
    /** 16x16 */ public static final @NotNull Icon ResourcesRoot = load("modules/resourcesRoot.svg", -1673408389293535918L, 0);
    /** 16x16 */ public static final @NotNull Icon SourceRoot = load("modules/sourceRoot.svg", 3037305368987603817L, 0);
    /** 16x16 */ public static final @NotNull Icon SourceRootFileLayer = load("modules/sourceRootFileLayer.svg", 1545132019980038350L, 0);
    /** 16x16 */ public static final @NotNull Icon Split = load("modules/split.svg", 4478046199431283317L, 2);
    /** 16x16 */ public static final @NotNull Icon TestResourcesRoot = load("modules/testResourcesRoot.svg", -2468288764751128330L, 0);
    /** 16x16 */ public static final @NotNull Icon TestRoot = load("modules/testRoot.svg", -2675644273694921602L, 0);
    /** 16x16 */ public static final @NotNull Icon UnloadedModule = load("modules/unloadedModule.svg", 9105527669319256360L, 0);
    /** 16x16 */ public static final @NotNull Icon UnmarkWebroot = load("modules/unmarkWebroot.svg", -4244815248960966155L, 0);
  }

  public static final class Nodes {
    /** 16x16 */ public static final @NotNull Icon AbstractClass = load("nodes/abstractClass.svg", -2348944438276628677L, 0);
    /** 16x16 */ public static final @NotNull Icon AbstractException = load("nodes/abstractException.svg", 2796723407817839408L, 0);
    /** 16x16 */ public static final @NotNull Icon AbstractMethod = load("nodes/abstractMethod.svg", 4089286965261637346L, 1);
    /** 16x16 */ public static final @NotNull Icon Alias = load("nodes/alias.svg", 8904396147334409822L, 0);
    /** 16x16 */ public static final @NotNull Icon Annotationtype = load("nodes/annotationtype.svg", 6574283975369651245L, 0);
    /** 16x16 */ public static final @NotNull Icon AnonymousClass = load("nodes/anonymousClass.svg", -8723576184860111526L, 0);
    /** 16x16 */ public static final @NotNull Icon Artifact = load("nodes/artifact.svg", -2208635464714604545L, 0);
    /** 16x16 */ public static final @NotNull Icon Aspect = load("nodes/aspect.svg", 1892871056462314573L, 0);
    /** 16x16 */ public static final @NotNull Icon C_plocal = load("nodes/c_plocal.svg", -8410604522712496620L, 0);
    /** 16x16 */ public static final @NotNull Icon C_private = load("nodes/c_private.svg", -5938405479319936188L, 0);
    /** 16x16 */ public static final @NotNull Icon C_protected = load("nodes/c_protected.svg", 1461260788658494142L, 0);
    /** 16x16 */ public static final @NotNull Icon C_public = load("nodes/c_public.svg", 1268643335463537798L, 0);
    /** 16x16 */ public static final @NotNull Icon Class = load("nodes/class.svg", -1934784365258461135L, 0);
    /** 16x16 */ public static final @NotNull Icon ClassInitializer = load("nodes/classInitializer.svg", -3012256723361696852L, 0);
    /** 16x16 */ public static final @NotNull Icon CompiledClassesFolder = load("nodes/compiledClassesFolder.svg", 5849074834635071845L, 0);
    /** 16x16 */ public static final @NotNull Icon ConfigFolder = load("nodes/configFolder.svg", -2693523933004862623L, 0);
    /** 16x16 */ public static final @NotNull Icon Console = load("nodes/console.svg", -8378080712919798557L, 0);
    /** 16x16 */ public static final @NotNull Icon Constant = load("nodes/constant.svg", -6671067931342367387L, 0);
    /** 16x16 */ public static final @NotNull Icon Controller = load("nodes/controller.svg", 2900842008408196954L, 0);
    /** 16x16 */ public static final @NotNull Icon CopyOfFolder = load("nodes/copyOfFolder.svg", 287952053748372277L, 0);
    /** 16x16 */ public static final @NotNull Icon CustomRegion = load("nodes/customRegion.svg", 4000459118274578507L, 0);
    /** 16x16 */ public static final @NotNull Icon Cvs_global = load("nodes/cvs_global.svg", 5971001957336351L, 0);
    /** 16x16 */ public static final @NotNull Icon Cvs_roots = load("nodes/cvs_roots.svg", -6646677041098817405L, 0);
    /** 16x16 */ public static final @NotNull Icon DataColumn = load("nodes/dataColumn.svg", 3456180315085447703L, 0);
    /** 16x16 */ public static final @NotNull Icon DataSchema = load("nodes/dataSchema.svg", -4065794480771874753L, 0);
    /** 16x16 */ public static final @NotNull Icon DataTables = load("nodes/DataTables.svg", 4641149129107107037L, 0);
    /** 16x16 */ public static final @NotNull Icon Deploy = load("nodes/deploy.svg", 8338982111469212391L, 0);
    /** 16x16 */ public static final @NotNull Icon Desktop = load("nodes/desktop.svg", -7378360543485331477L, 2);
    /** 16x16 */ public static final @NotNull Icon DoneMark = load("nodes/doneMark.svg", -2963976850579617888L, 2);
    /** 16x16 */ public static final @NotNull Icon Editorconfig = load("nodes/editorconfig.svg", 6685900955220415957L, 0);
    /** 16x16 */ public static final @NotNull Icon EmptyNode = load("nodes/emptyNode.svg", -5734850937951992433L, 0);
    /** 16x16 */ public static final @NotNull Icon EnterpriseProject = load("nodes/enterpriseProject.svg", -3569309759832634777L, 0);
    /** 16x16 */ public static final @NotNull Icon EntryPoints = load("nodes/entryPoints.svg", -8616912904106554982L, 0);
    /** 16x16 */ public static final @NotNull Icon Enum = load("nodes/enum.svg", 1616267695645052955L, 1);
    /** 16x16 */ public static final @NotNull Icon ErrorIntroduction = load("nodes/errorIntroduction.svg", -8463715243658920440L, 1);
    /** 16x16 */ public static final @NotNull Icon ErrorMark = load("nodes/errorMark.svg", 7109725888488423427L, 2);
    /** 16x16 */ public static final @NotNull Icon ExceptionClass = load("nodes/exceptionClass.svg", 2391085768783517687L, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludedFromCompile = load("nodes/excludedFromCompile.svg", 7536795645551928985L, 0);
    /** 16x16 */ public static final @NotNull Icon ExtractedFolder = load("nodes/extractedFolder.svg", -8440243166719864085L, 0);
    /** 16x16 */ public static final @NotNull Icon Favorite = load("nodes/favorite.svg", -3551697779856470536L, 0);
    /** 16x16 */ public static final @NotNull Icon Field = load("nodes/field.svg", 8595851779334873320L, 0);
    /** 16x16 */ public static final @NotNull Icon FieldPK = load("nodes/fieldPK.svg", -8518406435188248486L, 0);
    /** 16x16 */ public static final @NotNull Icon FilePrivate = load("nodes/filePrivate.svg", -8059776401924334072L, 0);
    /** 16x16 */ public static final @NotNull Icon FinalMark = load("nodes/finalMark.svg", 3944797826179850063L, 0);
    /** 16x16 */ public static final @NotNull Icon Folder = load("nodes/folder.svg", 895474873403649789L, 0);
    /** 16x16 */ public static final @NotNull Icon Function = load("nodes/function.svg", -8647225230679120905L, 0);
    /** 16x16 */ public static final @NotNull Icon Gvariable = load("nodes/gvariable.svg", -1109984278112739535L, 0);
    /** 16x16 */ public static final @NotNull Icon HomeFolder = load("nodes/homeFolder.svg", -5372114244125339311L, 2);
    /** 16x16 */ public static final @NotNull Icon IdeaModule = load("nodes/ideaModule.svg", 1530451504996139245L, 0);
    /** 16x16 */ public static final @NotNull Icon IdeaProject = load("nodes/ideaProject.svg", 8863596981228513496L, 0);
    /** 16x16 */ public static final @NotNull Icon Include = load("nodes/include.svg", -7315817429386180778L, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionResults = load("nodes/inspectionResults.svg", -7691103950588031101L, 0);
    /** 16x16 */ public static final @NotNull Icon Interface = load("nodes/interface.svg", -2294953740004663339L, 1);
    /** 16x16 */ public static final @NotNull Icon J2eeParameter = load("nodes/j2eeParameter.svg", -887094412770423013L, 0);
    /** 16x16 */ public static final @NotNull Icon JarDirectory = load("nodes/jarDirectory.svg", -3121504387219727544L, 0);
    /** 16x16 */ public static final @NotNull Icon JavaDocFolder = load("nodes/javaDocFolder.svg", 3080248887854338334L, 0);
    /** 16x16 */ public static final @NotNull Icon JavaModule = load("nodes/javaModule.svg", -7640627423844623385L, 0);

    public static final class Jsf {
      /** 16x16 */ public static final @NotNull Icon Renderer = load("nodes/jsf/renderer.svg", -5058099005415064531L, 0);
    }

    /** 16x16 */ public static final @NotNull Icon JunitTestMark = load("nodes/junitTestMark.svg", 7198940865467568567L, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapAnt = load("nodes/keymapAnt.svg", -3147450677464255159L, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapEditor = load("nodes/keymapEditor.svg", 1403075943668900852L, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapMainMenu = load("nodes/keymapMainMenu.svg", -3135429408280228809L, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapOther = load("nodes/keymapOther.svg", 7866032036381443967L, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapTools = load("nodes/keymapTools.svg", -1488272916326434035L, 0);
    /** 16x16 */ public static final @NotNull Icon Lambda = load("nodes/lambda.svg", 6780899023644134742L, 0);
    /** 16x16 */ public static final @NotNull Icon Locked = load("nodes/locked.svg", 5462812123751340048L, 0);
    /** 16x16 */ public static final @NotNull Icon LogFolder = load("nodes/logFolder.svg", 6911866245808051923L, 2);
    /** 16x16 */ public static final @NotNull Icon Method = load("nodes/method.svg", -6702500286221531235L, 1);
    /** 16x16 */ public static final @NotNull Icon MethodReference = load("nodes/methodReference.svg", -8409137018771715656L, 1);
    /** 16x16 */ public static final @NotNull Icon ModelClass = load("nodes/modelClass.svg", -6173606590819401499L, 0);
    /** 16x16 */ public static final @NotNull Icon Models = load("nodes/models.svg", -7504133254451908845L, 0);
    /** 16x16 */ public static final @NotNull Icon Module = load("nodes/Module.svg", 4685978391466782938L, 0);
    /** 16x16 */ public static final @NotNull Icon ModuleGroup = load("nodes/moduleGroup.svg", -4310069809424838671L, 0);
    /** 16x16 */ public static final @NotNull Icon MultipleTypeDefinitions = load("nodes/multipleTypeDefinitions.svg", -1654390285490305394L, 0);
    /** 16x16 */ public static final @NotNull Icon NativeLibrariesFolder = load("nodes/nativeLibrariesFolder.svg", 1025506707520998711L, 0);
    /** 16x16 */ public static final @NotNull Icon NewParameter = load("nodes/newParameter.svg", -5362581251245731957L, 0);
    /** 16x16 */ public static final @NotNull Icon NodePlaceholder = load("nodes/nodePlaceholder.svg", -2404912818861765890L, 0);
    /** 16x16 */ public static final @NotNull Icon NotFavoriteOnHover = load("nodes/notFavoriteOnHover.svg", -8791487046878223221L, 0);
    /** 16x16 */ public static final @NotNull Icon ObjectTypeAttribute = load("nodes/objectTypeAttribute.svg", -5134787137439846862L, 0);
    /** 16x16 */ public static final @NotNull Icon Package = load("nodes/package.svg", -1997844758550589443L, 0);
    /** 16x16 */ public static final @NotNull Icon PackageLocal = load("nodes/packageLocal.svg", -7962491830691044389L, 0);
    /** 16x16 */ public static final @NotNull Icon Padlock = load("nodes/padlock.svg", -5755331454757882319L, 0);
    /** 16x16 */ public static final @NotNull Icon Parameter = load("nodes/parameter.svg", -3535071633034747961L, 0);
    /** 16x16 */ public static final @NotNull Icon Plugin = load("nodes/plugin.svg", 1029571518886754697L, 0);
    /** 16x16 */ public static final @NotNull Icon PluginJB = load("nodes/pluginJB.svg", 4395180531136861444L, 0);
    /** 32x32 */ public static final @NotNull Icon PluginLogo = load("nodes/pluginLogo.svg", -4298387167396923890L, 0);
    /** 16x16 */ public static final @NotNull Icon Pluginnotinstalled = load("nodes/pluginnotinstalled.svg", -4709619292555538388L, 0);
    /** 16x16 */ public static final @NotNull Icon Pluginobsolete = load("nodes/pluginobsolete.svg", 7302619933068918439L, 0);
    /** 16x16 */ public static final @NotNull Icon PluginRestart = load("nodes/pluginRestart.svg", 5889760527583669991L, 0);
    /** 16x16 */ public static final @NotNull Icon PpInvalid = load("nodes/ppInvalid.svg", 6685430581470410224L, 0);
    /** 16x16 */ public static final @NotNull Icon PpJar = load("nodes/ppJar.svg", -5525017390277553979L, 0);
    /** 16x16 */ public static final @NotNull Icon PpJdk = load("nodes/ppJdk.svg", 313992844761951439L, 0);
    /** 16x16 */ public static final @NotNull Icon PpLib = load("nodes/ppLib.svg", 3726186788272614556L, 0);
    /** 16x16 */ public static final @NotNull Icon PpLibFolder = load("nodes/ppLibFolder.svg", -723151941415486330L, 0);
    /** 16x16 */ public static final @NotNull Icon PpWeb = load("nodes/ppWeb.svg", -919003641439396121L, 0);
    /** 16x16 */ public static final @NotNull Icon Private = load("nodes/private.svg", 568138240559280258L, 0);
    /** 16x16 */ public static final @NotNull Icon ProcessMark = load("nodes/processMark.svg", 6015692990311157437L, 2);
    /** 16x16 */ public static final @NotNull Icon Project = load("nodes/project.svg", -807148155603062840L, 0);
    /** 16x16 */ public static final @NotNull Icon Property = load("nodes/property.svg", 2982883336390041435L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyRead = load("nodes/propertyRead.svg", 8658558192598610109L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadStatic = load("nodes/propertyReadStatic.svg", -5604803031767556576L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadWrite = load("nodes/propertyReadWrite.svg", 6829216142449435016L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadWriteStatic = load("nodes/propertyReadWriteStatic.svg", 9028622601461214118L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyWrite = load("nodes/propertyWrite.svg", -6234860368307694531L, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyWriteStatic = load("nodes/propertyWriteStatic.svg", 4590867970172319083L, 0);
    /** 16x16 */ public static final @NotNull Icon Protected = load("nodes/protected.svg", 4341783625540241452L, 0);
    /** 16x16 */ public static final @NotNull Icon Public = load("nodes/public.svg", -1057278009477460346L, 0);
    /** 16x16 */ public static final @NotNull Icon ReadAccess = load("nodes/read-access.svg", 2200458537789470442L, 0);
    /** 16x16 */ public static final @NotNull Icon Record = load("nodes/record.svg", -8820081207927655664L, 0);
    /** 16x16 */ public static final @NotNull Icon Related = load("nodes/related.svg", 8286601128954053548L, 0);
    /** 16x16 */ public static final @NotNull Icon ResourceBundle = load("nodes/resourceBundle.svg", 1327438418051163817L, 0);
    /** 16x16 */ public static final @NotNull Icon RunnableMark = load("nodes/runnableMark.svg", 712918329178502349L, 0);
    /** 16x16 */ public static final @NotNull Icon RwAccess = load("nodes/rw-access.svg", -2790954136544911595L, 0);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Rw_access = RwAccess;
    /** 16x16 */ public static final @NotNull Icon SecurityRole = load("nodes/securityRole.svg", -5500371977726954805L, 0);
    /** 14x12 */ public static final @NotNull Icon Services = load("nodes/services.svg", -2057777837011288462L, 0);
    /** 16x16 */ public static final @NotNull Icon Servlet = load("nodes/servlet.svg", -6853224320261092461L, 0);
    /** 16x16 */ public static final @NotNull Icon Shared = load("nodes/shared.svg", -6894260543915480253L, 0);
    /** 16x16 */ public static final @NotNull Icon SortBySeverity = load("nodes/sortBySeverity.svg", 3926891644325651337L, 2);
    /** 16x16 */ public static final @NotNull Icon Static = load("nodes/static.svg", 3532790671812413156L, 0);
    /** 16x16 */ public static final @NotNull Icon StaticMark = load("nodes/staticMark.svg", 6745670030854889852L, 0);
    /** 16x16 */ public static final @NotNull Icon Symlink = load("nodes/symlink.svg", -3443732381015515956L, 0);
    /** 16x16 */ public static final @NotNull Icon TabAlert = load("nodes/tabAlert.svg", 8852088054536349532L, 0);
    /** 16x16 */ public static final @NotNull Icon TabPin = load("nodes/tabPin.svg", -331306879234603596L, 0);
    /** 16x16 */ public static final @NotNull Icon Tag = load("nodes/tag.svg", 2359261020539071692L, 0);
    /** 16x16 */ public static final @NotNull Icon Target = load("nodes/target.svg", 7023150017288780400L, 0);
    /** 16x16 */ public static final @NotNull Icon Test = load("nodes/test.svg", -1478581045750096699L, 0);
    /** 16x16 */ public static final @NotNull Icon TestGroup = load("nodes/testGroup.svg", -5972699436199206639L, 0);
    /** 16x16 */ public static final @NotNull Icon TestIgnored = load("nodes/testIgnored.svg", 2865246914817342432L, 0);
    /** 16x16 */ public static final @NotNull Icon TestSourceFolder = load("nodes/testSourceFolder.svg", 569816119794571992L, 0);
    /** 16x16 */ public static final @NotNull Icon Toolbox = load("nodes/toolbox.svg", 5628412780227898850L, 0);
    /** 16x16 */ public static final @NotNull Icon Type = load("nodes/type.svg", 7656303628016686068L, 0);
    /** 16x16 */ public static final @NotNull Icon Undeploy = load("nodes/undeploy.svg", 5072283493892136273L, 0);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("nodes/unknown.svg", -345442756721732460L, 0);
    /** 16x16 */ public static final @NotNull Icon UnknownJdk = load("nodes/unknownJdk.svg", -8745037440512522174L, 0);
    /** 16x16 */ public static final @NotNull Icon UpFolder = load("nodes/upFolder.svg", -556580790671765696L, 0);
    /** 16x16 */ public static final @NotNull Icon UpLevel = load("nodes/upLevel.svg", -6043643513699908671L, 0);
    /** 16x16 */ public static final @NotNull Icon Variable = load("nodes/variable.svg", 2502775146900100111L, 0);
    /** 16x16 */ public static final @NotNull Icon WarningIntroduction = load("nodes/warningIntroduction.svg", -5367116530144424263L, 1);
    /** 16x16 */ public static final @NotNull Icon WarningMark = load("nodes/warningMark.svg", -4050949975123348016L, 2);
    /** 16x16 */ public static final @NotNull Icon WebFolder = load("nodes/webFolder.svg", -7948085857918090693L, 0);
    /** 16x16 */ public static final @NotNull Icon Weblistener = load("nodes/weblistener.svg", -4599964170367864680L, 0);
    /** 16x16 */ public static final @NotNull Icon WriteAccess = load("nodes/write-access.svg", 646418927005355785L, 0);

    /** @deprecated to be removed in IDEA 2021.1 - use AllIcons.General.ArrowDown */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval(inVersion = "2021.1")
    public static final @NotNull Icon TreeDownArrow = load("nodes/treeDownArrow.png", 0L, 0);

    /** @deprecated to be removed in IDEA 2021.1 - use AllIcons.General.ArrowRight */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval(inVersion = "2021.1")
    public static final @NotNull Icon TreeRightArrow = load("nodes/treeRightArrow.png", 0L, 0);
  }

  public static final class ObjectBrowser {
    /** 16x16 */ public static final @NotNull Icon AbbreviatePackageNames = load("objectBrowser/abbreviatePackageNames.svg", -2052790306910595657L, 2);
    /** 16x16 */ public static final @NotNull Icon CompactEmptyPackages = load("objectBrowser/compactEmptyPackages.svg", -2449663213383070071L, 2);
    /** 16x16 */ public static final @NotNull Icon FlattenModules = load("objectBrowser/flattenModules.svg", -2843804471316811711L, 2);
    /** 16x16 */ public static final @NotNull Icon FlattenPackages = load("objectBrowser/flattenPackages.svg", 2969930045386026467L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowLibraryContents = load("objectBrowser/showLibraryContents.svg", -2677831893526037842L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowMembers = load("objectBrowser/showMembers.svg", -3831423536514622805L, 0);
    /** 16x16 */ public static final @NotNull Icon SortByType = load("objectBrowser/sortByType.svg", 7743739740904273082L, 2);
    /** 16x16 */ public static final @NotNull Icon Sorted = load("objectBrowser/sorted.svg", -6184021115098241725L, 2);
    /** 16x16 */ public static final @NotNull Icon SortedByUsage = load("objectBrowser/sortedByUsage.svg", -3024582326396074943L, 2);
    /** 16x16 */ public static final @NotNull Icon VisibilitySort = load("objectBrowser/visibilitySort.svg", 3847011874687011908L, 2);
  }

  public static final class Plugins {
    /** 16x16 */ public static final @NotNull Icon Disabled = load("plugins/disabled.svg", 1549974329331083409L, 0);
    /** 12x12 */ public static final @NotNull Icon Downloads = load("plugins/downloads.svg", -5558854271072714700L, 2);
    /** 15x15 */ public static final @NotNull Icon ModifierInvalid = load("plugins/modifierInvalid.svg", -890103319846480834L, 2);
    /** 40x40 */ public static final @NotNull Icon PluginLogo = load("plugins/pluginLogo.svg", 7832027511472709011L, 0);
    /** 40x40 */ public static final @NotNull Icon PluginLogoDisabled = load("plugins/pluginLogoDisabled.svg", -3041544482900141067L, 0);
    /** 12x12 */ public static final @NotNull Icon Rating = load("plugins/rating.svg", -9106209893098497806L, 2);
    /** 12x12 */ public static final @NotNull Icon Updated = load("plugins/updated.svg", -5532394946450969676L, 2);
  }

  public static final class Process {
    public static final class Big {
      /** 32x32 */ public static final @NotNull Icon Step_1 = load("process/big/step_1.svg", -1503381226493946904L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_2 = load("process/big/step_2.svg", -3101798804746741990L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_3 = load("process/big/step_3.svg", 5329508833761335915L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_4 = load("process/big/step_4.svg", 7016191805438498090L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_5 = load("process/big/step_5.svg", 3564705931480292635L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_6 = load("process/big/step_6.svg", 5530740526014890810L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_7 = load("process/big/step_7.svg", 8152999826583009694L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_8 = load("process/big/step_8.svg", 2963339836128170762L, 0);
      /** 32x32 */ public static final @NotNull Icon Step_passive = load("process/big/step_passive.svg", 332985358150777441L, 0);
    }

    public static final class FS {
      /** 16x16 */ public static final @NotNull Icon Step_1 = load("process/fs/step_1.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_10 = load("process/fs/step_10.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_11 = load("process/fs/step_11.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_12 = load("process/fs/step_12.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_13 = load("process/fs/step_13.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_14 = load("process/fs/step_14.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_15 = load("process/fs/step_15.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_16 = load("process/fs/step_16.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_17 = load("process/fs/step_17.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_18 = load("process/fs/step_18.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_2 = load("process/fs/step_2.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_3 = load("process/fs/step_3.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_4 = load("process/fs/step_4.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_5 = load("process/fs/step_5.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_6 = load("process/fs/step_6.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_7 = load("process/fs/step_7.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_8 = load("process/fs/step_8.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_9 = load("process/fs/step_9.png", 0L, 7);
      /** 16x16 */ public static final @NotNull Icon Step_mask = load("process/fs/step_mask.png", 0L, 1);
      /** 16x16 */ public static final @NotNull Icon Step_passive = load("process/fs/step_passive.png", 0L, 7);
    }

    /** 14x14 */ public static final @NotNull Icon ProgressPause = load("process/progressPause.svg", 844950827513846542L, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressPauseHover = load("process/progressPauseHover.svg", 1180643322833591134L, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressPauseSmall = load("process/progressPauseSmall.svg", 6237717232957439859L, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressPauseSmallHover = load("process/progressPauseSmallHover.svg", 5307209066215910697L, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressResume = load("process/progressResume.svg", -4889371988303445433L, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressResumeHover = load("process/progressResumeHover.svg", 7959153149216595446L, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressResumeSmall = load("process/progressResumeSmall.svg", 5237253059623924279L, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressResumeSmallHover = load("process/progressResumeSmallHover.svg", -6030998144267710122L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_1 = load("process/step_1.svg", 4472887665592358936L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_2 = load("process/step_2.svg", 6955594869817142987L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_3 = load("process/step_3.svg", 4353370293697710052L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_4 = load("process/step_4.svg", 4916694833687183087L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_5 = load("process/step_5.svg", 4789735504514781748L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_6 = load("process/step_6.svg", 3047635591028345791L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_7 = load("process/step_7.svg", -2945174302915921936L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_8 = load("process/step_8.svg", -2230488838163551627L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_mask = load("process/step_mask.svg", 521307881429663932L, 0);
    /** 16x16 */ public static final @NotNull Icon Step_passive = load("process/step_passive.svg", 7536313023648328669L, 0);
    /** 14x14 */ public static final @NotNull Icon Stop = load("process/stop.svg", 8245591042745876475L, 0);
    /** 14x14 */ public static final @NotNull Icon StopHovered = load("process/stopHovered.svg", 1335074836723771892L, 0);
    /** 12x12 */ public static final @NotNull Icon StopSmall = load("process/stopSmall.svg", 4996744679609829992L, 0);
    /** 12x12 */ public static final @NotNull Icon StopSmallHovered = load("process/stopSmallHovered.svg", -7521064597237008929L, 0);
  }

  public static final class Providers {
    /** 16x16 */ public static final @NotNull Icon Apache = load("providers/apache.svg", -5934225321775094516L, 2);
    /** 16x16 */ public static final @NotNull Icon ApacheDerby = load("providers/apacheDerby.svg", -7079921244068107461L, 2);
    /** 16x16 */ public static final @NotNull Icon ApachePhoenix = load("providers/apachePhoenix.svg", 287384834647316938L, 0);
    /** 16x16 */ public static final @NotNull Icon Athena = load("providers/athena.svg", -3010672165063217069L, 0);
    /** 16x16 */ public static final @NotNull Icon Azure = load("providers/azure.svg", -4108322146501572749L, 0);
    /** 16x16 */ public static final @NotNull Icon BigQuery = load("providers/bigQuery.svg", -1485203038192915431L, 0);
    /** 16x16 */ public static final @NotNull Icon Cassandra = load("providers/cassandra.svg", -7281058075200040514L, 2);
    /** 16x16 */ public static final @NotNull Icon ClickHouse = load("providers/clickHouse.svg", 1647149862900553939L, 0);
    /** 16x16 */ public static final @NotNull Icon CockroachDB = load("providers/cockroachDB.svg", -840155423285507372L, 7);
    /** 16x16 */ public static final @NotNull Icon Couchbase = load("providers/couchbase.svg", 2362485358505666920L, 0);
    /** 16x16 */ public static final @NotNull Icon DB2 = load("providers/DB2.svg", 6413560575348587225L, 2);
    /** 16x16 */ public static final @NotNull Icon Eclipse = load("providers/eclipse.svg", 8001776984939118232L, 2);
    /** 16x16 */ public static final @NotNull Icon Elasticsearch = load("providers/elasticsearch.svg", 3950577951814466348L, 0);
    /** 16x16 */ public static final @NotNull Icon Exasol = load("providers/exasol.svg", -1472668320766890121L, 2);
    /** 16x16 */ public static final @NotNull Icon Firebird = load("providers/firebird.svg", -1150242811120149019L, 0);
    /** 16x16 */ public static final @NotNull Icon GoogleCloudSpanner = load("providers/googleCloudSpanner.svg", -3323630209325162171L, 0);
    /** 16x16 */ public static final @NotNull Icon Greenplum = load("providers/greenplum.svg", 2114952280079692584L, 0);
    /** 16x16 */ public static final @NotNull Icon H2 = load("providers/h2.svg", 6942065945738417775L, 2);
    /** 16x16 */ public static final @NotNull Icon HANA = load("providers/HANA.svg", -4405317222219393929L, 0);
    /** 16x16 */ public static final @NotNull Icon Hive = load("providers/hive.svg", 4145120119652405940L, 2);
    /** 16x16 */ public static final @NotNull Icon Hsqldb = load("providers/hsqldb.svg", -517631853275388229L, 0);
    /** 16x16 */ public static final @NotNull Icon Ibm = load("providers/ibm.svg", 8643999117649454663L, 2);
    /** 16x16 */ public static final @NotNull Icon Impala = load("providers/impala.svg", 7023351534974100583L, 2);
    /** 16x16 */ public static final @NotNull Icon Informix = load("providers/informix.svg", -8615543225570285214L, 0);
    /** 16x16 */ public static final @NotNull Icon IntersystemCache = load("providers/intersystemCache.svg", 5464778334378267767L, 2);
    /** 16x16 */ public static final @NotNull Icon Mariadb = load("providers/mariadb.svg", 3897094340920354305L, 2);
    /** 16x16 */ public static final @NotNull Icon Microsoft = load("providers/microsoft.svg", -5340043463794251127L, 0);
    /** 16x16 */ public static final @NotNull Icon MongoDB = load("providers/mongoDB.svg", 6296755881258720059L, 0);
    /** 16x16 */ public static final @NotNull Icon Mysql = load("providers/mysql.svg", -7850712015561444588L, 2);
    /** 16x16 */ public static final @NotNull Icon Netezza = load("providers/netezza.svg", -753702870144654119L, 2);
    /** 16x16 */ public static final @NotNull Icon Openedge = load("providers/openedge.svg", -4234925129624821686L, 0);
    /** 16x16 */ public static final @NotNull Icon Oracle = load("providers/oracle.svg", 4943732813650556562L, 0);
    /** 16x16 */ public static final @NotNull Icon Postgresql = load("providers/postgresql.svg", 8942378240461502503L, 2);
    /** 16x16 */ public static final @NotNull Icon Presto = load("providers/presto.svg", 4677484317865724648L, 2);
    /** 16x16 */ public static final @NotNull Icon Redshift = load("providers/redshift.svg", -8161636076303129150L, 0);
    /** 16x16 */ public static final @NotNull Icon Singlestore = load("providers/singlestore.svg", -4763079360495849532L, 0);
    /** 16x16 */ public static final @NotNull Icon Snowflake = load("providers/snowflake.svg", -511196148296774621L, 0);
    /** 16x16 */ public static final @NotNull Icon Spark = load("providers/spark.svg", 529641334744352380L, 0);
    /** 16x16 */ public static final @NotNull Icon Sqlite = load("providers/sqlite.svg", -1354077436800259360L, 2);
    /** 16x16 */ public static final @NotNull Icon SqlServer = load("providers/sqlServer.svg", 2557052360809110194L, 2);
    /** 16x16 */ public static final @NotNull Icon Sun = load("providers/sun.svg", 901999003933198963L, 2);
    /** 16x16 */ public static final @NotNull Icon Sybase = load("providers/sybase.svg", 469976759404647468L, 0);
    /** 16x16 */ public static final @NotNull Icon Tarantool = load("providers/tarantool.svg", 2749575921763625124L, 0);
    /** 16x16 */ public static final @NotNull Icon Teradata = load("providers/teradata.svg", -1965526284412460845L, 0);
    /** 16x16 */ public static final @NotNull Icon Tibero = load("providers/tibero.svg", 3743642978823178398L, 2);
    /** 16x16 */ public static final @NotNull Icon Trino = load("providers/trino.svg", 6102370661544681716L, 2);
    /** 16x16 */ public static final @NotNull Icon Vertica = load("providers/vertica.svg", -7134506734952828743L, 2);
  }

  public static final class RunConfigurations {
    /** 16x16 */ public static final @NotNull Icon Applet = load("runConfigurations/applet.svg", -6336715725240000582L, 0);
    /** 16x16 */ public static final @NotNull Icon Application = load("runConfigurations/application.svg", 437319414753545146L, 0);
    /** 16x16 */ public static final @NotNull Icon Compound = load("runConfigurations/compound.svg", -3113770077350476479L, 0);
    /** 16x16 */ public static final @NotNull Icon HidePassed = load("runConfigurations/hidePassed.svg", -1405486671199306447L, 2);
    /** 16x16 */ public static final @NotNull Icon IgnoredTest = load("runConfigurations/ignoredTest.svg", -1193335571928458539L, 2);
    /** 16x16 */ public static final @NotNull Icon InvalidConfigurationLayer = load("runConfigurations/invalidConfigurationLayer.svg", 8038403969721107963L, 0);
    /** 16x16 */ public static final @NotNull Icon Junit = load("runConfigurations/junit.svg", -3513630450071181560L, 0);
    /** 16x16 */ public static final @NotNull Icon Remote = load("runConfigurations/remote.svg", 6061692271537995208L, 2);
    /** 16x16 */ public static final @NotNull Icon RemoteDebug = load("runConfigurations/remoteDebug.svg", 2931940180745308475L, 2);
    /** 16x16 */ public static final @NotNull Icon RerunFailedTests = load("runConfigurations/rerunFailedTests.svg", -6426507070384423641L, 2);
    /** 16x16 */ public static final @NotNull Icon Scroll_down = load("runConfigurations/scroll_down.svg", -3639196916339524370L, 2);
    /** 16x16 */ public static final @NotNull Icon Scroll_up = load("runConfigurations/scroll_up.svg", 7903704837301127306L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowIgnored = load("runConfigurations/showIgnored.svg", -4002920975740649796L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowPassed = load("runConfigurations/showPassed.svg", -6720194468316776230L, 2);
    /** 16x16 */ public static final @NotNull Icon SortbyDuration = load("runConfigurations/sortbyDuration.svg", 7949917760534896820L, 2);
    /** 16x16 */ public static final @NotNull Icon TestCustom = load("runConfigurations/testCustom.svg", 4452761819291485440L, 0);
    /** 16x16 */ public static final @NotNull Icon TestError = load("runConfigurations/testError.svg", 7605043749667280097L, 0);
    /** 16x16 */ public static final @NotNull Icon TestFailed = load("runConfigurations/testFailed.svg", 8320475167995446219L, 0);
    /** 16x16 */ public static final @NotNull Icon TestIgnored = load("runConfigurations/testIgnored.svg", -3880786945254826062L, 0);
    /** 16x16 */ public static final @NotNull Icon TestMark = load("runConfigurations/testMark.svg", 7418263775746548L, 0);
    /** 16x16 */ public static final @NotNull Icon TestNotRan = load("runConfigurations/testNotRan.svg", -3058341008228908961L, 0);
    /** 16x16 */ public static final @NotNull Icon TestPassed = load("runConfigurations/testPassed.svg", 5963209671317257503L, 0);
    /** 16x16 */ public static final @NotNull Icon TestPassedIgnored = load("runConfigurations/testPassedIgnored.svg", 3318899415653448900L, 0);
    /** 16x16 */ public static final @NotNull Icon TestPaused = load("runConfigurations/testPaused.svg", -604187705248467347L, 0);
    /** 16x16 */ public static final @NotNull Icon TestSkipped = load("runConfigurations/testSkipped.svg", -4611599669274087168L, 0);

    public static final class TestState {
      /** 12x12 */ public static final @NotNull Icon Green2 = load("runConfigurations/testState/green2.svg", 4709229481707783827L, 2);
      /** 12x12 */ public static final @NotNull Icon Red2 = load("runConfigurations/testState/red2.svg", 1642961651072247214L, 2);
      /** 12x12 */ public static final @NotNull Icon Run = load("runConfigurations/testState/run.svg", -9091921151310478972L, 2);
      /** 12x12 */ public static final @NotNull Icon Run_run = load("runConfigurations/testState/run_run.svg", 1721450222197397851L, 2);
      /** 12x12 */ public static final @NotNull Icon Yellow2 = load("runConfigurations/testState/yellow2.svg", -5625519096946775047L, 2);
    }

    /** 16x16 */ public static final @NotNull Icon TestTerminated = load("runConfigurations/testTerminated.svg", 6891642865309360030L, 0);
    /** 16x16 */ public static final @NotNull Icon TestUnknown = load("runConfigurations/testUnknown.svg", -46515538644474245L, 0);
    /** 16x16 */ public static final @NotNull Icon Tomcat = load("runConfigurations/tomcat.svg", 7093334756309298686L, 0);
    /** 16x16 */ public static final @NotNull Icon ToolbarError = load("runConfigurations/toolbarError.svg", -6817600256779698615L, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarFailed = load("runConfigurations/toolbarFailed.svg", 3234271751493550958L, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarPassed = load("runConfigurations/toolbarPassed.svg", 703942595240247905L, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarSkipped = load("runConfigurations/toolbarSkipped.svg", 8814712432209818933L, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarTerminated = load("runConfigurations/toolbarTerminated.svg", 8079322802276290982L, 2);
    /** 16x16 */ public static final @NotNull Icon TrackCoverage = load("runConfigurations/trackCoverage.svg", 2810764726298036430L, 2);
    /** 16x16 */ public static final @NotNull Icon Web_app = load("runConfigurations/web_app.svg", 621257062769078294L, 0);
    /** 16x16 */ public static final @NotNull Icon Wsl = load("runConfigurations/wsl.svg", 8063630219683898459L, 2);
  }

  public static final class Scope {
    /** 16x16 */ public static final @NotNull Icon ChangedFiles = load("scope/changedFiles.svg", -5913612195948538255L, 0);
    /** 16x16 */ public static final @NotNull Icon ChangedFilesAll = load("scope/changedFilesAll.svg", -8999741777820254083L, 0);
    /** 16x16 */ public static final @NotNull Icon Problems = load("scope/problems.svg", -1642153248755538672L, 0);
    /** 16x16 */ public static final @NotNull Icon Production = load("scope/production.svg", 7159668141196837702L, 0);
    /** 16x16 */ public static final @NotNull Icon Scratches = load("scope/scratches.svg", -1621774185804989854L, 0);
    /** 16x16 */ public static final @NotNull Icon Tests = load("scope/tests.svg", 6773057492967376944L, 0);
  }

  public static final class Toolbar {
    /** 16x16 */ public static final @NotNull Icon Filterdups = load("toolbar/filterdups.svg", -2072787910408798833L, 2);
    /** 16x16 */ public static final @NotNull Icon Locale = load("toolbar/locale.svg", 3441484815021437595L, 2);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("toolbar/unknown.svg", -1073235514944118836L, 2);
    /** 16x16 */ public static final @NotNull Icon Xcode = load("toolbar/Xcode.svg", -434156538492644022L, 2);
  }

  public static final class ToolbarDecorator {
    /** 16x16 */ public static final @NotNull Icon AddBlankLine = load("toolbarDecorator/addBlankLine.svg", -4492572012075926113L, 2);
    /** 16x16 */ public static final @NotNull Icon AddClass = load("toolbarDecorator/addClass.svg", -8419007765086086759L, 2);
    /** 16x16 */ public static final @NotNull Icon AddFolder = load("toolbarDecorator/addFolder.svg", 5482785497869857100L, 2);
    /** 16x16 */ public static final @NotNull Icon AddIcon = load("toolbarDecorator/addIcon.svg", 6359346442697433179L, 2);
    /** 16x16 */ public static final @NotNull Icon AddJira = load("toolbarDecorator/addJira.svg", -4305335916241853591L, 2);
    /** 16x16 */ public static final @NotNull Icon AddLink = load("toolbarDecorator/addLink.svg", 2106505772670615045L, 2);
    /** 16x16 */ public static final @NotNull Icon AddPattern = load("toolbarDecorator/addPattern.svg", 4751801140118053666L, 2);
    /** 16x16 */ public static final @NotNull Icon AddRemoteDatasource = load("toolbarDecorator/addRemoteDatasource.svg", 3763566116070549791L, 2);
    /** 16x16 */ public static final @NotNull Icon AddYouTrack = load("toolbarDecorator/addYouTrack.svg", 2377093161188842603L, 2);
    /** 16x16 */ public static final @NotNull Icon Export = load("toolbarDecorator/export.svg", 8065738512465455387L, 2);
    /** 16x16 */ public static final @NotNull Icon Import = load("toolbarDecorator/import.svg", -2857765041263399893L, 2);
  }

  public static final class Toolwindows {
    /** 13x13 */ public static final @NotNull Icon Documentation = load("toolwindows/documentation.svg", -9014181443470293301L, 2);
    /** 13x13 */ public static final @NotNull Icon ErrorEvents = load("toolwindows/errorEvents.svg", -7676546650178371224L, 2);
    /** 13x13 */ public static final @NotNull Icon InfoEvents = load("toolwindows/infoEvents.svg", -263889416584515362L, 2);
    /** 13x13 */ public static final @NotNull Icon NoEvents = load("toolwindows/noEvents.svg", -5504420985643137627L, 2);
    /** 13x13 */ public static final @NotNull Icon Problems = load("toolwindows/problems.svg", -226223461307188800L, 2);
    /** 13x13 */ public static final @NotNull Icon ProblemsEmpty = load("toolwindows/problemsEmpty.svg", 8743835617958897286L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowAnalyzeDataflow = load("toolwindows/toolWindowAnalyzeDataflow.svg", -4551741696608876948L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowAnt = load("toolwindows/toolWindowAnt.svg", -1371233028234801963L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowBuild = load("toolwindows/toolWindowBuild.svg", 3713223205308650376L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowChanges = load("toolwindows/toolWindowChanges.svg", -499947355073527402L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCommander = load("toolwindows/toolWindowCommander.svg", -3834867719417943922L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCommit = load("toolwindows/toolWindowCommit.svg", 5248173990440427558L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCoverage = load("toolwindows/toolWindowCoverage.svg", -2720755625661908451L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowDebugger = load("toolwindows/toolWindowDebugger.svg", -3958217069239487446L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowFavorites = load("toolwindows/toolWindowFavorites.svg", 6265663296592556358L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowFind = load("toolwindows/toolWindowFind.svg", 5754354581701228611L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowHierarchy = load("toolwindows/toolWindowHierarchy.svg", -478081747606020437L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowInspection = load("toolwindows/toolWindowInspection.svg", -4167260115100983149L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowJsonPath = load("toolwindows/toolWindowJsonPath.svg", -3004991167452181001L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowMessages = load("toolwindows/toolWindowMessages.svg", 5212602638812950015L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowModuleDependencies = load("toolwindows/toolWindowModuleDependencies.svg", 676416966637667074L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowPalette = load("toolwindows/toolWindowPalette.svg", 136170054099118815L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProblems = load("toolwindows/toolWindowProblems.svg", -2371490790921518698L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProblemsEmpty = load("toolwindows/toolWindowProblemsEmpty.svg", 4726906421511547598L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProfiler = load("toolwindows/toolWindowProfiler.svg", 1670508476666319043L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProject = load("toolwindows/toolWindowProject.svg", -6511457983767332223L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowRun = load("toolwindows/toolWindowRun.svg", 302479593005695756L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowServices = load("toolwindows/toolWindowServices.svg", 6896335313344400834L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowStructure = load("toolwindows/toolWindowStructure.svg", -1843548546104419646L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowTodo = load("toolwindows/toolWindowTodo.svg", 2301783871604894941L, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowUIDesigner = load("toolwindows/toolWindowUIDesigner.svg", -2395025138451049875L, 2);
    /** 13x13 */ public static final @NotNull Icon WarningEvents = load("toolwindows/warningEvents.svg", -7560821905777442097L, 2);
    /** 13x13 */ public static final @NotNull Icon WebToolWindow = load("toolwindows/webToolWindow.svg", 4128996477882386998L, 2);
  }

  public static final class Vcs {
    /** 16x16 */ public static final @NotNull Icon Arrow_left = load("vcs/arrow_left.svg", -8245003394469570357L, 2);
    /** 16x16 */ public static final @NotNull Icon Arrow_right = load("vcs/arrow_right.svg", -8446579062948369455L, 2);
    /** 16x16 */ public static final @NotNull Icon Branch = load("vcs/branch.svg", -5782729354793781008L, 2);
    /** 16x16 */ public static final @NotNull Icon BranchNode = load("vcs/branchNode.svg", -3969124593125038797L, 0);
    /** 16x16 */ public static final @NotNull Icon Changelist = load("vcs/changelist.svg", -53663886056796354L, 2);
    /** 16x16 */ public static final @NotNull Icon Clone = load("vcs/clone.svg", -1375836334066178879L, 2);
    /** 16x16 */ public static final @NotNull Icon CommitNode = load("vcs/commitNode.svg", -1268860971233258701L, 0);
    /** 16x16 */ public static final @NotNull Icon Equal = load("vcs/equal.svg", 2918767493700488796L, 2);
    /** 16x16 */ public static final @NotNull Icon Fetch = load("vcs/fetch.svg", -7222299505873767547L, 2);
    /** 16x16 */ public static final @NotNull Icon Folders = load("vcs/folders.svg", -2499589314083663710L, 2);
    /** 24x24 */ public static final @NotNull Icon FromVCSDialog = load("vcs/fromVCSDialog.svg", -4443619065115897076L, 2);
    /** 16x16 */ public static final @NotNull Icon History = load("vcs/history.svg", 994221750501536120L, 2);
    /** 16x16 */ public static final @NotNull Icon HistoryInline = load("vcs/historyInline.svg", 285800056250404248L, 0);
    /** 16x16 */ public static final @NotNull Icon HistoryInlineHovered = load("vcs/historyInlineHovered.svg", 3359919887216090995L, 0);
    /** 16x16 */ public static final @NotNull Icon Ignore_file = load("vcs/ignore_file.svg", -983410149117430521L, 2);
    /** 16x16 */ public static final @NotNull Icon Merge = load("vcs/merge.svg", -5987765759048251753L, 2);
    /** 16x16 */ public static final @NotNull Icon Not_equal = load("vcs/not_equal.svg", -8025390501436226115L, 2);
    /** 16x16 */ public static final @NotNull Icon Patch = load("vcs/patch.svg", -5776607597895753636L, 2);
    /** 16x16 */ public static final @NotNull Icon Patch_applied = load("vcs/patch_applied.svg", -4360818050349649076L, 2);
    /** 16x16 */ public static final @NotNull Icon Patch_file = load("vcs/patch_file.svg", -371958258093870014L, 0);
    /** 16x16 */ public static final @NotNull Icon Push = load("vcs/push.svg", -5958328537355881596L, 2);
    /** 16x16 */ public static final @NotNull Icon Remove = load("vcs/remove.svg", 4704697199487087939L, 2);
    /** 16x16 */ public static final @NotNull Icon Shelve = load("vcs/Shelve.svg", 5609002214673723705L, 2);
    /** 16x16 */ public static final @NotNull Icon ShelveSilent = load("vcs/shelveSilent.svg", 8973198917890708417L, 2);
    /** 16x16 */ public static final @NotNull Icon ShowUnversionedFiles = load("vcs/ShowUnversionedFiles.svg", -2399603603685733674L, 2);
    /** 16x16 */ public static final @NotNull Icon Unshelve = load("vcs/Unshelve.svg", 8831144315568823651L, 2);
    /** 16x16 */ public static final @NotNull Icon UnshelveSilent = load("vcs/unshelveSilent.svg", -5858844056236106167L, 2);

    public static final class Vendors {
      /** 16x16 */ public static final @NotNull Icon Github = load("vcs/vendors/github.svg", 7871146368373865463L, 2);
    }
  }

  public static final class Webreferences {
    /** 16x16 */ public static final @NotNull Icon MessageQueue = load("webreferences/messageQueue.svg", -5576059522401008989L, 0);
    /** 16x16 */ public static final @NotNull Icon Server = load("webreferences/server.svg", 8270828156422174541L, 2);
    /** 16x16 */ public static final @NotNull Icon WebSocket = load("webreferences/webSocket.svg", -3304130536680505309L, 0);
  }

  public static final class Welcome {
    /** 24x24 */ public static final @NotNull Icon CreateNewProjectTab = load("welcome/createNewProjectTab.svg", -2029979631111903642L, 2);
    /** 24x24 */ public static final @NotNull Icon CreateNewProjectTabSelected = load("welcome/createNewProjectTabSelected.svg", -7868535441781786206L, 0);
    /** 24x24 */ public static final @NotNull Icon FromVCSTab = load("welcome/fromVCSTab.svg", 4794246237058055870L, 2);
    /** 24x24 */ public static final @NotNull Icon FromVCSTabSelected = load("welcome/fromVCSTabSelected.svg", 5086053682708407417L, 0);
    /** 24x24 */ public static final @NotNull Icon Open = load("welcome/open.svg", 5028281711405195387L, 2);
    /** 24x24 */ public static final @NotNull Icon OpenSelected = load("welcome/openSelected.svg", 8249926605085378617L, 0);

    public static final class Project {
      /** 10x10 */ public static final @NotNull Icon RemoveHover = load("welcome/project/remove-hover.svg", 4479333800739218809L, 2);
      /** 10x10 */ public static final @NotNull Icon Remove = load("welcome/project/remove.svg", 4810872261820866588L, 2);
      /** 10x10 */ public static final @NotNull Icon RemoveDisabledHover = load("welcome/project/removeDisabled-hover.svg", -4651697439737319257L, 2);
      /** 10x10 */ public static final @NotNull Icon RemoveDisabled = load("welcome/project/removeDisabled.svg", -2961678729624568497L, 2);
    }

    /** @deprecated to be removed in IDEA 2021.1 */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval(inVersion = "2021.1")
    public static final @NotNull Icon CreateNewProject = load("welcome/createNewProject.svg", 0L, 0);
  }

  public static final class Windows {
    /** 16x16 */ public static final @NotNull Icon CloseActive = load("windows/closeActive.svg", -1974313071992313997L, 2);
    /** 16x16 */ public static final @NotNull Icon CloseHover = load("windows/closeHover.svg", -5490994314611955165L, 0);
    /** 16x16 */ public static final @NotNull Icon CloseInactive = load("windows/closeInactive.svg", -1124865718920660136L, 2);
    /** 16x16 */ public static final @NotNull Icon CloseSmall = load("windows/closeSmall.svg", -5230674751561095528L, 2);
    /** 16x16 */ public static final @NotNull Icon Help = load("windows/help.svg", -1346027048120395489L, 2);
    /** 16x16 */ public static final @NotNull Icon HelpButton = load("windows/helpButton.svg", 7678433812164763930L, 2);
    /** 16x16 */ public static final @NotNull Icon HelpButtonInactive = load("windows/helpButtonInactive.svg", 2472508342265369039L, 2);
    /** 16x16 */ public static final @NotNull Icon HelpInactive = load("windows/helpInactive.svg", 5789901655838861564L, 2);
    /** 16x16 */ public static final @NotNull Icon Maximize = load("windows/maximize.svg", -7676502245133191693L, 2);
    /** 16x16 */ public static final @NotNull Icon MaximizeInactive = load("windows/maximizeInactive.svg", -5549459885523512191L, 2);
    /** 16x16 */ public static final @NotNull Icon MaximizeSmall = load("windows/maximizeSmall.svg", 4476700343372054577L, 2);
    /** 16x16 */ public static final @NotNull Icon Minimize = load("windows/minimize.svg", -4061739670946493118L, 2);
    /** 16x16 */ public static final @NotNull Icon MinimizeInactive = load("windows/minimizeInactive.svg", 5218753636376328649L, 2);
    /** 16x16 */ public static final @NotNull Icon MinimizeSmall = load("windows/minimizeSmall.svg", 4813341346161065245L, 2);
    /** 16x16 */ public static final @NotNull Icon Restore = load("windows/restore.svg", -1029860150282227707L, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreInactive = load("windows/restoreInactive.svg", 4673835007079302447L, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreSmall = load("windows/restoreSmall.svg", -3747750249129524340L, 2);
  }

  public static final class Xml {
    public static final class Browsers {
      /** 16x16 */ public static final @NotNull Icon Canary = load("xml/browsers/canary.svg", 7617088526970040530L, 0);
      /** 16x16 */ public static final @NotNull Icon Chrome = load("xml/browsers/chrome.svg", 952709550623130950L, 0);
      /** 16x16 */ public static final @NotNull Icon Chromium = load("xml/browsers/chromium.svg", -7081442337296232892L, 0);
      /** 16x16 */ public static final @NotNull Icon Edge = load("xml/browsers/edge.svg", 4874271553205110419L, 0);
      /** 16x16 */ public static final @NotNull Icon Explorer = load("xml/browsers/explorer.svg", -4372873914323702410L, 0);
      /** 16x16 */ public static final @NotNull Icon Firefox = load("xml/browsers/firefox.svg", 4341403554532214734L, 0);
      /** 16x16 */ public static final @NotNull Icon FirefoxDeveloper = load("xml/browsers/firefoxDeveloper.svg", 108432636050637848L, 0);
      /** 16x16 */ public static final @NotNull Icon Nwjs = load("xml/browsers/nwjs.svg", 1516966057897524993L, 0);
      /** 16x16 */ public static final @NotNull Icon Opera = load("xml/browsers/opera.svg", 5091184097709676906L, 0);
      /** 16x16 */ public static final @NotNull Icon Safari = load("xml/browsers/safari.svg", 4960499538926108019L, 0);
      /** 16x16 */ public static final @NotNull Icon Yandex = load("xml/browsers/yandex.svg", 7850811118871199617L, 0);

      /** @deprecated use {@link #Chrome} */
      @SuppressWarnings("unused")
      @Deprecated
      public static final @NotNull Icon Chrome16 = Chrome;
    }

    /** 16x16 */ public static final @NotNull Icon Css_class = load("xml/css_class.svg", 5282752036851440440L, 0);
    /** 16x16 */ public static final @NotNull Icon Html5 = load("xml/html5.svg", -965122865780144431L, 0);
    /** 16x16 */ public static final @NotNull Icon Html_id = load("xml/html_id.svg", -1523715273243254211L, 0);
  }

  /** @deprecated use ProductIcons.getInstance().getProductIcon() instead */
  @SuppressWarnings("unused")
  @Deprecated
  public static final @NotNull Icon Icon = load("icon.png", 0L, 0);
}
