/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.lang.java.lexer;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.lexer.FlexLexer;

@SuppressWarnings("ALL")

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>_JavaLexer.flex</tt>
 */
class _JavaLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [12, 6, 3]
   * Total runtime size is 14848 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>9]<<6)|((ch>>3)&0x3f)]<<3)|(ch&0x7)];
  }

  /* The ZZ_CMAP_Z table has 2176 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16\1\17\1"+
    "\20\5\21\1\22\1\23\1\24\1\21\14\25\1\26\50\25\1\27\2\25\1\30\1\31\1\32\1\33"+
    "\25\25\1\34\20\21\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\21\1\44\1\45\1\46\1"+
    "\21\1\47\2\21\1\50\4\21\1\25\1\51\1\52\5\21\2\25\1\53\31\21\1\25\1\54\1\21"+
    "\1\55\40\21\1\56\17\21\1\57\1\60\1\61\1\62\13\21\1\63\10\21\123\25\1\64\7"+
    "\25\1\65\1\66\37\21\1\25\1\66\u0582\21\1\67\u017f\21");

  /* The ZZ_CMAP_Y table has 3584 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\0\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16\4"+
    "\0\1\17\1\20\1\21\1\22\2\23\1\24\3\23\1\24\71\23\1\25\1\23\1\26\1\27\1\30"+
    "\1\31\2\27\16\0\1\32\1\17\1\33\1\34\2\23\1\35\11\23\1\36\21\23\1\37\1\40\23"+
    "\23\1\27\1\41\3\23\1\24\1\42\1\41\4\23\1\43\1\44\4\0\1\45\1\46\1\27\3\23\2"+
    "\47\1\27\1\50\1\51\1\0\1\52\5\23\1\53\3\0\1\54\1\55\13\23\1\56\1\45\1\57\1"+
    "\60\1\0\1\61\1\27\1\62\1\63\3\23\3\0\1\64\12\23\1\65\1\0\1\66\1\27\1\0\1\67"+
    "\3\23\1\53\1\70\1\22\2\23\1\65\1\71\1\72\1\73\2\27\3\23\1\74\10\27\1\75\1"+
    "\30\6\27\1\76\2\0\1\77\1\100\6\23\1\101\2\0\1\102\1\23\1\103\1\0\2\41\1\104"+
    "\1\105\1\106\2\23\1\75\1\107\1\110\1\111\1\112\1\62\1\113\1\103\1\0\1\114"+
    "\1\51\1\104\1\115\1\106\2\23\1\75\1\116\1\117\1\120\1\121\1\122\1\123\1\124"+
    "\1\0\1\125\1\27\1\104\1\36\1\35\2\23\1\75\1\126\1\110\1\45\1\127\1\130\1\27"+
    "\1\103\1\0\1\42\1\27\1\104\1\105\1\106\2\23\1\75\1\126\1\110\1\111\1\121\1"+
    "\124\1\113\1\103\1\0\1\42\1\27\1\131\1\132\1\133\1\134\1\135\1\132\1\23\1"+
    "\136\1\137\1\140\1\141\1\27\1\124\1\0\1\27\1\42\1\104\1\32\1\75\2\23\1\75"+
    "\1\142\1\143\1\144\1\140\1\145\1\26\1\103\1\0\2\27\1\146\1\32\1\75\2\23\1"+
    "\75\1\142\1\110\1\144\1\140\1\145\1\33\1\103\1\0\1\147\1\27\1\146\1\32\1\75"+
    "\4\23\1\150\1\144\1\151\1\62\1\27\1\103\1\0\1\27\1\40\1\146\1\23\1\24\1\40"+
    "\2\23\1\35\1\152\1\24\1\153\1\154\1\0\2\27\1\155\1\27\1\41\5\23\1\156\1\157"+
    "\1\160\1\77\1\0\1\161\4\27\1\162\1\163\1\164\1\41\1\165\1\166\1\156\1\167"+
    "\1\170\1\171\1\0\1\172\4\27\1\130\2\27\1\161\1\0\1\161\1\173\1\174\1\23\1"+
    "\41\3\23\1\30\1\44\1\0\1\144\1\175\1\0\1\44\3\0\1\50\1\176\7\27\5\23\1\53"+
    "\1\0\1\177\1\0\1\161\1\65\1\200\1\201\1\202\1\203\1\23\1\204\1\205\1\0\1\171"+
    "\4\23\1\36\1\21\5\23\1\206\51\23\1\133\1\24\1\133\5\23\1\133\4\23\1\133\1"+
    "\24\1\133\1\23\1\24\7\23\1\133\10\23\1\207\4\27\2\23\2\27\12\23\1\30\1\27"+
    "\1\41\114\23\1\105\2\23\1\41\2\23\1\47\11\23\1\132\1\130\1\27\1\23\1\32\1"+
    "\210\1\27\2\23\1\210\1\27\2\23\1\211\1\27\1\23\1\32\1\212\1\27\6\23\1\213"+
    "\3\0\1\214\1\215\1\0\1\161\3\27\1\216\1\0\1\161\13\23\1\27\5\23\1\217\10\23"+
    "\1\220\1\27\3\23\1\30\1\0\1\2\1\0\1\2\1\124\1\0\3\23\1\220\1\30\1\27\5\23"+
    "\1\114\2\0\1\55\1\161\1\0\1\161\4\27\2\23\1\160\1\2\6\23\1\175\1\77\3\0\1"+
    "\111\1\0\1\161\1\0\1\161\1\43\13\27\1\221\5\23\1\213\1\0\1\221\1\114\1\0\1"+
    "\161\1\27\1\222\1\2\1\27\1\223\3\23\1\102\1\202\1\0\1\67\4\23\1\65\1\0\1\2"+
    "\1\27\4\23\1\213\2\0\1\27\1\0\1\224\1\0\1\67\3\23\1\220\12\27\1\225\2\0\1"+
    "\226\1\227\1\27\30\23\4\0\1\77\2\27\1\76\42\23\2\220\4\23\2\220\1\23\1\230"+
    "\3\23\1\220\6\23\1\32\1\170\1\231\1\30\1\232\1\114\1\23\1\30\1\231\1\30\1"+
    "\27\1\222\3\27\1\233\1\27\1\43\1\130\1\27\1\234\1\27\1\50\1\235\1\42\1\43"+
    "\2\27\1\23\1\30\3\23\1\47\2\27\1\0\1\50\1\236\1\0\1\237\1\27\1\240\1\40\1"+
    "\152\1\241\1\31\1\242\1\23\1\243\1\244\1\245\2\27\5\23\1\130\116\27\5\23\1"+
    "\24\5\23\1\24\20\23\1\30\1\246\1\247\1\27\4\23\1\36\1\21\7\23\1\43\1\27\1"+
    "\62\2\23\1\24\1\27\10\24\4\0\5\27\1\43\72\27\1\244\3\27\1\41\1\204\1\241\1"+
    "\30\1\41\11\23\1\24\1\250\1\41\12\23\1\206\1\244\4\23\1\220\1\41\12\23\1\24"+
    "\2\27\3\23\1\47\6\27\170\23\1\220\11\27\71\23\1\30\6\27\21\23\1\30\10\27\5"+
    "\23\1\220\41\23\1\30\2\23\1\0\1\247\2\27\5\23\1\160\1\76\1\251\3\23\1\62\12"+
    "\23\1\161\3\27\1\43\1\23\1\40\14\23\1\252\1\114\1\27\1\23\1\47\11\27\1\23"+
    "\1\253\1\254\2\23\1\53\2\27\1\130\6\23\1\114\1\27\1\67\5\23\1\213\1\0\1\50"+
    "\1\27\1\0\1\161\2\0\1\67\1\51\1\0\1\67\2\23\1\65\1\171\2\23\1\160\1\0\1\2"+
    "\1\27\3\23\1\30\1\100\5\23\1\53\1\0\1\237\1\43\1\0\1\161\4\27\5\23\1\102\1"+
    "\77\1\27\1\254\1\255\1\0\1\161\2\23\1\24\1\256\6\23\1\201\1\257\1\217\2\27"+
    "\1\260\1\23\1\53\1\261\1\27\3\262\1\27\2\24\22\27\4\23\1\53\1\263\1\0\1\161"+
    "\64\23\1\114\1\27\2\23\1\24\1\264\5\23\1\114\40\27\55\23\1\220\15\23\1\26"+
    "\4\27\1\24\1\27\1\264\1\265\1\23\1\75\1\24\1\170\1\266\15\23\1\26\3\27\1\264"+
    "\54\23\1\220\2\27\10\23\1\40\6\23\5\27\1\23\1\30\2\0\2\27\1\77\1\27\1\135"+
    "\2\27\1\244\3\27\1\42\1\32\20\23\1\267\1\234\1\27\1\0\1\161\1\41\2\23\1\115"+
    "\1\41\2\23\1\47\1\270\12\23\1\24\3\40\1\271\1\272\2\27\1\273\1\23\1\142\2"+
    "\23\1\24\2\23\1\274\1\23\1\220\1\23\1\220\4\27\17\23\1\47\10\27\6\23\1\30"+
    "\20\27\1\275\20\27\3\23\1\30\6\23\1\130\5\27\3\23\1\24\2\27\3\23\1\47\6\27"+
    "\3\23\1\220\4\23\1\114\1\23\1\241\5\27\23\23\1\220\1\0\1\161\52\27\1\220\1"+
    "\75\4\23\1\36\1\276\2\23\1\220\25\27\2\23\1\220\1\27\3\23\1\26\10\27\7\23"+
    "\1\270\10\27\1\277\1\76\1\142\1\41\2\23\1\114\1\120\4\27\3\23\1\30\20\27\6"+
    "\23\1\220\1\27\2\23\1\220\1\27\2\23\1\47\21\27\11\23\1\130\66\27\1\223\6\23"+
    "\1\0\1\77\3\27\1\124\1\0\2\27\1\223\5\23\1\0\1\300\2\27\3\23\1\130\1\0\1\161"+
    "\1\223\3\23\1\160\1\0\1\144\1\0\10\27\1\223\5\23\1\53\1\0\1\301\1\27\1\0\1"+
    "\161\24\27\5\23\1\53\1\0\1\27\1\0\1\161\46\27\55\23\1\24\22\27\14\23\1\47"+
    "\63\27\5\23\1\24\72\27\7\23\1\130\130\27\10\23\1\30\1\27\1\102\4\0\1\77\1"+
    "\27\1\62\1\223\1\23\14\27\1\26\153\27\1\302\1\303\2\0\1\304\1\2\3\27\1\305"+
    "\22\27\1\306\67\27\12\23\1\32\10\23\1\32\1\307\1\310\1\23\1\311\1\142\7\23"+
    "\1\36\1\312\2\32\3\23\1\313\1\170\1\40\1\75\51\23\1\220\3\23\1\75\2\23\1\206"+
    "\3\23\1\206\2\23\1\32\3\23\1\32\2\23\1\24\3\23\1\24\3\23\1\75\3\23\1\75\2"+
    "\23\1\206\1\314\6\0\1\142\3\23\1\162\1\41\1\206\1\315\1\240\1\316\1\162\1"+
    "\230\1\162\2\206\1\123\1\23\1\35\1\23\1\114\1\317\1\35\1\23\1\114\50\27\32"+
    "\23\1\24\5\27\106\23\1\30\1\27\33\23\1\220\74\27\1\122\3\27\14\0\20\27\36"+
    "\0\2\27");

  /* The ZZ_CMAP_A table has 1664 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\2\5\0\6\2\5\0\1\51\2\0\1\1\1\62\1\56\1\0\1\63\1\64\1\57\1\53\1\72\1\16"+
    "\1\14\1\60\1\7\11\3\1\75\1\71\1\54\1\50\1\55\1\74\1\76\1\5\1\11\1\5\1\13\1"+
    "\15\1\12\5\1\1\6\3\1\1\17\7\1\1\10\2\1\1\67\1\0\1\70\1\61\1\4\1\0\1\25\1\31"+
    "\1\32\1\40\1\23\1\24\1\43\1\36\1\37\1\1\1\34\1\26\1\41\1\30\1\33\1\44\1\1"+
    "\1\21\1\27\1\20\1\22\1\45\1\46\1\42\1\35\1\47\1\65\1\52\1\66\1\73\1\2\2\0"+
    "\4\1\4\0\1\1\2\0\1\2\7\0\1\1\4\0\1\1\5\0\17\1\1\0\2\1\4\0\4\1\16\0\5\1\7\0"+
    "\1\1\1\0\1\1\1\0\5\1\1\0\2\1\6\0\1\1\1\0\3\1\1\0\1\1\1\0\4\1\1\0\13\1\1\0"+
    "\3\1\1\0\5\2\2\0\6\1\1\0\7\1\1\0\1\1\15\0\1\1\1\0\15\2\1\0\1\2\1\0\2\2\1\0"+
    "\2\2\1\0\1\2\3\1\5\0\5\2\6\0\1\1\4\0\3\2\5\0\3\1\7\2\4\0\2\1\1\2\13\1\1\0"+
    "\1\1\7\2\2\1\2\2\1\0\4\2\2\1\2\2\3\1\2\0\1\1\7\0\1\2\1\1\1\2\6\1\3\2\2\0\11"+
    "\1\3\2\1\1\6\0\2\2\6\1\4\2\2\1\2\0\2\2\1\1\11\2\1\1\3\2\1\1\5\2\2\0\1\1\3"+
    "\2\4\0\1\1\1\0\6\1\4\0\13\2\1\0\4\2\6\1\3\2\1\1\2\2\1\1\7\2\2\1\2\2\2\0\2"+
    "\2\1\0\3\2\1\0\10\1\2\0\2\1\2\0\6\1\1\0\1\1\3\0\4\1\2\0\1\2\1\1\7\2\2\0\2"+
    "\2\2\0\3\2\1\1\5\0\2\1\1\0\5\1\4\0\3\1\4\0\2\1\1\0\2\1\1\0\2\1\1\0\2\1\2\0"+
    "\1\2\1\0\5\2\4\0\2\2\2\0\3\2\3\0\1\2\7\0\4\1\1\0\1\1\7\0\4\2\3\1\1\2\2\0\1"+
    "\1\1\0\2\1\1\0\3\1\2\2\1\0\3\2\2\0\1\1\11\0\1\2\1\1\1\0\6\1\3\0\3\1\1\0\4"+
    "\1\3\0\2\1\1\0\1\1\1\0\2\1\3\0\2\1\3\0\2\1\4\0\5\2\3\0\3\2\1\0\4\2\2\0\1\1"+
    "\6\0\1\2\4\1\1\0\5\1\3\0\1\1\7\2\1\0\2\2\5\0\2\2\3\0\2\2\1\0\3\1\1\0\2\1\5"+
    "\0\3\1\2\0\1\1\3\2\1\0\4\2\1\1\1\0\4\1\1\0\1\1\4\0\1\2\4\0\6\2\1\0\1\2\3\0"+
    "\2\2\4\0\1\1\1\2\2\1\7\2\4\0\10\1\3\2\7\0\2\1\1\0\1\1\2\0\2\1\1\0\1\1\2\0"+
    "\1\1\6\0\4\1\1\0\3\1\1\0\1\1\1\0\1\1\2\0\2\1\1\0\3\1\2\2\1\0\2\2\1\1\2\0\5"+
    "\1\1\0\1\1\1\0\6\2\2\0\2\2\2\0\4\1\5\0\1\2\1\0\1\2\1\0\1\2\4\0\2\2\5\1\3\2"+
    "\6\0\1\2\1\0\7\2\1\1\2\2\4\1\3\2\1\1\3\2\2\1\7\2\3\1\4\2\5\1\14\2\1\1\1\2"+
    "\3\1\1\0\7\1\2\0\3\2\2\1\3\2\3\0\2\1\2\2\4\0\1\1\1\0\2\2\4\0\4\1\10\2\3\0"+
    "\1\1\3\0\2\1\1\2\5\0\3\2\2\0\1\1\1\2\1\1\5\0\6\1\2\0\5\2\3\1\3\0\10\2\5\1"+
    "\2\2\3\0\3\1\3\2\1\0\5\2\4\1\1\2\4\1\3\2\2\1\2\0\1\1\1\0\1\1\1\0\1\1\1\0\1"+
    "\1\2\0\3\1\1\0\6\1\2\0\2\1\2\0\5\2\5\0\1\1\5\0\6\2\1\0\1\2\3\0\4\2\11\0\1"+
    "\1\4\0\1\1\1\0\5\1\2\0\1\1\1\0\4\1\1\0\3\1\2\0\4\1\5\0\5\1\4\0\1\1\4\0\4\1"+
    "\3\2\2\1\5\0\2\2\2\0\3\1\6\2\1\0\2\1\2\0\4\1\1\0\2\1\1\2\3\1\1\2\4\1\1\2\10"+
    "\1\2\2\4\0\1\1\1\2\4\0\1\2\5\1\2\2\3\0\3\1\4\0\3\1\2\2\2\0\6\1\1\0\3\2\1\0"+
    "\2\2\5\0\5\1\5\0\1\1\1\2\3\1\1\0\2\1\1\0\7\1\2\0\1\2\6\0\2\1\2\0\3\1\3\0\2"+
    "\1\3\0\2\1\2\0\3\2\4\0\3\1\1\0\2\1\1\0\1\1\5\0\1\2\2\0\1\1\3\0\1\1\2\0\2\1"+
    "\3\2\1\0\2\2\1\0\3\2\2\0\1\2\2\0\1\2\4\1\10\0\5\2\3\0\6\2\2\0\3\2\2\0\4\2"+
    "\4\0\3\2\5\0\1\1\2\0\2\1\2\0\4\1\1\0\4\1\1\0\1\1\1\0\6\1\2\0\5\1\1\0\4\1\1"+
    "\0\4\1\2\0\2\2\1\0\1\1\1\0\1\1\5\0\1\1\1\0\1\1\1\0\3\1\1\0\3\1\1\0\3\1");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\2\3\1\4\1\5\20\2\1\6"+
    "\1\7\1\10\1\11\1\12\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\3\37\2\3\1\0\1\40\1\41\1\42\34\2\1\43"+
    "\3\2\1\44\6\2\1\45\1\46\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\37\1\3\1\0\1\64\2\2\1\65"+
    "\10\2\1\66\13\2\1\67\11\2\1\70\14\2\1\71"+
    "\1\0\1\72\2\2\1\73\1\2\1\74\1\75\6\2"+
    "\1\76\6\2\1\77\3\2\1\100\1\2\1\101\3\2"+
    "\1\102\6\2\1\103\5\2\1\104\2\2\1\105\2\2"+
    "\1\106\1\107\1\110\4\2\1\111\1\2\1\112\2\2"+
    "\1\113\1\2\1\114\1\115\1\2\1\116\13\2\1\117"+
    "\1\2\1\120\1\121\2\2\1\122\2\2\1\123\1\2"+
    "\1\124\1\125\5\2\1\126\1\2\1\127\2\2\1\130"+
    "\3\2\1\131\1\132\3\2\1\133\4\2\1\134\1\2"+
    "\1\135\1\136\2\2\1\137\1\140\1\2\1\141\4\2"+
    "\1\142\1\143\1\2\1\144\2\2\1\145\1\2\1\146"+
    "\1\147\1\2\1\150";

  private static int [] zzUnpackAction() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\374\0\u013b\0\u017a\0\u01b9"+
    "\0\u01f8\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333\0\u0372\0\u03b1"+
    "\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b\0\u056a\0\u05a9"+
    "\0\u05e8\0\u0627\0\u0666\0\u06a5\0\77\0\u06e4\0\u0723\0\u0762"+
    "\0\u07a1\0\u07e0\0\77\0\77\0\77\0\77\0\77\0\77"+
    "\0\77\0\77\0\77\0\77\0\u081f\0\77\0\77\0\77"+
    "\0\77\0\u085e\0\u089d\0\u08dc\0\u091b\0\u095a\0\77\0\77"+
    "\0\77\0\u0999\0\u09d8\0\u0a17\0\u0a56\0\u0a95\0\u0ad4\0\u0b13"+
    "\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f\0\u0c4e\0\u0c8d\0\u0ccc\0\u0d0b"+
    "\0\u0d4a\0\u0d89\0\u0dc8\0\u0e07\0\u0e46\0\u0e85\0\u0ec4\0\u0f03"+
    "\0\u0f42\0\u0f81\0\u0fc0\0\u0fff\0\u103e\0\176\0\u107d\0\u10bc"+
    "\0\u10fb\0\u113a\0\u1179\0\u11b8\0\u11f7\0\u1236\0\u1275\0\u12b4"+
    "\0\77\0\77\0\77\0\77\0\77\0\77\0\77\0\u12f3"+
    "\0\77\0\77\0\77\0\77\0\77\0\77\0\77\0\u1332"+
    "\0\u1371\0\u13b0\0\77\0\u13ef\0\u142e\0\176\0\u146d\0\u14ac"+
    "\0\u14eb\0\u152a\0\u1569\0\u15a8\0\u15e7\0\u1626\0\176\0\u1665"+
    "\0\u16a4\0\u16e3\0\u1722\0\u1761\0\u17a0\0\u17df\0\u181e\0\u185d"+
    "\0\u189c\0\u18db\0\176\0\u191a\0\u1959\0\u1998\0\u19d7\0\u1a16"+
    "\0\u1a55\0\u1a94\0\u1ad3\0\u1b12\0\u1b51\0\u1b90\0\u1bcf\0\u1c0e"+
    "\0\u1c4d\0\u1c8c\0\u1ccb\0\u1d0a\0\u1d49\0\u1d88\0\u1dc7\0\u1e06"+
    "\0\u1e45\0\77\0\u1e84\0\176\0\u1ec3\0\u1f02\0\176\0\u1f41"+
    "\0\176\0\176\0\u1f80\0\u1fbf\0\u1ffe\0\u203d\0\u207c\0\u20bb"+
    "\0\176\0\u20fa\0\u2139\0\u2178\0\u21b7\0\u21f6\0\u2235\0\176"+
    "\0\u2274\0\u22b3\0\u22f2\0\176\0\u2331\0\176\0\u2370\0\u23af"+
    "\0\u23ee\0\176\0\u242d\0\u246c\0\u24ab\0\u24ea\0\u2529\0\u2568"+
    "\0\176\0\u25a7\0\u25e6\0\u2625\0\u2664\0\u26a3\0\176\0\u26e2"+
    "\0\u2721\0\u2760\0\u279f\0\u27de\0\176\0\176\0\u281d\0\u285c"+
    "\0\u289b\0\u28da\0\u2919\0\176\0\u2958\0\176\0\u2997\0\u29d6"+
    "\0\176\0\u2a15\0\176\0\176\0\u2a54\0\176\0\u2a93\0\u2ad2"+
    "\0\u2b11\0\u2b50\0\u2b8f\0\u2bce\0\u2c0d\0\u2c4c\0\u2c8b\0\u2cca"+
    "\0\u2d09\0\176\0\u2d48\0\176\0\176\0\u2d87\0\u2dc6\0\176"+
    "\0\u2e05\0\u2e44\0\176\0\u2e83\0\176\0\176\0\u2ec2\0\u2f01"+
    "\0\u2f40\0\u2f7f\0\u2fbe\0\176\0\u2ffd\0\176\0\u303c\0\u307b"+
    "\0\176\0\u30ba\0\u30f9\0\u3138\0\176\0\176\0\u3177\0\u31b6"+
    "\0\u31f5\0\176\0\u3234\0\u3273\0\u32b2\0\u32f1\0\176\0\u3330"+
    "\0\176\0\176\0\u336f\0\u33ae\0\176\0\176\0\u33ed\0\176"+
    "\0\u342c\0\u346b\0\u34aa\0\u34e9\0\176\0\176\0\u3528\0\176"+
    "\0\u3567\0\u35a6\0\176\0\u35e5\0\176\0\176\0\u3624\0\176";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\2\1\4\3\3\1\5\4\3\1\6"+
    "\1\3\1\7\1\3\1\10\1\11\1\3\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\4\3\1\22"+
    "\1\23\2\3\1\24\1\25\1\26\1\27\1\3\1\30"+
    "\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
    "\1\41\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\54\1\55\1\56\100\0\13\3"+
    "\1\0\1\3\1\0\31\3\32\0\2\4\1\0\1\57"+
    "\1\4\2\0\1\60\1\61\1\62\1\63\5\0\1\63"+
    "\1\60\1\0\1\57\11\0\1\61\41\0\2\4\1\0"+
    "\1\57\1\4\1\64\1\65\1\60\1\61\1\62\1\63"+
    "\5\0\1\63\1\60\1\0\1\57\2\0\1\65\6\0"+
    "\1\61\1\0\1\64\37\0\1\62\3\0\1\62\4\0"+
    "\1\66\100\0\1\67\31\0\1\70\4\0\1\71\22\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\72\14\3\1\73"+
    "\11\3\30\0\13\3\1\0\1\3\1\0\4\3\1\74"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\7\3\1\75"+
    "\1\3\1\76\11\3\1\77\5\3\30\0\13\3\1\0"+
    "\1\3\1\0\6\3\1\100\1\101\4\3\1\102\3\3"+
    "\1\103\10\3\30\0\13\3\1\0\1\3\1\0\10\3"+
    "\1\104\1\3\1\105\16\3\30\0\13\3\1\0\1\3"+
    "\1\0\14\3\1\106\14\3\30\0\13\3\1\0\1\3"+
    "\1\0\1\3\1\107\1\3\1\110\12\3\1\111\1\112"+
    "\7\3\1\113\1\3\30\0\13\3\1\0\1\3\1\0"+
    "\3\3\1\114\1\115\1\3\1\116\22\3\30\0\13\3"+
    "\1\0\1\3\1\0\2\3\1\117\11\3\1\120\1\3"+
    "\1\121\12\3\30\0\13\3\1\0\1\3\1\0\6\3"+
    "\1\122\1\123\4\3\1\124\2\3\1\125\11\3\30\0"+
    "\13\3\1\0\1\3\1\0\5\3\1\126\3\3\1\127"+
    "\10\3\1\130\6\3\30\0\13\3\1\0\1\3\1\0"+
    "\4\3\1\131\7\3\1\132\14\3\30\0\13\3\1\0"+
    "\1\3\1\0\14\3\1\133\14\3\30\0\13\3\1\0"+
    "\1\3\1\0\2\3\1\134\1\135\2\3\1\136\22\3"+
    "\30\0\13\3\1\0\1\3\1\0\14\3\1\137\14\3"+
    "\30\0\13\3\1\0\1\3\1\0\17\3\1\140\11\3"+
    "\77\0\1\141\76\0\1\142\76\0\1\143\1\0\1\144"+
    "\74\0\1\145\2\0\1\146\73\0\1\147\3\0\1\150"+
    "\72\0\1\151\5\0\1\152\70\0\1\153\76\0\1\154"+
    "\76\0\1\155\76\0\1\156\123\0\1\157\4\0\2\62"+
    "\2\0\1\62\2\0\1\60\1\61\1\0\1\63\5\0"+
    "\1\63\1\60\13\0\1\61\41\0\2\160\2\0\1\160"+
    "\2\0\1\60\1\61\2\0\1\160\5\0\1\60\13\0"+
    "\1\61\12\0\1\160\26\0\3\161\1\57\1\161\1\0"+
    "\3\161\1\162\1\161\5\0\3\161\1\57\2\0\2\161"+
    "\5\0\1\161\41\0\2\65\1\0\1\57\1\65\16\0"+
    "\1\57\64\0\1\163\63\0\13\3\1\0\1\3\1\0"+
    "\3\3\1\164\2\3\1\165\7\3\1\166\12\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\167\15\3\1\170"+
    "\10\3\30\0\13\3\1\0\1\3\1\0\1\3\1\171"+
    "\27\3\30\0\13\3\1\0\1\3\1\0\10\3\1\172"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\3\3\1\173"+
    "\25\3\30\0\13\3\1\0\1\3\1\0\1\3\1\174"+
    "\27\3\30\0\13\3\1\0\1\3\1\0\7\3\1\175"+
    "\21\3\30\0\13\3\1\0\1\3\1\0\14\3\1\176"+
    "\14\3\30\0\13\3\1\0\1\3\1\0\2\3\1\177"+
    "\26\3\30\0\13\3\1\0\1\3\1\0\11\3\1\200"+
    "\17\3\30\0\13\3\1\0\1\3\1\0\10\3\1\201"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\10\3\1\202"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\11\3\1\203"+
    "\17\3\30\0\13\3\1\0\1\3\1\0\2\3\1\204"+
    "\3\3\1\205\22\3\30\0\13\3\1\0\1\3\1\0"+
    "\25\3\1\206\3\3\30\0\13\3\1\0\1\3\1\0"+
    "\11\3\1\207\17\3\30\0\13\3\1\0\1\3\1\0"+
    "\14\3\1\210\14\3\30\0\13\3\1\0\1\3\1\0"+
    "\20\3\1\211\10\3\30\0\13\3\1\0\1\3\1\0"+
    "\7\3\1\212\21\3\30\0\13\3\1\0\1\3\1\0"+
    "\27\3\1\213\1\3\30\0\13\3\1\0\1\3\1\0"+
    "\1\3\1\214\27\3\30\0\13\3\1\0\1\3\1\0"+
    "\4\3\1\215\24\3\30\0\13\3\1\0\1\3\1\0"+
    "\14\3\1\216\14\3\30\0\13\3\1\0\1\3\1\0"+
    "\1\3\1\217\27\3\30\0\13\3\1\0\1\3\1\0"+
    "\1\3\1\220\6\3\1\221\20\3\30\0\13\3\1\0"+
    "\1\3\1\0\6\3\1\222\22\3\30\0\13\3\1\0"+
    "\1\3\1\0\11\3\1\223\17\3\30\0\13\3\1\0"+
    "\1\3\1\0\6\3\1\224\22\3\30\0\13\3\1\0"+
    "\1\3\1\0\1\3\1\225\6\3\1\226\20\3\30\0"+
    "\13\3\1\0\1\3\1\0\25\3\1\227\3\3\30\0"+
    "\13\3\1\0\1\3\1\0\5\3\1\230\23\3\30\0"+
    "\13\3\1\0\1\3\1\0\3\3\1\231\25\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\232\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\14\3\1\233\3\3\1\234"+
    "\10\3\30\0\13\3\1\0\1\3\1\0\12\3\1\235"+
    "\16\3\30\0\13\3\1\0\1\3\1\0\13\3\1\236"+
    "\15\3\30\0\13\3\1\0\1\3\1\0\7\3\1\237"+
    "\10\3\1\240\10\3\30\0\13\3\1\0\1\3\1\0"+
    "\20\3\1\241\10\3\77\0\1\242\31\0\2\160\2\0"+
    "\1\160\2\0\1\60\1\61\10\0\1\60\13\0\1\61"+
    "\41\0\3\161\1\57\1\161\1\0\3\161\1\243\1\161"+
    "\1\0\1\63\3\0\3\161\1\57\2\0\2\161\5\0"+
    "\1\161\3\0\1\63\35\0\3\243\1\0\1\243\1\0"+
    "\3\243\1\0\1\243\5\0\3\243\3\0\2\243\5\0"+
    "\1\243\37\0\13\3\1\0\1\3\1\0\4\3\1\244"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\11\3\1\245"+
    "\17\3\30\0\13\3\1\0\1\3\1\0\14\3\1\246"+
    "\14\3\30\0\13\3\1\0\1\3\1\0\10\3\1\247"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\3\3\1\250"+
    "\25\3\30\0\13\3\1\0\1\3\1\0\4\3\1\251"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\22\3\1\252"+
    "\6\3\30\0\13\3\1\0\1\3\1\0\4\3\1\253"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\10\3\1\254"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\6\3\1\255"+
    "\22\3\30\0\13\3\1\0\1\3\1\0\6\3\1\256"+
    "\22\3\30\0\13\3\1\0\1\3\1\0\4\3\1\257"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\1\3\1\260"+
    "\27\3\30\0\13\3\1\0\1\3\1\0\24\3\1\261"+
    "\4\3\30\0\13\3\1\0\1\3\1\0\20\3\1\262"+
    "\10\3\30\0\13\3\1\0\1\3\1\0\1\3\1\263"+
    "\27\3\30\0\13\3\1\0\1\3\1\0\4\3\1\264"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\13\3\1\265"+
    "\15\3\30\0\13\3\1\0\1\3\1\0\2\3\1\266"+
    "\26\3\30\0\13\3\1\0\1\3\1\0\1\3\1\267"+
    "\27\3\30\0\13\3\1\0\1\3\1\0\7\3\1\270"+
    "\21\3\30\0\13\3\1\0\1\3\1\0\20\3\1\271"+
    "\10\3\30\0\13\3\1\0\1\3\1\0\6\3\1\272"+
    "\22\3\30\0\13\3\1\0\1\3\1\0\7\3\1\273"+
    "\21\3\30\0\13\3\1\0\1\3\1\0\4\3\1\274"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\13\3\1\275"+
    "\15\3\30\0\13\3\1\0\1\3\1\0\4\3\1\276"+
    "\24\3\30\0\13\3\1\0\1\3\1\0\10\3\1\277"+
    "\20\3\30\0\13\3\1\0\1\3\1\0\1\3\1\300"+
    "\6\3\1\301\20\3\30\0\13\3\1\0\1\3\1\0"+
    "\2\3\1\302\26\3\30\0\13\3\1\0\1\3\1\0"+
    "\4\3\1\303\24\3\30\0\13\3\1\0\1\3\1\0"+
    "\1\3\1\304\27\3\30\0\13\3\1\0\1\3\1\0"+
    "\7\3\1\305\4\3\1\306\14\3\30\0\13\3\1\0"+
    "\1\3\1\0\6\3\1\307\22\3\30\0\13\3\1\0"+
    "\1\3\1\0\12\3\1\310\16\3\30\0\13\3\1\0"+
    "\1\3\1\0\14\3\1\311\14\3\30\0\13\3\1\0"+
    "\1\3\1\0\1\3\1\312\27\3\30\0\13\3\1\0"+
    "\1\3\1\0\26\3\1\313\2\3\30\0\13\3\1\0"+
    "\1\3\1\0\7\3\1\314\21\3\30\0\13\3\1\0"+
    "\1\3\1\0\15\3\1\315\13\3\30\0\13\3\1\0"+
    "\1\3\1\0\6\3\1\316\22\3\30\0\13\3\1\0"+
    "\1\3\1\0\21\3\1\317\7\3\30\0\13\3\1\0"+
    "\1\3\1\0\7\3\1\320\21\3\32\0\3\243\1\0"+
    "\1\243\1\0\3\243\1\0\1\243\1\0\1\63\3\0"+
    "\3\243\3\0\2\243\5\0\1\243\3\0\1\63\33\0"+
    "\13\3\1\0\1\3\1\0\10\3\1\321\20\3\30\0"+
    "\13\3\1\0\1\3\1\0\27\3\1\322\1\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\323\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\324\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\325\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\326\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\7\3\1\327\21\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\330\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\331\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\332\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\333\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\334\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\17\3\1\335\11\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\336\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\337\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\26\3\1\340\2\3\30\0"+
    "\13\3\1\0\1\3\1\0\15\3\1\341\13\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\342\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\17\3\1\343\11\3\30\0"+
    "\13\3\1\0\1\3\1\0\10\3\1\344\20\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\345\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\346\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\347\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\350\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\351\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\352\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\3\3\1\353\25\3\30\0"+
    "\13\3\1\0\1\3\1\0\7\3\1\354\21\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\355\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\356\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\357\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\360\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\361\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\362\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\363\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\10\3\1\364\20\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\365\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\21\3\1\366\7\3\30\0"+
    "\13\3\1\0\1\3\1\0\7\3\1\367\21\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\370\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\371\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\372\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\373\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\2\3\1\374\26\3\30\0"+
    "\13\3\1\0\1\3\1\0\17\3\1\375\11\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\376\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\377\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u0100\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\5\3\1\u0101\23\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u0102\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\22\3\1\u0103\6\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u0104\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\7\3\1\u0105\21\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0106\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\u0107\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u0108\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\u0109\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\24\3\1\u010a\4\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\u010b\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u010c\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\10\3\1\u010d\20\3\30\0"+
    "\13\3\1\0\1\3\1\0\16\3\1\u010e\12\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\u010f\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\5\3\1\u0110\23\3\30\0"+
    "\13\3\1\0\1\3\1\0\14\3\1\u0111\14\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u0112\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\3\3\1\u0113\25\3\30\0"+
    "\13\3\1\0\1\3\1\0\6\3\1\u0114\22\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\u0115\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0116\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u0117\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u0118\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0119\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u011a\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\7\3\1\u011b\21\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u011c\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u011d\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\25\3\1\u011e\3\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u011f\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0120\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\13\3\1\u0121\15\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0122\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\11\3\1\u0123\17\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0124\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0125\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u0126\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\20\3\1\u0127\10\3\30\0"+
    "\13\3\1\0\1\3\1\0\4\3\1\u0128\24\3\30\0"+
    "\13\3\1\0\1\3\1\0\14\3\1\u0129\14\3\30\0"+
    "\13\3\1\0\1\3\1\0\1\3\1\u012a\27\3\30\0"+
    "\13\3\1\0\1\3\1\0\21\3\1\u012b\7\3\30\0"+
    "\13\3\1\0\1\3\1\0\30\3\1\u012c\30\0\13\3"+
    "\1\0\1\3\1\0\5\3\1\u012d\23\3\30\0\13\3"+
    "\1\0\1\3\1\0\10\3\1\u012e\20\3\30\0\13\3"+
    "\1\0\1\3\1\0\4\3\1\u012f\24\3\30\0\13\3"+
    "\1\0\1\3\1\0\21\3\1\u0130\7\3\27\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13923];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\32\1\1\11\5\1\12\11\1\1\4\11"+
    "\4\1\1\0\3\11\47\1\7\11\1\1\7\11\2\1"+
    "\1\0\1\11\56\1\1\11\1\0\215\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[304];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private boolean myAssertKeyword;
  private boolean myEnumKeyword;

  public _JavaLexer(LanguageLevel level) {
    this((java.io.Reader)null);
    myAssertKeyword = level.isAtLeast(LanguageLevel.JDK_1_4);
    myEnumKeyword = level.isAtLeast(LanguageLevel.JDK_1_5);
  }

  public void goTo(int offset) {
    zzCurrentPos = zzMarkedPos = zzStartRead = offset;
    zzAtEOF = false;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JavaLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return JavaTokenType.BAD_CHARACTER;
            } 
            // fall through
          case 105: break;
          case 2: 
            { return JavaTokenType.IDENTIFIER;
            } 
            // fall through
          case 106: break;
          case 3: 
            { return JavaTokenType.INTEGER_LITERAL;
            } 
            // fall through
          case 107: break;
          case 4: 
            { return JavaTokenType.DOT;
            } 
            // fall through
          case 108: break;
          case 5: 
            { return JavaTokenType.MINUS;
            } 
            // fall through
          case 109: break;
          case 6: 
            { return JavaTokenType.EQ;
            } 
            // fall through
          case 110: break;
          case 7: 
            { return JavaTokenType.EXCL;
            } 
            // fall through
          case 111: break;
          case 8: 
            { return JavaTokenType.OR;
            } 
            // fall through
          case 112: break;
          case 9: 
            { return JavaTokenType.PLUS;
            } 
            // fall through
          case 113: break;
          case 10: 
            { return JavaTokenType.LT;
            } 
            // fall through
          case 114: break;
          case 11: 
            { return JavaTokenType.GT;
            } 
            // fall through
          case 115: break;
          case 12: 
            { return JavaTokenType.AND;
            } 
            // fall through
          case 116: break;
          case 13: 
            { return JavaTokenType.ASTERISK;
            } 
            // fall through
          case 117: break;
          case 14: 
            { return JavaTokenType.DIV;
            } 
            // fall through
          case 118: break;
          case 15: 
            { return JavaTokenType.XOR;
            } 
            // fall through
          case 119: break;
          case 16: 
            { return JavaTokenType.PERC;
            } 
            // fall through
          case 120: break;
          case 17: 
            { return JavaTokenType.LPARENTH;
            } 
            // fall through
          case 121: break;
          case 18: 
            { return JavaTokenType.RPARENTH;
            } 
            // fall through
          case 122: break;
          case 19: 
            { return JavaTokenType.LBRACE;
            } 
            // fall through
          case 123: break;
          case 20: 
            { return JavaTokenType.RBRACE;
            } 
            // fall through
          case 124: break;
          case 21: 
            { return JavaTokenType.LBRACKET;
            } 
            // fall through
          case 125: break;
          case 22: 
            { return JavaTokenType.RBRACKET;
            } 
            // fall through
          case 126: break;
          case 23: 
            { return JavaTokenType.SEMICOLON;
            } 
            // fall through
          case 127: break;
          case 24: 
            { return JavaTokenType.COMMA;
            } 
            // fall through
          case 128: break;
          case 25: 
            { return JavaTokenType.TILDE;
            } 
            // fall through
          case 129: break;
          case 26: 
            { return JavaTokenType.QUEST;
            } 
            // fall through
          case 130: break;
          case 27: 
            { return JavaTokenType.COLON;
            } 
            // fall through
          case 131: break;
          case 28: 
            { return JavaTokenType.AT;
            } 
            // fall through
          case 132: break;
          case 29: 
            { return JavaTokenType.LONG_LITERAL;
            } 
            // fall through
          case 133: break;
          case 30: 
            { return JavaTokenType.FLOAT_LITERAL;
            } 
            // fall through
          case 134: break;
          case 31: 
            { return JavaTokenType.DOUBLE_LITERAL;
            } 
            // fall through
          case 135: break;
          case 32: 
            { return JavaTokenType.MINUSMINUS;
            } 
            // fall through
          case 136: break;
          case 33: 
            { return JavaTokenType.MINUSEQ;
            } 
            // fall through
          case 137: break;
          case 34: 
            { return JavaTokenType.ARROW;
            } 
            // fall through
          case 138: break;
          case 35: 
            { return JavaTokenType.IF_KEYWORD;
            } 
            // fall through
          case 139: break;
          case 36: 
            { return JavaTokenType.DO_KEYWORD;
            } 
            // fall through
          case 140: break;
          case 37: 
            { return JavaTokenType.EQEQ;
            } 
            // fall through
          case 141: break;
          case 38: 
            { return JavaTokenType.NE;
            } 
            // fall through
          case 142: break;
          case 39: 
            { return JavaTokenType.OREQ;
            } 
            // fall through
          case 143: break;
          case 40: 
            { return JavaTokenType.OROR;
            } 
            // fall through
          case 144: break;
          case 41: 
            { return JavaTokenType.PLUSEQ;
            } 
            // fall through
          case 145: break;
          case 42: 
            { return JavaTokenType.PLUSPLUS;
            } 
            // fall through
          case 146: break;
          case 43: 
            { return JavaTokenType.LE;
            } 
            // fall through
          case 147: break;
          case 44: 
            { return JavaTokenType.LTLT;
            } 
            // fall through
          case 148: break;
          case 45: 
            { return JavaTokenType.ANDEQ;
            } 
            // fall through
          case 149: break;
          case 46: 
            { return JavaTokenType.ANDAND;
            } 
            // fall through
          case 150: break;
          case 47: 
            { return JavaTokenType.ASTERISKEQ;
            } 
            // fall through
          case 151: break;
          case 48: 
            { return JavaTokenType.DIVEQ;
            } 
            // fall through
          case 152: break;
          case 49: 
            { return JavaTokenType.XOREQ;
            } 
            // fall through
          case 153: break;
          case 50: 
            { return JavaTokenType.PERCEQ;
            } 
            // fall through
          case 154: break;
          case 51: 
            { return JavaTokenType.DOUBLE_COLON;
            } 
            // fall through
          case 155: break;
          case 52: 
            { return JavaTokenType.ELLIPSIS;
            } 
            // fall through
          case 156: break;
          case 53: 
            { return JavaTokenType.TRY_KEYWORD;
            } 
            // fall through
          case 157: break;
          case 54: 
            { return JavaTokenType.FOR_KEYWORD;
            } 
            // fall through
          case 158: break;
          case 55: 
            { return JavaTokenType.NEW_KEYWORD;
            } 
            // fall through
          case 159: break;
          case 56: 
            { return JavaTokenType.INT_KEYWORD;
            } 
            // fall through
          case 160: break;
          case 57: 
            { return JavaTokenType.LTLTEQ;
            } 
            // fall through
          case 161: break;
          case 58: 
            { return JavaTokenType.TRUE_KEYWORD;
            } 
            // fall through
          case 162: break;
          case 59: 
            { return JavaTokenType.THIS_KEYWORD;
            } 
            // fall through
          case 163: break;
          case 60: 
            { return JavaTokenType.ELSE_KEYWORD;
            } 
            // fall through
          case 164: break;
          case 61: 
            { return myEnumKeyword ? JavaTokenType.ENUM_KEYWORD : JavaTokenType.IDENTIFIER;
            } 
            // fall through
          case 165: break;
          case 62: 
            { return JavaTokenType.LONG_KEYWORD;
            } 
            // fall through
          case 166: break;
          case 63: 
            { return JavaTokenType.NULL_KEYWORD;
            } 
            // fall through
          case 167: break;
          case 64: 
            { return JavaTokenType.BYTE_KEYWORD;
            } 
            // fall through
          case 168: break;
          case 65: 
            { return JavaTokenType.CASE_KEYWORD;
            } 
            // fall through
          case 169: break;
          case 66: 
            { return JavaTokenType.CHAR_KEYWORD;
            } 
            // fall through
          case 170: break;
          case 67: 
            { return JavaTokenType.GOTO_KEYWORD;
            } 
            // fall through
          case 171: break;
          case 68: 
            { return JavaTokenType.VOID_KEYWORD;
            } 
            // fall through
          case 172: break;
          case 69: 
            { return JavaTokenType.THROW_KEYWORD;
            } 
            // fall through
          case 173: break;
          case 70: 
            { return JavaTokenType.FALSE_KEYWORD;
            } 
            // fall through
          case 174: break;
          case 71: 
            { return JavaTokenType.FLOAT_KEYWORD;
            } 
            // fall through
          case 175: break;
          case 72: 
            { return JavaTokenType.FINAL_KEYWORD;
            } 
            // fall through
          case 176: break;
          case 73: 
            { return JavaTokenType.SUPER_KEYWORD;
            } 
            // fall through
          case 177: break;
          case 74: 
            { return JavaTokenType.SHORT_KEYWORD;
            } 
            // fall through
          case 178: break;
          case 75: 
            { return JavaTokenType.BREAK_KEYWORD;
            } 
            // fall through
          case 179: break;
          case 76: 
            { return JavaTokenType.CATCH_KEYWORD;
            } 
            // fall through
          case 180: break;
          case 77: 
            { return JavaTokenType.CLASS_KEYWORD;
            } 
            // fall through
          case 181: break;
          case 78: 
            { return JavaTokenType.CONST_KEYWORD;
            } 
            // fall through
          case 182: break;
          case 79: 
            { return JavaTokenType.WHILE_KEYWORD;
            } 
            // fall through
          case 183: break;
          case 80: 
            { return JavaTokenType.THROWS_KEYWORD;
            } 
            // fall through
          case 184: break;
          case 81: 
            { return JavaTokenType.RETURN_KEYWORD;
            } 
            // fall through
          case 185: break;
          case 82: 
            { return myAssertKeyword ? JavaTokenType.ASSERT_KEYWORD : JavaTokenType.IDENTIFIER;
            } 
            // fall through
          case 186: break;
          case 83: 
            { return JavaTokenType.STATIC_KEYWORD;
            } 
            // fall through
          case 187: break;
          case 84: 
            { return JavaTokenType.SWITCH_KEYWORD;
            } 
            // fall through
          case 188: break;
          case 85: 
            { return JavaTokenType.NATIVE_KEYWORD;
            } 
            // fall through
          case 189: break;
          case 86: 
            { return JavaTokenType.IMPORT_KEYWORD;
            } 
            // fall through
          case 190: break;
          case 87: 
            { return JavaTokenType.DOUBLE_KEYWORD;
            } 
            // fall through
          case 191: break;
          case 88: 
            { return JavaTokenType.PUBLIC_KEYWORD;
            } 
            // fall through
          case 192: break;
          case 89: 
            { return JavaTokenType.EXTENDS_KEYWORD;
            } 
            // fall through
          case 193: break;
          case 90: 
            { return JavaTokenType.FINALLY_KEYWORD;
            } 
            // fall through
          case 194: break;
          case 91: 
            { return JavaTokenType.BOOLEAN_KEYWORD;
            } 
            // fall through
          case 195: break;
          case 92: 
            { return JavaTokenType.DEFAULT_KEYWORD;
            } 
            // fall through
          case 196: break;
          case 93: 
            { return JavaTokenType.PRIVATE_KEYWORD;
            } 
            // fall through
          case 197: break;
          case 94: 
            { return JavaTokenType.PACKAGE_KEYWORD;
            } 
            // fall through
          case 198: break;
          case 95: 
            { return JavaTokenType.ABSTRACT_KEYWORD;
            } 
            // fall through
          case 199: break;
          case 96: 
            { return JavaTokenType.STRICTFP_KEYWORD;
            } 
            // fall through
          case 200: break;
          case 97: 
            { return JavaTokenType.CONTINUE_KEYWORD;
            } 
            // fall through
          case 201: break;
          case 98: 
            { return JavaTokenType.VOLATILE_KEYWORD;
            } 
            // fall through
          case 202: break;
          case 99: 
            { return JavaTokenType.TRANSIENT_KEYWORD;
            } 
            // fall through
          case 203: break;
          case 100: 
            { return JavaTokenType.INTERFACE_KEYWORD;
            } 
            // fall through
          case 204: break;
          case 101: 
            { return JavaTokenType.PROTECTED_KEYWORD;
            } 
            // fall through
          case 205: break;
          case 102: 
            { return JavaTokenType.INSTANCEOF_KEYWORD;
            } 
            // fall through
          case 206: break;
          case 103: 
            { return JavaTokenType.IMPLEMENTS_KEYWORD;
            } 
            // fall through
          case 207: break;
          case 104: 
            { return JavaTokenType.SYNCHRONIZED_KEYWORD;
            } 
            // fall through
          case 208: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
